
set(LICENSE_LEVEL 0)

function(setLicense LICENSE_CODE)
    if(${LICENSE_LEVEL} LESS ${LICENSE_CODE})
        set(LICENSE_LEVEL ${LICENSE_CODE} PARENT_SCOPE)
    endif()
endfunction()

set(LICENSE_ZLIB 0)
set(LICENSE_MIT 0)
set(LICENSE_BSD 0)
set(LICENSE_PUBLICDOMAIN 0)
set(LICENSE_LGPL_2_1p 1)
set(LICENSE_LGPL_3p 2)
set(LICENSE_GPL_2p 3)
set(LICENSE_GPL_3p 4)

function(printLicense)
    if(${LICENSE_LEVEL} EQUAL 0)
        set(LIC_NAME "ZLib")
    elseif(${LICENSE_LEVEL} EQUAL 1)
        set(LIC_NAME "LGPLv2.1+")
    elseif(${LICENSE_LEVEL} EQUAL 2)
        set(LIC_NAME "LGPLv3+")
    elseif(${LICENSE_LEVEL} EQUAL 3)
        set(LIC_NAME "GPLv2+")
    elseif(${LICENSE_LEVEL} EQUAL 4)
        set(LIC_NAME "GPLv3+")
    endif()

    message("===============================================================================")
    message("                  License for this library build is ${LIC_NAME}.")
    message("===============================================================================")
endfunction()
