/*
 * PGE File Library - a library to process file formats, part of Moondust project
 *
 * Copyright (c) 2014-2025 Vitaly Novichkov <admin@wohlnet.ru>
 *
 * The MIT License (MIT)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#pragma once
#ifndef PGE_FILE_LIB_SYS_H_
#define PGE_FILE_LIB_SYS_H_

/*!
 * \file pge_file_lib_sys.h
 * \brief Contains internally used global haders lists
 *
 */

#ifdef PGE_FILES_QT
#include <QtGlobal>
#ifndef PGEFL_QRegExp
#   if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
#       include <QRegularExpression>
#       define PGEFL_QRegExp QRegularExpression
#   else
#       include <QRegExp>
#       define PGEFL_QRegExp QRegExp
#   endif
#endif
#include <QFileInfo>
#include <QFile>
#include <QFileInfo>
#include <QDir>
#include <QTextStream>
#include <QtDebug>
#else
#include <fstream>
#include <iostream>
#include <stdlib.h>
#include <limits.h> /* PATH_MAX */
#endif

#endif // PGE_FILE_LIB_SYS_H_
