# message("Path to DirManager is [${CMAKE_CURRENT_LIST_DIR}]")
include(CheckFunctionExists)

include_directories(${CMAKE_CURRENT_LIST_DIR}/include)

set(DIRMANAGER_SRCS)

list(APPEND DIRMANAGER_SRCS
    ${CMAKE_CURRENT_LIST_DIR}/src/dirman.cpp
    ${CMAKE_CURRENT_LIST_DIR}/include/DirManager/dirman.h
    ${CMAKE_CURRENT_LIST_DIR}/src/dirman_private.h
)

if(WIN32)
    message("-- DirMan for Windows")
    list(APPEND DIRMANAGER_SRCS ${CMAKE_CURRENT_LIST_DIR}/src/dirman_winapi.cpp)
#elseif(NINTENDO_SWITCH OR NINTENDO_3DS OR NINTENDO_WII OR PGE_MIN_PORT)
#    message("-- DirMan for Devkit Pro")
#    list(APPEND DIRMANAGER_SRCS ${CMAKE_CURRENT_LIST_DIR}/dirman_dkp.cpp)
elseif(VITA)
    message("-- DirMan for Vita")
    list(APPEND DIRMANAGER_SRCS ${CMAKE_CURRENT_LIST_DIR}/src/dirman_vitafs.cpp)
elseif(PSP)
    message("-- DirMan for PSP")
    list(APPEND DIRMANAGER_SRCS ${CMAKE_CURRENT_LIST_DIR}/src/dirman_vitafs.cpp)
#elseif(APPLE AND CMAKE_HOST_SYSTEM_VERSION VERSION_LESS 9)
#    message("-- DirMan for older POSIX systems")
#    list(APPEND DIRMANAGER_SRCS ${CMAKE_CURRENT_LIST_DIR}/dirman_tiger.cpp)
else()
    message("-- DirMan for POSIX systems")
    list(APPEND DIRMANAGER_SRCS ${CMAKE_CURRENT_LIST_DIR}/src/dirman_posix.cpp)

    check_function_exists(fstatat DIRMAN_HAS_FSSTATAT)
    if(DIRMAN_HAS_FSSTATAT)
        add_definitions(-DDIRMAN_HAS_FSSTATAT)
    endif()

    if(NOT NINTENDO_WII AND NOT NINTENDO_WIIU AND NOT NINTENDO_3DS AND NOT NINTENDO_SWITCH)
        check_function_exists(realpath DIRMAN_HAS_REALPATH)
        if(DIRMAN_HAS_REALPATH)
            add_definitions(-DDIRMAN_HAS_REALPATH)
        endif()
    endif()
endif()
