#!/bin/sh

input="$1"
output="$2"

echo "wopn2hpp"
if [ "+$input" = "+" ]
then
    echo "Usage: $0 input.wopn [output.h]"
else
    if [ "+$output" = "+" ]
    then
        output="$input.h"
    fi
    truncate -s 0 "$output"

    bankbit=$(echo "$input" | sed -e 's/\./_/g;s/-/_/g;s/wopn$//')
    {
        printf "/*===============================================================*\n"
        printf "   This file is automatically generated by wopn2hpp.sh script\n"
        printf "   PLEASE DON'T EDIT THIS DIRECTLY. Edit the gm.wopn file first,\n"
        printf "   and then run a wopn2hpp.sh script to generate this file again\n"
        printf " *===============================================================*/\n\n"
        printf "static unsigned char g_"$bankbit"_bank[] = \n"
        printf "{\n"
        hexdump -ve '"\t" 12/1 "0x%02x, " "\n"' "$input"
        printf "\t0x00\n"
        printf "};\n"
        printf "\n"
    } > "$output"

    sed -i -e "s/0x  /0x00/g" "$output"
fi

