#ifndef __VGMFILE_H__
#define __VGMFILE_H__

// Header file for VGM file handling
#include "vgm_stdtype.h"

typedef struct _vgm_file_header
{
    UINT32 fccVGM;
    UINT32 lngEOFOffset;
    UINT32 lngVersion;
    UINT32 lngHzPSG;
    UINT32 lngHzYM2413;
    UINT32 lngGD3Offset;
    UINT32 lngTotalSamples;
    UINT32 lngLoopOffset;
    UINT32 lngLoopSamples;
    UINT32 lngRate;
    UINT16 shtPSG_Feedback;
    UINT8 bytPSG_SRWidth;
    UINT8 bytPSG_Flags;
    UINT32 lngHzYM2612;
    UINT32 lngHzYM2151;
    UINT32 lngDataOffset;
    UINT32 lngHzSPCM;
    UINT32 lngSPCMIntf;
    UINT32 lngHzRF5C68;
    UINT32 lngHzYM2203;
    UINT32 lngHzYM2608;
    UINT32 lngHzYM2610;
    UINT32 lngHzYM3812;
    UINT32 lngHzYM3526;
    UINT32 lngHzY8950;
    UINT32 lngHzYMF262;
    UINT32 lngHzYMF278B;
    UINT32 lngHzYMF271;
    UINT32 lngHzYMZ280B;
    UINT32 lngHzRF5C164;
    UINT32 lngHzPWM;
    UINT32 lngHzAY8910;
    UINT8 bytAYType;
    UINT8 bytAYFlag;
    UINT8 bytAYFlagYM2203;
    UINT8 bytAYFlagYM2608;
    UINT8 bytVolumeModifier;
    UINT8 bytReserved2;
    INT8 bytLoopBase;
    UINT8 bytLoopModifier;
    UINT32 lngHzGBDMG;
    UINT32 lngHzNESAPU;
    UINT32 lngHzMultiPCM;
    UINT32 lngHzUPD7759;
    UINT32 lngHzOKIM6258;
    UINT8 bytOKI6258Flags;
    UINT8 bytK054539Flags;
    UINT8 bytC140Type;
    UINT8 bytReservedFlags;
    UINT32 lngHzOKIM6295;
    UINT32 lngHzK051649;
    UINT32 lngHzK054539;
    UINT32 lngHzHuC6280;
    UINT32 lngHzC140;
    UINT32 lngHzK053260;
    UINT32 lngHzPokey;
    UINT32 lngHzQSound;
    UINT32 lngHzSCSP;
    //  UINT32 lngHzOKIM6376;
    //UINT8 bytReserved[0x04];
    UINT32 lngExtraOffset;
    UINT32 lngHzWSwan;
    UINT32 lngHzVSU;
    UINT32 lngHzSAA1099;
    UINT32 lngHzES5503;
    UINT32 lngHzES5506;
    UINT8 bytES5503Chns;
    UINT8 bytES5506Chns;
    UINT8 bytC352ClkDiv;
    UINT8 bytESReserved;
    UINT32 lngHzX1_010;
    UINT32 lngHzC352;
    UINT32 lngHzGA20;
} VGM_HEADER;
typedef struct _vgm_header_extra
{
    UINT32 DataSize;
    UINT32 Chp2ClkOffset;
    UINT32 ChpVolOffset;
} VGM_HDR_EXTRA;
typedef struct _vgm_extra_chip_data32
{
    UINT8 Type;
    UINT32 Data;
} VGMX_CHIP_DATA32;
typedef struct _vgm_extra_chip_data16
{
    UINT8 Type;
    UINT8 Flags;
    UINT16 Data;
} VGMX_CHIP_DATA16;
typedef struct _vgm_extra_chip_extra32
{
    UINT8 ChipCnt;
    VGMX_CHIP_DATA32 *CCData;
} VGMX_CHP_EXTRA32;
typedef struct _vgm_extra_chip_extra16
{
    UINT8 ChipCnt;
    VGMX_CHIP_DATA16 *CCData;
} VGMX_CHP_EXTRA16;
typedef struct _vgm_header_extra_data
{
    VGMX_CHP_EXTRA32 Clocks;
    VGMX_CHP_EXTRA16 Volumes;
} VGM_EXTRA;

#define VOLUME_MODIF_WRAP   0xC0
typedef struct _vgm_gd3_tag
{
    UINT32 fccGD3;
    UINT32 lngVersion;
    UINT32 lngTagLength;
    wchar_t *strTrackNameE;
    wchar_t *strTrackNameJ;
    wchar_t *strGameNameE;
    wchar_t *strGameNameJ;
    wchar_t *strSystemNameE;
    wchar_t *strSystemNameJ;
    wchar_t *strAuthorNameE;
    wchar_t *strAuthorNameJ;
    wchar_t *strReleaseDate;
    wchar_t *strCreator;
    wchar_t *strNotes;
} GD3_TAG;
typedef struct _vgm_pcm_bank_data
{
    UINT32 DataSize;
    UINT8 *Data;
    UINT32 DataStart;
} VGM_PCM_DATA;
typedef struct _vgm_pcm_bank
{
    UINT32 BankCount;
    VGM_PCM_DATA *Bank;
    UINT32 DataSize;
    UINT8 *Data;
    UINT32 DataPos;
    UINT32 BnkPos;
} VGM_PCM_BANK;

#define FCC_VGM 0x206D6756  // 'Vgm '
#define FCC_GD3 0x20336447  // 'Gd3 '

#endif  // __VGMFILE_H__
