/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2025 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.feature.palette_tools.presentation.components.model

import com.t8rin.palette.PaletteFormat

object PaletteFormatHelper {
    val entries: List<PaletteFormat> =
        PaletteFormat.entries.toSet().minus(
            setOf(
                PaletteFormat.CSV,
                PaletteFormat.HEX_RGBA
            )
        ).plus(
            setOf(
                PaletteFormat.HEX_RGBA,
                PaletteFormat.CSV
            )
        ).toList()

    fun entriesFor(filename: String): Set<PaletteFormat> = buildSet {
        PaletteFormat.fromFilename(filename)?.let {
            add(it)
            addAll(entries - it)
        } ?: addAll(entries)
    }
}