/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2024 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Rounded.StampedLine: ImageVector by lazy {
    ImageVector.Builder(
        name = "StampedLine",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(7.427f, 17.754f)
            curveToRelative(0.116f, 0.124f, 0.118f, 0.317f, 0.003f, 0.443f)
            lineToRelative(0f, 0f)
            curveToRelative(-0.072f, 0.079f, -0.101f, 0.189f, -0.077f, 0.294f)
            lineToRelative(0f, 0f)
            curveToRelative(0.039f, 0.166f, -0.057f, 0.333f, -0.219f, 0.385f)
            lineToRelative(0f, 0f)
            curveToRelative(-0.102f, 0.033f, -0.182f, 0.113f, -0.213f, 0.216f)
            lineToRelative(0f, 0f)
            curveToRelative(-0.05f, 0.163f, -0.216f, 0.26f, -0.382f, 0.224f)
            lineToRelative(0f, 0f)
            curveToRelative(-0.105f, -0.023f, -0.214f, 0.007f, -0.293f, 0.081f)
            lineToRelative(0f, 0f)
            curveToRelative(-0.124f, 0.116f, -0.317f, 0.118f, -0.443f, 0.003f)
            lineToRelative(0f, 0f)
            curveToRelative(-0.079f, -0.072f, -0.189f, -0.101f, -0.294f, -0.077f)
            lineToRelative(0f, 0f)
            curveToRelative(-0.166f, 0.039f, -0.333f, -0.057f, -0.385f, -0.219f)
            lineToRelative(0f, 0f)
            curveToRelative(-0.033f, -0.102f, -0.113f, -0.182f, -0.216f, -0.213f)
            lineToRelative(0f, 0f)
            curveToRelative(-0.163f, -0.05f, -0.26f, -0.216f, -0.224f, -0.382f)
            lineToRelative(0f, 0f)
            curveToRelative(0.023f, -0.105f, -0.007f, -0.214f, -0.081f, -0.293f)
            lineToRelative(0f, 0f)
            curveToRelative(-0.116f, -0.124f, -0.118f, -0.317f, -0.003f, -0.443f)
            lineToRelative(0f, 0f)
            curveToRelative(0.072f, -0.079f, 0.101f, -0.189f, 0.077f, -0.294f)
            lineToRelative(0f, 0f)
            curveToRelative(-0.039f, -0.166f, 0.057f, -0.333f, 0.219f, -0.385f)
            lineToRelative(0f, 0f)
            curveToRelative(0.102f, -0.033f, 0.182f, -0.113f, 0.213f, -0.216f)
            lineToRelative(0f, 0f)
            curveToRelative(0.05f, -0.163f, 0.216f, -0.26f, 0.382f, -0.224f)
            lineToRelative(0f, 0f)
            curveToRelative(0.105f, 0.023f, 0.214f, -0.007f, 0.293f, -0.081f)
            lineToRelative(0f, 0f)
            curveToRelative(0.124f, -0.116f, 0.317f, -0.118f, 0.443f, -0.003f)
            lineToRelative(0f, 0f)
            curveToRelative(0.079f, 0.072f, 0.189f, 0.101f, 0.294f, 0.077f)
            lineToRelative(0f, 0f)
            curveToRelative(0.166f, -0.039f, 0.333f, 0.057f, 0.385f, 0.219f)
            lineToRelative(0f, 0f)
            curveToRelative(0.033f, 0.102f, 0.113f, 0.182f, 0.216f, 0.213f)
            lineToRelative(0f, 0f)
            curveToRelative(0.163f, 0.05f, 0.26f, 0.216f, 0.224f, 0.382f)
            lineToRelative(0f, 0f)
            curveTo(7.324f, 17.566f, 7.354f, 17.676f, 7.427f, 17.754f)
            lineTo(7.427f, 17.754f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(18.015f, 4.515f)
            curveToRelative(-0.022f, -0.011f, -0.048f, -0.011f, -0.07f, 0.002f)
            curveToRelative(-0.123f, 0.071f, -0.537f, 0.306f, -0.629f, 0.306f)
            curveToRelative(-0.076f, 0f, -0.432f, -0.158f, -0.642f, -0.254f)
            curveToRelative(-0.059f, -0.027f, -0.12f, 0.029f, -0.1f, 0.09f)
            curveToRelative(0.078f, 0.233f, 0.21f, 0.639f, 0.187f, 0.678f)
            curveToRelative(-0.029f, 0.047f, -0.214f, 0.527f, -0.264f, 0.654f)
            curveToRelative(-0.008f, 0.02f, -0.006f, 0.041f, 0.004f, 0.06f)
            curveToRelative(0.062f, 0.117f, 0.286f, 0.554f, 0.268f, 0.652f)
            curveToRelative(-0.015f, 0.08f, -0.15f, 0.435f, -0.228f, 0.638f)
            curveToRelative(-0.022f, 0.058f, 0.032f, 0.115f, 0.091f, 0.096f)
            curveToRelative(0.224f, -0.071f, 0.632f, -0.2f, 0.668f, -0.2f)
            curveToRelative(0.044f, 0f, 0.563f, 0.212f, 0.69f, 0.264f)
            curveToRelative(0.018f, 0.008f, 0.038f, 0.007f, 0.056f, 0f)
            curveToRelative(0.129f, -0.054f, 0.664f, -0.277f, 0.686f, -0.277f)
            curveToRelative(0.018f, 0f, 0.369f, 0.134f, 0.569f, 0.211f)
            curveToRelative(0.056f, 0.022f, 0.113f, -0.03f, 0.097f, -0.088f)
            curveToRelative(-0.058f, -0.209f, -0.16f, -0.584f, -0.157f, -0.628f)
            curveToRelative(0.004f, -0.055f, 0.198f, -0.573f, 0.248f, -0.704f)
            curveToRelative(0.007f, -0.019f, 0.006f, -0.04f, -0.003f, -0.059f)
            curveToRelative(-0.057f, -0.114f, -0.265f, -0.537f, -0.261f, -0.645f)
            curveToRelative(0.003f, -0.085f, 0.122f, -0.434f, 0.198f, -0.646f)
            curveToRelative(0.022f, -0.062f, -0.042f, -0.119f, -0.101f, -0.091f)
            curveToRelative(-0.218f, 0.104f, -0.583f, 0.277f, -0.615f, 0.277f)
            curveTo(18.667f, 4.852f, 18.155f, 4.588f, 18.015f, 4.515f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(7.424f, 15.775f)
            curveToRelative(0f, 0.399f, 0.321f, 0.722f, 0.717f, 0.722f)
            curveToRelative(0.108f, 0f, 0.21f, -0.024f, 0.302f, -0.067f)
            curveToRelative(0f, 0f, 0.001f, -0f, 0.002f, -0.001f)
            curveToRelative(0.009f, -0.004f, 0.017f, -0.008f, 0.026f, -0.013f)
            curveToRelative(0.085f, -0.041f, 0.346f, -0.165f, 0.468f, -0.174f)
            curveToRelative(0.146f, -0.011f, 0.403f, 0.068f, 0.403f, 0.068f)
            lineToRelative(0.216f, 0.104f)
            curveToRelative(0.014f, 0.007f, 0.028f, 0.014f, 0.043f, 0.021f)
            lineToRelative(0.001f, 0f)
            horizontalLineToRelative(0f)
            curveToRelative(0.061f, 0.027f, 0.125f, 0.045f, 0.193f, 0.054f)
            horizontalLineToRelative(0f)
            lineToRelative(0f, 0f)
            curveToRelative(0.018f, 0.002f, 0.036f, 0.004f, 0.055f, 0.005f)
            horizontalLineToRelative(0f)
            curveToRelative(0.013f, 0.001f, 0.026f, 0.001f, 0.039f, 0.001f)
            curveToRelative(0.396f, 0f, 0.717f, -0.324f, 0.717f, -0.722f)
            verticalLineTo(15.772f)
            curveToRelative(0f, -0.135f, -0.037f, -0.262f, -0.101f, -0.37f)
            lineTo(9.664f, 13.902f)
            curveToRelative(-0.118f, -0.237f, -0.361f, -0.4f, -0.642f, -0.4f)
            curveToRelative(-0.281f, 0f, -0.524f, 0.163f, -0.642f, 0.4f)
            lineToRelative(-0.839f, 1.473f)
            curveToRelative(-0.016f, 0.024f, -0.03f, 0.05f, -0.043f, 0.076f)
            lineTo(7.498f, 15.452f)
            curveToRelative(-0.047f, 0.096f, -0.074f, 0.205f, -0.074f, 0.32f)
            verticalLineToRelative(0.003f)
            horizontalLineTo(7.424f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(12f, 10.5f)
            curveToRelative(-0.828f, 0f, -1.5f, 0.672f, -1.5f, 1.5f)
            curveToRelative(0f, 0.014f, 0f, 0.029f, 0.001f, 0.043f)
            curveTo(10.5f, 12.05f, 10.5f, 12.057f, 10.5f, 12.064f)
            verticalLineToRelative(1.085f)
            curveTo(10.5f, 13.343f, 10.657f, 13.5f, 10.851f, 13.5f)
            horizontalLineToRelative(1.105f)
            curveToRelative(0.005f, 0f, 0.01f, -0f, 0.014f, -0f)
            curveTo(11.98f, 13.5f, 11.99f, 13.5f, 12f, 13.5f)
            curveToRelative(0.828f, 0f, 1.5f, -0.672f, 1.5f, -1.5f)
            reflectiveCurveTo(12.828f, 10.5f, 12f, 10.5f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(16.132f, 10.14f)
            curveToRelative(0f, 0f, -0.096f, -0.124f, 0f, -0.301f)
            curveToRelative(0.599f, -0.999f, 0.285f, -2.17f, 0.285f, -2.17f)
            lineToRelative(-0.285f, 0.204f)
            curveToRelative(0f, 0f, -0.131f, 0.088f, -0.293f, 0f)
            curveToRelative(-1.002f, -0.598f, -2.177f, -0.285f, -2.177f, -0.285f)
            lineToRelative(0.205f, 0.285f)
            curveToRelative(0f, 0f, 0.105f, 0.107f, 0f, 0.302f)
            curveToRelative(-0.004f, 0.006f, -0.006f, 0.012f, -0.01f, 0.017f)
            curveToRelative(-0.586f, 0.995f, -0.275f, 2.153f, -0.275f, 2.153f)
            lineToRelative(0.285f, -0.204f)
            curveToRelative(0f, 0f, 0.124f, -0.092f, 0.293f, 0f)
            curveToRelative(1.002f, 0.598f, 2.177f, 0.285f, 2.177f, 0.285f)
            lineTo(16.132f, 10.14f)
            close()
        }
    }.build()
}
