/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2024 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Filled.Shadow: ImageVector by lazy {
    Builder(
        name = "Shadow", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
        viewportWidth = 24.0f, viewportHeight = 24.0f
    ).apply {
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(19.0f, 16.0f)
            lineToRelative(2.0f, 0.0f)
            lineToRelative(0.0f, 2.0f)
            lineToRelative(-2.0f, 0.0f)
            lineToRelative(0.0f, -2.0f)
        }
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(19.0f, 13.0f)
            lineToRelative(2.0f, 0.0f)
            lineToRelative(0.0f, 2.0f)
            lineToRelative(-2.0f, 0.0f)
            lineToRelative(0.0f, -2.0f)
        }
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(19.0f, 10.0f)
            lineToRelative(2.0f, 0.0f)
            lineToRelative(0.0f, 2.0f)
            lineToRelative(-2.0f, 0.0f)
            lineToRelative(0.0f, -2.0f)
        }
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(16.0f, 19.0f)
            lineToRelative(2.0f, 0.0f)
            lineToRelative(0.0f, 2.0f)
            lineToRelative(-2.0f, 0.0f)
            lineToRelative(0.0f, -2.0f)
        }
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(13.0f, 19.0f)
            lineToRelative(2.0f, 0.0f)
            lineToRelative(0.0f, 2.0f)
            lineToRelative(-2.0f, 0.0f)
            lineToRelative(0.0f, -2.0f)
        }
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(10.0f, 19.0f)
            lineToRelative(2.0f, 0.0f)
            lineToRelative(0.0f, 2.0f)
            lineToRelative(-2.0f, 0.0f)
            lineToRelative(0.0f, -2.0f)
        }
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(16.9985f, 3.0f)
            horizontalLineTo(4.0016f)
            curveTo(3.4484f, 3.0f, 3.0f, 3.4484f, 3.0f, 4.0016f)
            verticalLineToRelative(12.9968f)
            curveTo(3.0f, 17.5516f, 3.4484f, 18.0f, 4.0016f, 18.0f)
            horizontalLineTo(18.0f)
            verticalLineTo(4.0016f)
            curveTo(18.0f, 3.4484f, 17.5516f, 3.0f, 16.9985f, 3.0f)
            close()
        }
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(21.0f, 20.0076f)
            verticalLineTo(19.0f)
            horizontalLineToRelative(-2.0f)
            verticalLineToRelative(2.0f)
            horizontalLineToRelative(1.0079f)
            curveTo(20.5544f, 20.9955f, 20.9956f, 20.5542f, 21.0f, 20.0076f)
            close()
        }
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(7.0f, 19.0f)
            verticalLineToRelative(1.0079f)
            curveTo(7.0045f, 20.5543f, 7.4457f, 20.9955f, 7.9921f, 21.0f)
            horizontalLineTo(9.0f)
            verticalLineToRelative(-2.0f)
            horizontalLineTo(7.0f)
            close()
        }
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(20.0f, 7.0f)
            horizontalLineToRelative(-1.0f)
            verticalLineToRelative(2.0f)
            horizontalLineToRelative(2.0f)
            verticalLineTo(7.994f)
            curveTo(20.9956f, 7.4446f, 20.5504f, 7.0f, 20.0f, 7.0f)
            close()
        }
    }.build()
}