/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2025 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Rounded.ServiceToolbox: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Rounded.ServiceToolbox",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(160f, 800f)
            quadTo(127f, 800f, 103.5f, 776.5f)
            quadTo(80f, 753f, 80f, 720f)
            lineTo(80f, 560f)
            lineTo(280f, 560f)
            lineTo(280f, 560f)
            quadTo(280f, 577f, 291.5f, 588.5f)
            quadTo(303f, 600f, 320f, 600f)
            quadTo(336f, 600f, 342.5f, 585.5f)
            quadTo(349f, 571f, 360f, 560f)
            lineTo(360f, 560f)
            lineTo(600f, 560f)
            lineTo(600f, 560f)
            quadTo(600f, 577f, 611.5f, 588.5f)
            quadTo(623f, 600f, 640f, 600f)
            quadTo(656f, 600f, 662.5f, 585.5f)
            quadTo(669f, 571f, 680f, 560f)
            lineTo(680f, 560f)
            lineTo(880f, 560f)
            lineTo(880f, 720f)
            quadTo(880f, 753f, 856.5f, 776.5f)
            quadTo(833f, 800f, 800f, 800f)
            lineTo(160f, 800f)
            close()
            moveTo(97f, 480f)
            lineTo(180f, 288f)
            quadTo(189f, 266f, 209f, 253f)
            quadTo(229f, 240f, 252f, 240f)
            lineTo(280f, 240f)
            lineTo(280f, 200f)
            quadTo(280f, 167f, 303.5f, 143.5f)
            quadTo(327f, 120f, 360f, 120f)
            lineTo(600f, 120f)
            quadTo(633f, 120f, 656.5f, 143.5f)
            quadTo(680f, 167f, 680f, 200f)
            lineTo(680f, 240f)
            lineTo(708f, 240f)
            quadTo(731f, 240f, 751f, 253f)
            quadTo(771f, 266f, 780f, 288f)
            lineTo(863f, 480f)
            lineTo(680f, 480f)
            lineTo(680f, 480f)
            quadTo(680f, 463f, 668.5f, 451.5f)
            quadTo(657f, 440f, 640f, 440f)
            quadTo(624f, 440f, 617.5f, 454.5f)
            quadTo(611f, 469f, 600f, 480f)
            lineTo(600f, 480f)
            lineTo(360f, 480f)
            lineTo(360f, 480f)
            quadTo(360f, 463f, 348.5f, 451.5f)
            quadTo(337f, 440f, 320f, 440f)
            quadTo(304f, 440f, 297.5f, 454.5f)
            quadTo(291f, 469f, 280f, 480f)
            lineTo(280f, 480f)
            lineTo(97f, 480f)
            close()
            moveTo(360f, 240f)
            lineTo(600f, 240f)
            lineTo(600f, 200f)
            lineTo(360f, 200f)
            lineTo(360f, 240f)
            close()
        }
    }.build()
}

val Icons.Outlined.ServiceToolbox: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Outlined.ServiceToolbox",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(280f, 240f)
            lineTo(280f, 200f)
            quadTo(280f, 167f, 303.5f, 143.5f)
            quadTo(327f, 120f, 360f, 120f)
            lineTo(600f, 120f)
            quadTo(633f, 120f, 656.5f, 143.5f)
            quadTo(680f, 167f, 680f, 200f)
            lineTo(680f, 240f)
            lineTo(708f, 240f)
            quadTo(731f, 240f, 751f, 253f)
            quadTo(771f, 266f, 780f, 288f)
            lineTo(874f, 504f)
            quadTo(877f, 512f, 878.5f, 520f)
            quadTo(880f, 528f, 880f, 536f)
            lineTo(880f, 720f)
            quadTo(880f, 753f, 856.5f, 776.5f)
            quadTo(833f, 800f, 800f, 800f)
            lineTo(160f, 800f)
            quadTo(127f, 800f, 103.5f, 776.5f)
            quadTo(80f, 753f, 80f, 720f)
            lineTo(80f, 536f)
            quadTo(80f, 528f, 81.5f, 520f)
            quadTo(83f, 512f, 86f, 504f)
            lineTo(180f, 288f)
            quadTo(189f, 266f, 209f, 253f)
            quadTo(229f, 240f, 252f, 240f)
            lineTo(280f, 240f)
            close()
            moveTo(360f, 240f)
            lineTo(600f, 240f)
            lineTo(600f, 200f)
            lineTo(360f, 200f)
            lineTo(360f, 240f)
            close()
            moveTo(280f, 480f)
            lineTo(280f, 479f)
            quadTo(280f, 462f, 291.5f, 450.5f)
            quadTo(303f, 439f, 320f, 439f)
            quadTo(337f, 439f, 348.5f, 450.5f)
            quadTo(360f, 462f, 360f, 479f)
            lineTo(360f, 480f)
            lineTo(600f, 480f)
            lineTo(600f, 479f)
            quadTo(600f, 462f, 611.5f, 450.5f)
            quadTo(623f, 439f, 640f, 439f)
            quadTo(657f, 439f, 668.5f, 450.5f)
            quadTo(680f, 462f, 680f, 479f)
            lineTo(680f, 480f)
            lineTo(776f, 480f)
            lineTo(708f, 320f)
            lineTo(252f, 320f)
            lineTo(184f, 480f)
            lineTo(280f, 480f)
            close()
            moveTo(280f, 560f)
            lineTo(160f, 560f)
            lineTo(160f, 720f)
            lineTo(800f, 720f)
            lineTo(800f, 560f)
            lineTo(680f, 560f)
            lineTo(680f, 561f)
            quadTo(680f, 578f, 668.5f, 589.5f)
            quadTo(657f, 601f, 640f, 601f)
            quadTo(623f, 601f, 611.5f, 589.5f)
            quadTo(600f, 578f, 600f, 561f)
            lineTo(600f, 560f)
            lineTo(360f, 560f)
            lineTo(360f, 561f)
            quadTo(360f, 578f, 348.5f, 589.5f)
            quadTo(337f, 601f, 320f, 601f)
            quadTo(303f, 601f, 291.5f, 589.5f)
            quadTo(280f, 578f, 280f, 561f)
            lineTo(280f, 560f)
            close()
            moveTo(480f, 520f)
            lineTo(480f, 520f)
            quadTo(480f, 520f, 480f, 520f)
            quadTo(480f, 520f, 480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            quadTo(480f, 520f, 480f, 520f)
            quadTo(480f, 520f, 480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            lineTo(480f, 520f)
            close()
            moveTo(480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            close()
            moveTo(480f, 560f)
            lineTo(480f, 560f)
            lineTo(480f, 560f)
            lineTo(480f, 560f)
            lineTo(480f, 560f)
            lineTo(480f, 560f)
            lineTo(480f, 560f)
            lineTo(480f, 560f)
            lineTo(480f, 560f)
            lineTo(480f, 560f)
            lineTo(480f, 560f)
            lineTo(480f, 560f)
            close()
        }
    }.build()
}