package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Rounded.ResponsiveLayout: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Rounded.ResponsiveLayout",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(680f, 840f)
            quadTo(663f, 840f, 651.5f, 828.5f)
            quadTo(640f, 817f, 640f, 800f)
            lineTo(640f, 400f)
            quadTo(640f, 367f, 616.5f, 343.5f)
            quadTo(593f, 320f, 560f, 320f)
            lineTo(420f, 320f)
            quadTo(403f, 320f, 391.5f, 308.5f)
            quadTo(380f, 297f, 380f, 280f)
            lineTo(380f, 160f)
            quadTo(380f, 143f, 391.5f, 131.5f)
            quadTo(403f, 120f, 420f, 120f)
            lineTo(800f, 120f)
            quadTo(817f, 120f, 828.5f, 131.5f)
            quadTo(840f, 143f, 840f, 160f)
            lineTo(840f, 800f)
            quadTo(840f, 817f, 828.5f, 828.5f)
            quadTo(817f, 840f, 800f, 840f)
            lineTo(680f, 840f)
            close()
            moveTo(420f, 840f)
            quadTo(403f, 840f, 391.5f, 828.5f)
            quadTo(380f, 817f, 380f, 800f)
            lineTo(380f, 440f)
            quadTo(380f, 423f, 391.5f, 411.5f)
            quadTo(403f, 400f, 420f, 400f)
            lineTo(520f, 400f)
            quadTo(537f, 400f, 548.5f, 411.5f)
            quadTo(560f, 423f, 560f, 440f)
            lineTo(560f, 800f)
            quadTo(560f, 817f, 548.5f, 828.5f)
            quadTo(537f, 840f, 520f, 840f)
            lineTo(420f, 840f)
            close()
            moveTo(160f, 840f)
            quadTo(143f, 840f, 131.5f, 828.5f)
            quadTo(120f, 817f, 120f, 800f)
            lineTo(120f, 440f)
            quadTo(120f, 423f, 131.5f, 411.5f)
            quadTo(143f, 400f, 160f, 400f)
            lineTo(260f, 400f)
            quadTo(277f, 400f, 288.5f, 411.5f)
            quadTo(300f, 423f, 300f, 440f)
            lineTo(300f, 800f)
            quadTo(300f, 817f, 288.5f, 828.5f)
            quadTo(277f, 840f, 260f, 840f)
            lineTo(160f, 840f)
            close()
        }
    }.build()
}
