package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Outlined.MobileVibrate: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Outlined.MobileVibrate",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(320f, 840f)
            quadTo(287f, 840f, 263.5f, 816.5f)
            quadTo(240f, 793f, 240f, 760f)
            lineTo(240f, 200f)
            quadTo(240f, 167f, 263.5f, 143.5f)
            quadTo(287f, 120f, 320f, 120f)
            lineTo(640f, 120f)
            quadTo(673f, 120f, 696.5f, 143.5f)
            quadTo(720f, 167f, 720f, 200f)
            lineTo(720f, 760f)
            quadTo(720f, 793f, 696.5f, 816.5f)
            quadTo(673f, 840f, 640f, 840f)
            lineTo(320f, 840f)
            close()
            moveTo(640f, 760f)
            lineTo(640f, 200f)
            quadTo(640f, 200f, 640f, 200f)
            quadTo(640f, 200f, 640f, 200f)
            lineTo(320f, 200f)
            quadTo(320f, 200f, 320f, 200f)
            quadTo(320f, 200f, 320f, 200f)
            lineTo(320f, 760f)
            quadTo(320f, 760f, 320f, 760f)
            quadTo(320f, 760f, 320f, 760f)
            lineTo(640f, 760f)
            quadTo(640f, 760f, 640f, 760f)
            quadTo(640f, 760f, 640f, 760f)
            close()
            moveTo(480f, 320f)
            quadTo(497f, 320f, 508.5f, 308.5f)
            quadTo(520f, 297f, 520f, 280f)
            quadTo(520f, 263f, 508.5f, 251.5f)
            quadTo(497f, 240f, 480f, 240f)
            quadTo(463f, 240f, 451.5f, 251.5f)
            quadTo(440f, 263f, 440f, 280f)
            quadTo(440f, 297f, 451.5f, 308.5f)
            quadTo(463f, 320f, 480f, 320f)
            close()
            moveTo(0f, 600f)
            lineTo(0f, 360f)
            lineTo(80f, 360f)
            lineTo(80f, 600f)
            lineTo(0f, 600f)
            close()
            moveTo(120f, 680f)
            lineTo(120f, 280f)
            lineTo(200f, 280f)
            lineTo(200f, 680f)
            lineTo(120f, 680f)
            close()
            moveTo(880f, 600f)
            lineTo(880f, 360f)
            lineTo(960f, 360f)
            lineTo(960f, 600f)
            lineTo(880f, 600f)
            close()
            moveTo(760f, 680f)
            lineTo(760f, 280f)
            lineTo(840f, 280f)
            lineTo(840f, 680f)
            lineTo(760f, 680f)
            close()
            moveTo(320f, 760f)
            quadTo(320f, 760f, 320f, 760f)
            quadTo(320f, 760f, 320f, 760f)
            lineTo(320f, 760f)
            quadTo(320f, 760f, 320f, 760f)
            quadTo(320f, 760f, 320f, 760f)
            lineTo(320f, 200f)
            quadTo(320f, 200f, 320f, 200f)
            quadTo(320f, 200f, 320f, 200f)
            lineTo(320f, 200f)
            quadTo(320f, 200f, 320f, 200f)
            quadTo(320f, 200f, 320f, 200f)
            lineTo(320f, 760f)
            close()
        }
    }.build()
}

val Icons.Rounded.MobileVibrate: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Rounded.MobileVibrate",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(320f, 840f)
            quadTo(287f, 840f, 263.5f, 816.5f)
            quadTo(240f, 793f, 240f, 760f)
            lineTo(240f, 200f)
            quadTo(240f, 167f, 263.5f, 143.5f)
            quadTo(287f, 120f, 320f, 120f)
            lineTo(640f, 120f)
            quadTo(673f, 120f, 696.5f, 143.5f)
            quadTo(720f, 167f, 720f, 200f)
            lineTo(720f, 760f)
            quadTo(720f, 793f, 696.5f, 816.5f)
            quadTo(673f, 840f, 640f, 840f)
            lineTo(320f, 840f)
            close()
            moveTo(480f, 320f)
            quadTo(497f, 320f, 508.5f, 308.5f)
            quadTo(520f, 297f, 520f, 280f)
            quadTo(520f, 263f, 508.5f, 251.5f)
            quadTo(497f, 240f, 480f, 240f)
            quadTo(463f, 240f, 451.5f, 251.5f)
            quadTo(440f, 263f, 440f, 280f)
            quadTo(440f, 297f, 451.5f, 308.5f)
            quadTo(463f, 320f, 480f, 320f)
            close()
            moveTo(0f, 600f)
            lineTo(0f, 360f)
            lineTo(80f, 360f)
            lineTo(80f, 600f)
            lineTo(0f, 600f)
            close()
            moveTo(120f, 680f)
            lineTo(120f, 280f)
            lineTo(200f, 280f)
            lineTo(200f, 680f)
            lineTo(120f, 680f)
            close()
            moveTo(880f, 600f)
            lineTo(880f, 360f)
            lineTo(960f, 360f)
            lineTo(960f, 600f)
            lineTo(880f, 600f)
            close()
            moveTo(760f, 680f)
            lineTo(760f, 280f)
            lineTo(840f, 280f)
            lineTo(840f, 680f)
            lineTo(760f, 680f)
            close()
        }
    }.build()
}