package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Outlined.MobileArrowDown: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Outlined.MobileArrowDown",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(280f, 920f)
            quadTo(247f, 920f, 223.5f, 896.5f)
            quadTo(200f, 873f, 200f, 840f)
            lineTo(200f, 120f)
            quadTo(200f, 87f, 223.5f, 63.5f)
            quadTo(247f, 40f, 280f, 40f)
            lineTo(680f, 40f)
            quadTo(713f, 40f, 736.5f, 63.5f)
            quadTo(760f, 87f, 760f, 120f)
            lineTo(760f, 244f)
            quadTo(778f, 251f, 789f, 266f)
            quadTo(800f, 281f, 800f, 300f)
            lineTo(800f, 380f)
            quadTo(800f, 399f, 789f, 414f)
            quadTo(778f, 429f, 760f, 436f)
            lineTo(760f, 840f)
            quadTo(760f, 873f, 736.5f, 896.5f)
            quadTo(713f, 920f, 680f, 920f)
            lineTo(280f, 920f)
            close()
            moveTo(280f, 840f)
            lineTo(680f, 840f)
            quadTo(680f, 840f, 680f, 840f)
            quadTo(680f, 840f, 680f, 840f)
            lineTo(680f, 120f)
            quadTo(680f, 120f, 680f, 120f)
            quadTo(680f, 120f, 680f, 120f)
            lineTo(280f, 120f)
            quadTo(280f, 120f, 280f, 120f)
            quadTo(280f, 120f, 280f, 120f)
            lineTo(280f, 840f)
            quadTo(280f, 840f, 280f, 840f)
            quadTo(280f, 840f, 280f, 840f)
            close()
            moveTo(280f, 840f)
            quadTo(280f, 840f, 280f, 840f)
            quadTo(280f, 840f, 280f, 840f)
            lineTo(280f, 120f)
            quadTo(280f, 120f, 280f, 120f)
            quadTo(280f, 120f, 280f, 120f)
            lineTo(280f, 120f)
            quadTo(280f, 120f, 280f, 120f)
            quadTo(280f, 120f, 280f, 120f)
            lineTo(280f, 840f)
            quadTo(280f, 840f, 280f, 840f)
            quadTo(280f, 840f, 280f, 840f)
            close()
            moveTo(480f, 640f)
            lineTo(640f, 480f)
            lineTo(584f, 424f)
            lineTo(520f, 486f)
            lineTo(520f, 320f)
            lineTo(440f, 320f)
            lineTo(440f, 486f)
            lineTo(376f, 424f)
            lineTo(320f, 480f)
            lineTo(480f, 640f)
            close()
        }
    }.build()
}

val Icons.Rounded.MobileArrowDown: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Rounded.MobileArrowDown",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(280f, 920f)
            quadTo(247f, 920f, 223.5f, 896.5f)
            quadTo(200f, 873f, 200f, 840f)
            lineTo(200f, 120f)
            quadTo(200f, 87f, 223.5f, 63.5f)
            quadTo(247f, 40f, 280f, 40f)
            lineTo(680f, 40f)
            quadTo(713f, 40f, 736.5f, 63.5f)
            quadTo(760f, 87f, 760f, 120f)
            lineTo(760f, 244f)
            quadTo(778f, 251f, 789f, 266f)
            quadTo(800f, 281f, 800f, 300f)
            lineTo(800f, 380f)
            quadTo(800f, 399f, 789f, 414f)
            quadTo(778f, 429f, 760f, 436f)
            lineTo(760f, 840f)
            quadTo(760f, 873f, 736.5f, 896.5f)
            quadTo(713f, 920f, 680f, 920f)
            lineTo(280f, 920f)
            close()
            moveTo(480f, 640f)
            lineTo(640f, 480f)
            lineTo(584f, 424f)
            lineTo(520f, 486f)
            lineTo(520f, 320f)
            lineTo(440f, 320f)
            lineTo(440f, 486f)
            lineTo(376f, 424f)
            lineTo(320f, 480f)
            lineTo(480f, 640f)
            close()
        }
    }.build()
}
