/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2025 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Rounded.Landscape2: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Rounded.Landscape2",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(46f, 800f)
            lineTo(184f, 524f)
            quadTo(194f, 504f, 212.5f, 492f)
            quadTo(231f, 480f, 254f, 480f)
            quadTo(278f, 480f, 298f, 492.5f)
            quadTo(318f, 505f, 327f, 528f)
            lineTo(354f, 594f)
            quadTo(356f, 600f, 363f, 599.5f)
            quadTo(370f, 599f, 372f, 593f)
            lineTo(458f, 306f)
            quadTo(472f, 258f, 511.5f, 229f)
            quadTo(551f, 200f, 601f, 200f)
            quadTo(650f, 200f, 688.5f, 228.5f)
            quadTo(727f, 257f, 742f, 303f)
            lineTo(915f, 800f)
            lineTo(46f, 800f)
            close()
            moveTo(240f, 400f)
            quadTo(190f, 400f, 155f, 364.5f)
            quadTo(120f, 329f, 120f, 280f)
            quadTo(120f, 230f, 155f, 195f)
            quadTo(190f, 160f, 240f, 160f)
            quadTo(290f, 160f, 325f, 195f)
            quadTo(360f, 230f, 360f, 280f)
            quadTo(360f, 329f, 325f, 364.5f)
            quadTo(290f, 400f, 240f, 400f)
            close()
        }
    }.build()
}

val Icons.Outlined.Landscape2: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Outlined.Landscape2",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(46f, 800f)
            lineTo(184f, 524f)
            quadTo(194f, 504f, 212.5f, 492f)
            quadTo(231f, 480f, 254f, 480f)
            quadTo(278f, 480f, 298f, 492.5f)
            quadTo(318f, 505f, 327f, 528f)
            lineTo(354f, 594f)
            quadTo(356f, 600f, 363f, 599.5f)
            quadTo(370f, 599f, 372f, 593f)
            lineTo(458f, 306f)
            quadTo(472f, 258f, 511.5f, 229f)
            quadTo(551f, 200f, 601f, 200f)
            quadTo(650f, 200f, 688.5f, 228.5f)
            quadTo(727f, 257f, 742f, 303f)
            lineTo(915f, 800f)
            lineTo(830f, 800f)
            lineTo(666f, 328f)
            quadTo(658f, 305f, 641f, 292.5f)
            quadTo(624f, 280f, 601f, 280f)
            quadTo(578f, 280f, 560.5f, 293f)
            quadTo(543f, 306f, 535f, 329f)
            lineTo(449f, 616f)
            quadTo(440f, 644f, 416.5f, 662f)
            quadTo(393f, 680f, 363f, 680f)
            quadTo(336f, 680f, 313f, 665.5f)
            quadTo(290f, 651f, 280f, 625f)
            lineTo(253f, 559f)
            quadTo(253f, 559f, 253f, 559f)
            quadTo(253f, 559f, 253f, 559f)
            lineTo(135f, 800f)
            lineTo(46f, 800f)
            close()
            moveTo(240f, 400f)
            quadTo(190f, 400f, 155f, 364.5f)
            quadTo(120f, 329f, 120f, 280f)
            quadTo(120f, 230f, 155f, 195f)
            quadTo(190f, 160f, 240f, 160f)
            quadTo(290f, 160f, 325f, 195f)
            quadTo(360f, 230f, 360f, 280f)
            quadTo(360f, 329f, 325f, 364.5f)
            quadTo(290f, 400f, 240f, 400f)
            close()
            moveTo(240f, 320f)
            quadTo(257f, 320f, 268.5f, 308.5f)
            quadTo(280f, 297f, 280f, 280f)
            quadTo(280f, 263f, 268.5f, 251.5f)
            quadTo(257f, 240f, 240f, 240f)
            quadTo(223f, 240f, 211.5f, 251.5f)
            quadTo(200f, 263f, 200f, 280f)
            quadTo(200f, 297f, 211.5f, 308.5f)
            quadTo(223f, 320f, 240f, 320f)
            close()
            moveTo(363f, 680f)
            lineTo(363f, 680f)
            quadTo(363f, 680f, 363f, 680f)
            quadTo(363f, 680f, 363f, 680f)
            lineTo(363f, 680f)
            quadTo(363f, 680f, 363f, 680f)
            quadTo(363f, 680f, 363f, 680f)
            quadTo(363f, 680f, 363f, 680f)
            quadTo(363f, 680f, 363f, 680f)
            lineTo(363f, 680f)
            quadTo(363f, 680f, 363f, 680f)
            quadTo(363f, 680f, 363f, 680f)
            quadTo(363f, 680f, 363f, 680f)
            quadTo(363f, 680f, 363f, 680f)
            lineTo(363f, 680f)
            close()
            moveTo(240f, 280f)
            quadTo(240f, 280f, 240f, 280f)
            quadTo(240f, 280f, 240f, 280f)
            quadTo(240f, 280f, 240f, 280f)
            quadTo(240f, 280f, 240f, 280f)
            quadTo(240f, 280f, 240f, 280f)
            quadTo(240f, 280f, 240f, 280f)
            quadTo(240f, 280f, 240f, 280f)
            quadTo(240f, 280f, 240f, 280f)
            close()
        }
    }.build()
}