/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2024 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Filled.Jxl: ImageVector by lazy {
    Builder(
        name = "Jxl", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp, viewportWidth
        = 24.0f, viewportHeight = 24.0f
    ).apply {
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(13.1206f, 12.0514f)
            curveToRelative(0.8368f, -1.7278f, 1.6713f, -3.4556f, 2.5059f, -5.1834f)
            horizontalLineToRelative(-2.3242f)
            curveToRelative(-0.5384f, 1.1136f, -1.0791f, 2.2297f, -1.6175f, 3.3433f)
            curveTo(10.8144f, 9.0976f, 9.9439f, 7.9816f, 9.0735f, 6.868f)
            horizontalLineTo(6.7493f)
            lineToRelative(4.0449f, 5.1834f)
            curveToRelative(-0.8188f, 1.692f, -1.6377f, 3.3863f, -2.4565f, 5.0783f)
            horizontalLineToRelative(2.3242f)
            curveToRelative(0.5227f, -1.0802f, 1.0454f, -2.1604f, 1.5659f, -3.2381f)
            curveToRelative(0.8435f, 1.0802f, 1.6848f, 2.1604f, 2.5283f, 3.2381f)
            horizontalLineToRelative(2.3242f)
            curveToRelative(-1.3169f, -1.692f, -2.6382f, -3.3839f, -3.9596f, -5.0783f)
            verticalLineTo(12.0514f)
            close()
            moveTo(5.4324f, 16.9504f)
            lineToRelative(0.0067f, 0.055f)
            lineToRelative(0.0157f, 0.0621f)
            curveToRelative(0.0852f, 0.3609f, 0.1997f, 1.4219f, -0.2692f, 2.0624f)
            curveToRelative(-0.1391f, 0.1912f, -0.332f, 0.3465f, -0.5743f, 0.4612f)
            lineTo(3.2092f, 22.0f)
            curveToRelative(0.8278f, 0.0f, 1.5569f, -0.1386f, 2.1649f, -0.4158f)
            curveToRelative(0.581f, -0.2629f, 1.0589f, -0.65f, 1.4178f, -1.1495f)
            curveToRelative(0.498f, -0.6906f, 0.7605f, -1.5916f, 0.7583f, -2.6072f)
            curveToRelative(0.0f, -0.5927f, -0.0897f, -1.0658f, -0.1279f, -1.2427f)
            lineToRelative(-0.9176f, -6.5312f)
            horizontalLineToRelative(0.0022f)
            verticalLineTo(7.898f)
            horizontalLineTo(2.0f)
            verticalLineToRelative(2.1556f)
            horizontalLineToRelative(2.4633f)
            lineTo(5.4324f, 16.9504f)
            close()
            moveTo(18.5676f, 7.0472f)
            lineToRelative(-0.0067f, -0.055f)
            lineToRelative(-0.0157f, -0.0621f)
            curveToRelative(-0.0852f, -0.3609f, -0.1997f, -1.4219f, 0.2692f, -2.0624f)
            curveToRelative(0.1391f, -0.1912f, 0.332f, -0.3465f, 0.5743f, -0.4612f)
            lineTo(20.7908f, 2.0f)
            curveToRelative(-0.8278f, 0.0f, -1.5569f, 0.1386f, -2.1649f, 0.4158f)
            curveToRelative(-0.581f, 0.2629f, -1.0589f, 0.65f, -1.4178f, 1.1495f)
            curveToRelative(-0.498f, 0.6906f, -0.7605f, 1.5916f, -0.7583f, 2.6072f)
            curveToRelative(0.0f, 0.5927f, 0.0897f, 1.0658f, 0.1279f, 1.2427f)
            lineToRelative(0.9176f, 6.5312f)
            horizontalLineToRelative(-0.0022f)
            verticalLineToRelative(2.1556f)
            horizontalLineTo(22.0f)
            verticalLineToRelative(-2.1556f)
            horizontalLineToRelative(-2.4633f)
            lineToRelative(-0.9692f, -6.8993f)
            verticalLineTo(7.0472f)
            close()
        }
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(5.4324f, 16.9504f)
            lineToRelative(0.0067f, 0.055f)
            lineToRelative(0.0157f, 0.0621f)
            curveToRelative(0.0852f, 0.3609f, 0.1997f, 1.4219f, -0.2692f, 2.0624f)
            curveToRelative(-0.1391f, 0.1912f, -0.332f, 0.3465f, -0.5743f, 0.4612f)
            lineTo(3.2092f, 22.0f)
            curveToRelative(0.8278f, 0.0f, 1.5569f, -0.1386f, 2.1649f, -0.4158f)
            curveToRelative(0.581f, -0.2629f, 1.0589f, -0.65f, 1.4178f, -1.1495f)
            curveToRelative(0.498f, -0.6906f, 0.7605f, -1.5916f, 0.7583f, -2.6072f)
            curveToRelative(0.0f, -0.5927f, -0.0897f, -1.0658f, -0.1279f, -1.2427f)
            lineToRelative(-0.9176f, -6.5312f)
            horizontalLineToRelative(0.0022f)
            verticalLineTo(7.898f)
            horizontalLineTo(2.0f)
            verticalLineToRelative(2.1556f)
            horizontalLineToRelative(2.4633f)
            lineTo(5.4324f, 16.9504f)
            close()
        }
    }.build()
}
