/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2025 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Outlined.ImageToolboxBroken: ImageVector by lazy {
    ImageVector.Builder(
        name = "Outlined.ImageToolboxBroken",
        defaultWidth = 1305.dp,
        defaultHeight = 1295.dp,
        viewportWidth = 1305f,
        viewportHeight = 1295f
    ).apply {
        path(
            fill = SolidColor(Color(0xFF000000)),
            pathFillType = PathFillType.EvenOdd
        ) {
            moveTo(794.4f, 452.5f)
            verticalLineToRelative(93.6f)
            curveToRelative(0f, 16.1f, 5.4f, 29.5f, 16.3f, 40.4f)
            curveToRelative(10.9f, 10.9f, 24.3f, 16.3f, 40.4f, 16.3f)
            horizontalLineToRelative(93.6f)
            curveToRelative(7.6f, 0f, 14.9f, -1.4f, 22f, -4.3f)
            curveToRelative(7.1f, -2.8f, 13.5f, -7.1f, 19.1f, -12.8f)
            lineToRelative(295f, -295f)
            curveToRelative(8.5f, -8.5f, 14.7f, -18.2f, 18.4f, -29.1f)
            curveToRelative(3.8f, -10.9f, 5.7f, -21.5f, 5.7f, -31.9f)
            curveToRelative(0f, -10.4f, -2.1f, -20.8f, -6.4f, -31.2f)
            curveToRelative(-4.3f, -10.4f, -10.2f, -19.9f, -17.7f, -28.4f)
            lineToRelative(-52.5f, -52.5f)
            curveToRelative(-8.5f, -8.5f, -18f, -14.9f, -28.4f, -19.1f)
            curveToRelative(-10.4f, -4.3f, -21.3f, -6.4f, -32.6f, -6.4f)
            curveToRelative(-10.4f, 0f, -20.8f, 1.9f, -31.2f, 5.7f)
            curveToRelative(-10.4f, 3.8f, -19.9f, 9.9f, -28.4f, 18.4f)
            lineToRelative(-296.4f, 295f)
            curveToRelative(-5.7f, 5.7f, -9.9f, 12.1f, -12.8f, 19.1f)
            curveTo(795.8f, 437.6f, 794.4f, 444.9f, 794.4f, 452.5f)
            close()
            moveTo(933.4f, 517.7f)
            horizontalLineToRelative(-53.9f)
            verticalLineToRelative(-53.9f)
            lineToRelative(173f, -171.6f)
            lineToRelative(52.5f, 52.5f)
            lineTo(933.4f, 517.7f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(657.8f, 301.6f)
            curveToRelative(69.4f, 0f, 125.2f, 0.3f, 171.5f, 2.2f)
            lineToRelative(94f, -94f)
            curveToRelative(-70.8f, -9.6f, -162.9f, -9.6f, -289.3f, -9.6f)
            curveToRelative(-5.1f, 0f, -10.1f, 0f, -15.1f, 0f)
            lineTo(657.8f, 301.6f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(1029f, 1268.8f)
            curveToRelative(12.8f, -6.2f, 24.6f, -13.4f, 35.8f, -21.7f)
            curveToRelative(23.7f, -17.6f, 44.7f, -38.6f, 62.3f, -62.3f)
            curveToRelative(60.4f, -81.1f, 60.4f, -197.7f, 60.4f, -430.9f)
            curveToRelative(0f, -115.3f, 0f, -202.2f, -7.3f, -270.3f)
            lineToRelative(-95.5f, 95.5f)
            curveToRelative(1.4f, 47.6f, 1.5f, 104.5f, 1.5f, 174.7f)
            curveToRelative(0f, 16.5f, 0f, 32.3f, 0f, 47.5f)
            curveToRelative(-49.3f, -41f, -87.3f, -60.7f, -144.1f, -37.7f)
            curveToRelative(-29.4f, 11.9f, -58.5f, 30.6f, -86.9f, 52.5f)
            lineTo(1029f, 1268.8f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(493.8f, 352.3f)
            curveToRelative(-6.3f, -14.6f, -14.9f, -27.4f, -25.7f, -38.2f)
            curveToRelative(-10.8f, -10.8f, -23.6f, -19.4f, -38.2f, -25.7f)
            curveToRelative(-14.6f, -6.3f, -30.3f, -9.5f, -46.9f, -9.5f)
            reflectiveCurveToRelative(-32.3f, 3.2f, -46.9f, 9.5f)
            reflectiveCurveToRelative(-27.4f, 14.9f, -38.2f, 25.7f)
            curveToRelative(-10.8f, 10.8f, -19.4f, 23.6f, -25.7f, 38.2f)
            curveToRelative(-6.3f, 14.6f, -9.5f, 30.3f, -9.5f, 46.9f)
            reflectiveCurveToRelative(3.2f, 32.3f, 9.5f, 46.9f)
            reflectiveCurveToRelative(14.9f, 27.4f, 25.7f, 38.2f)
            curveToRelative(10.8f, 10.8f, 23.6f, 19.4f, 38.2f, 25.7f)
            curveToRelative(14.6f, 6.3f, 30.3f, 9.5f, 46.9f, 9.5f)
            reflectiveCurveToRelative(32.3f, -3.2f, 46.9f, -9.5f)
            curveToRelative(14.6f, -6.3f, 27.4f, -14.9f, 38.2f, -25.7f)
            curveToRelative(10.8f, -10.8f, 19.4f, -23.6f, 25.7f, -38.2f)
            curveToRelative(6.3f, -14.6f, 9.5f, -30.3f, 9.5f, -46.9f)
            reflectiveCurveTo(500.1f, 367f, 493.8f, 352.3f)
            close()
            moveTo(392.2f, 460f)
            curveToRelative(-2.5f, 2.5f, -5.5f, 3.7f, -9.2f, 3.7f)
            reflectiveCurveToRelative(-6.7f, -1.2f, -9.2f, -3.7f)
            curveToRelative(-2.5f, -2.5f, -3.7f, -5.5f, -3.7f, -9.2f)
            reflectiveCurveToRelative(1.2f, -6.7f, 3.7f, -9.2f)
            curveToRelative(2.5f, -2.5f, 5.5f, -3.7f, 9.2f, -3.7f)
            reflectiveCurveToRelative(6.7f, 1.2f, 9.2f, 3.7f)
            curveToRelative(2.5f, 2.5f, 3.7f, 5.5f, 3.7f, 9.2f)
            reflectiveCurveTo(394.6f, 457.6f, 392.2f, 460f)
            close()
            moveTo(395.9f, 399.3f)
            curveToRelative(0f, 3.7f, -1.2f, 6.7f, -3.7f, 9.2f)
            curveToRelative(-2.5f, 2.5f, -5.5f, 3.7f, -9.2f, 3.7f)
            reflectiveCurveToRelative(-6.7f, -1.2f, -9.2f, -3.7f)
            reflectiveCurveToRelative(-3.7f, -5.5f, -3.7f, -9.2f)
            verticalLineToRelative(-51.6f)
            curveToRelative(0f, -3.7f, 1.2f, -6.7f, 3.7f, -9.2f)
            curveToRelative(2.5f, -2.5f, 5.5f, -3.7f, 9.2f, -3.7f)
            reflectiveCurveToRelative(6.7f, 1.2f, 9.2f, 3.7f)
            curveToRelative(2.5f, 2.5f, 3.7f, 5.5f, 3.7f, 9.2f)
            verticalLineTo(399.3f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(338.5f, 837.2f)
            lineToRelative(75.9f, 22.8f)
            lineToRelative(32.7f, -33.6f)
            lineToRelative(-64.6f, -39.7f)
            curveToRelative(-6.5f, -3.7f, -13.1f, -6.7f, -19.7f, -9.1f)
            lineTo(338.5f, 837.2f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(763.4f, 887.4f)
            lineToRelative(-24.2f, -69.5f)
            lineToRelative(-201f, 42.6f)
            lineToRelative(128f, 108.2f)
            lineTo(528.8f, 890f)
            lineToRelative(0f, 0.6f)
            lineToRelative(-3f, -2.3f)
            lineToRelative(-80.6f, -1.7f)
            lineToRelative(81.4f, 186.8f)
            horizontalLineToRelative(0f)
            lineToRelative(-78.3f, -115f)
            lineToRelative(-123.7f, 100.7f)
            lineToRelative(99.7f, -135.8f)
            lineToRelative(-25.4f, -37.4f)
            lineToRelative(-84.1f, -25.2f)
            lineToRelative(-15.3f, -4.6f)
            lineToRelative(6f, -14.9f)
            lineToRelative(28.3f, -69.5f)
            curveToRelative(-69.2f, -5f, -145.2f, 50.4f, -219.1f, 104.2f)
            lineToRelative(-1f, 0.7f)
            curveToRelative(-2f, -10.6f, -3.7f, -22.4f, -5.2f, -35.8f)
            curveToRelative(-6.8f, -61.6f, -6.9f, -142.5f, -6.9f, -261.4f)
            reflectiveCurveToRelative(0.1f, -199.8f, 6.9f, -261.4f)
            curveToRelative(6.6f, -59.6f, 18.4f, -88.8f, 33.4f, -109f)
            curveToRelative(11.8f, -15.8f, 25.8f, -29.8f, 41.6f, -41.6f)
            curveToRelative(20.2f, -15f, 49.3f, -26.8f, 109f, -33.4f)
            curveToRelative(46.2f, -5.1f, 103.3f, -6.5f, 179.2f, -6.8f)
            lineTo(432.8f, 26.2f)
            curveToRelative(-155.3f, 1.8f, -244.3f, 11.1f, -310f, 60f)
            curveToRelative(-23.7f, 17.6f, -44.7f, 38.6f, -62.3f, 62.3f)
            curveTo(0.1f, 229.6f, 0.1f, 346.2f, 0.1f, 579.4f)
            reflectiveCurveToRelative(0f, 349.8f, 60.4f, 430.9f)
            curveToRelative(17.6f, 23.7f, 38.6f, 44.7f, 62.3f, 62.3f)
            curveToRelative(81.1f, 60.4f, 197.7f, 60.4f, 430.9f, 60.4f)
            curveToRelative(132.7f, 0f, 227.6f, 0f, 299.7f, -11.1f)
            lineTo(763.4f, 887.4f)
            close()
            moveTo(299.4f, 1073.4f)
            lineTo(299.4f, 1073.4f)
            curveTo(299.4f, 1073.3f, 299.4f, 1073.3f, 299.4f, 1073.4f)
            lineTo(299.4f, 1073.4f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(723.5f, 783.5f)
            lineToRelative(-9f, -23.4f)
            lineToRelative(-17.5f, -45.5f)
            lineToRelative(-47.9f, 37.7f)
            curveToRelative(-14.6f, 13.1f, -29f, 25.5f, -43.1f, 36.7f)
            lineToRelative(-8.8f, 6.8f)
            curveToRelative(-0.2f, 0.2f, -0.4f, 0.3f, -0.6f, 0.5f)
            lineToRelative(0f, 0f)
            lineToRelative(-29.4f, 20.4f)
            lineTo(723.5f, 783.5f)
            close()
        }
    }.build()
}
