/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2024 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Outlined.ImageEdit: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    Builder(
        name = "Outlined.ImageEdit",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(22.459f, 13.864f)
            curveToRelative(-0.075f, -0.183f, -0.179f, -0.35f, -0.313f, -0.5f)
            lineToRelative(-0.925f, -0.925f)
            curveToRelative(-0.15f, -0.15f, -0.317f, -0.262f, -0.5f, -0.337f)
            reflectiveCurveToRelative(-0.375f, -0.113f, -0.575f, -0.113f)
            curveToRelative(-0.183f, 0f, -0.367f, 0.033f, -0.55f, 0.1f)
            reflectiveCurveToRelative(-0.35f, 0.175f, -0.5f, 0.325f)
            lineToRelative(-5.525f, 5.5f)
            verticalLineToRelative(3.075f)
            horizontalLineToRelative(3.075f)
            lineToRelative(5.5f, -5.5f)
            curveToRelative(0.15f, -0.15f, 0.258f, -0.321f, 0.325f, -0.512f)
            curveToRelative(0.067f, -0.192f, 0.1f, -0.379f, 0.1f, -0.563f)
            reflectiveCurveToRelative(-0.038f, -0.367f, -0.113f, -0.55f)
            close()
            moveTo(16.021f, 19.489f)
            horizontalLineToRelative(-0.95f)
            verticalLineToRelative(-0.95f)
            lineToRelative(3.05f, -3.025f)
            lineToRelative(0.475f, 0.45f)
            lineToRelative(0.45f, 0.475f)
            lineToRelative(-3.025f, 3.05f)
            close()
        }
        path(fill = SolidColor(Color.Black)) {
            moveTo(11.018f, 18.608f)
            horizontalLineToRelative(-5.625f)
            verticalLineTo(5.468f)
            horizontalLineToRelative(13.214f)
            verticalLineToRelative(4.895f)
            horizontalLineToRelative(1.888f)
            verticalLineToRelative(-4.895f)
            curveToRelative(0f, -1.032f, -0.84f, -1.877f, -1.888f, -1.877f)
            horizontalLineTo(5.393f)
            curveToRelative(-1.038f, 0f, -1.888f, 0.845f, -1.888f, 1.877f)
            verticalLineToRelative(13.14f)
            curveToRelative(0f, 1.042f, 0.849f, 1.877f, 1.888f, 1.877f)
            horizontalLineToRelative(6.394f)
            verticalLineToRelative(-1.877f)
            horizontalLineToRelative(-0.769f)
            close()
        }
        path(fill = SolidColor(Color.Black)) {
            moveTo(16.047f, 12.914f)
            lineToRelative(-1.656f, -2.208f)
            lineToRelative(-2.475f, 3.3f)
            lineToRelative(-1.815f, -2.409f)
            lineToRelative(-2.805f, 3.729f)
            lineToRelative(6.339f, 0f)
            lineToRelative(2.412f, -2.412f)
            close()
        }
    }.build()
}

val Icons.TwoTone.ImageEdit: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    Builder(
        name = "TwoTone.ImageEdit",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(22.459f, 13.864f)
            curveToRelative(-0.075f, -0.183f, -0.179f, -0.35f, -0.313f, -0.5f)
            lineToRelative(-0.925f, -0.925f)
            curveToRelative(-0.15f, -0.15f, -0.317f, -0.262f, -0.5f, -0.337f)
            reflectiveCurveToRelative(-0.375f, -0.113f, -0.575f, -0.113f)
            curveToRelative(-0.183f, 0f, -0.367f, 0.033f, -0.55f, 0.1f)
            reflectiveCurveToRelative(-0.35f, 0.175f, -0.5f, 0.325f)
            lineToRelative(-5.525f, 5.5f)
            verticalLineToRelative(3.075f)
            horizontalLineToRelative(3.075f)
            lineToRelative(5.5f, -5.5f)
            curveToRelative(0.15f, -0.15f, 0.258f, -0.321f, 0.325f, -0.512f)
            curveToRelative(0.067f, -0.192f, 0.1f, -0.379f, 0.1f, -0.563f)
            reflectiveCurveToRelative(-0.038f, -0.367f, -0.113f, -0.55f)
            close()
            moveTo(16.021f, 19.489f)
            horizontalLineToRelative(-0.95f)
            verticalLineToRelative(-0.95f)
            lineToRelative(3.05f, -3.025f)
            lineToRelative(0.475f, 0.45f)
            lineToRelative(0.45f, 0.475f)
            lineToRelative(-3.025f, 3.05f)
            close()
        }
        path(fill = SolidColor(Color.Black)) {
            moveTo(11.018f, 18.608f)
            horizontalLineToRelative(-5.625f)
            verticalLineTo(5.468f)
            horizontalLineToRelative(13.214f)
            verticalLineToRelative(4.895f)
            horizontalLineToRelative(1.888f)
            verticalLineToRelative(-4.895f)
            curveToRelative(0f, -1.032f, -0.84f, -1.877f, -1.888f, -1.877f)
            horizontalLineTo(5.393f)
            curveToRelative(-1.038f, 0f, -1.888f, 0.845f, -1.888f, 1.877f)
            verticalLineToRelative(13.14f)
            curveToRelative(0f, 1.042f, 0.849f, 1.877f, 1.888f, 1.877f)
            horizontalLineToRelative(6.394f)
            verticalLineToRelative(-1.877f)
            horizontalLineToRelative(-0.769f)
            close()
        }
        path(fill = SolidColor(Color.Black)) {
            moveTo(16.047f, 12.914f)
            lineToRelative(-1.656f, -2.208f)
            lineToRelative(-2.475f, 3.3f)
            lineToRelative(-1.815f, -2.409f)
            lineToRelative(-2.805f, 3.729f)
            lineToRelative(6.339f, 0f)
            lineToRelative(2.412f, -2.412f)
            close()
        }
        path(
            fill = SolidColor(Color.Black),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(11.787f, 5.468f)
            lineToRelative(-1.655f, 0f)
            lineToRelative(-4.739f, 0f)
            lineToRelative(0f, 13.14f)
            lineToRelative(4.739f, 0f)
            lineToRelative(1.651f, 0f)
            lineToRelative(0f, -1.431f)
            lineToRelative(0.001f, 0f)
            lineToRelative(6.822f, -6.822f)
            lineToRelative(0f, -4.886f)
            lineToRelative(-6.82f, 0f)
            close()
        }
        path(
            fill = SolidColor(Color.Black),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(14.065f, 18.646f)
            lineToRelative(4.057f, -4.057f)
            lineToRelative(1.825f, 1.825f)
            lineToRelative(-4.057f, 4.057f)
            close()
        }
    }.build()
}