package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Outlined.HyperOS: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Outlined.HyperOS",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(
            fill = SolidColor(Color(0xFF1D1D1B)),
            pathFillType = PathFillType.EvenOdd
        ) {
            moveTo(13.899f, 3.031f)
            curveToRelative(-0.089f, -0f, -0.187f, 0.022f, -0.295f, 0.051f)
            curveToRelative(-0.192f, 0.051f, -0.346f, 0.104f, -0.425f, 0.242f)
            curveToRelative(-0.08f, 0.138f, -0.049f, 0.297f, 0.002f, 0.489f)
            curveToRelative(0.051f, 0.191f, 0.105f, 0.345f, 0.243f, 0.425f)
            horizontalLineToRelative(0f)
            curveToRelative(0.138f, 0.079f, 0.298f, 0.049f, 0.49f, -0.002f)
            curveToRelative(0.192f, -0.051f, 0.345f, -0.106f, 0.425f, -0.243f)
            curveToRelative(0.08f, -0.138f, 0.049f, -0.297f, -0.002f, -0.488f)
            curveToRelative(-0.051f, -0.191f, -0.104f, -0.345f, -0.243f, -0.424f)
            curveToRelative(-0.06f, -0.035f, -0.125f, -0.048f, -0.195f, -0.048f)
            lineToRelative(0f, -0f)
            close()
            moveTo(9.322f, 3.238f)
            curveToRelative(-0.156f, -0f, -0.277f, 0.104f, -0.415f, 0.242f)
            curveToRelative(-0.138f, 0.138f, -0.242f, 0.258f, -0.242f, 0.414f)
            curveToRelative(0.001f, 0.156f, 0.104f, 0.277f, 0.242f, 0.414f)
            curveToRelative(0.138f, 0.138f, 0.259f, 0.241f, 0.416f, 0.241f)
            curveToRelative(0.156f, 0f, 0.277f, -0.104f, 0.414f, -0.242f)
            curveToRelative(0.138f, -0.137f, 0.242f, -0.258f, 0.242f, -0.414f)
            curveToRelative(0f, -0.156f, -0.105f, -0.277f, -0.243f, -0.414f)
            curveToRelative(-0.138f, -0.138f, -0.258f, -0.242f, -0.415f, -0.242f)
            horizontalLineToRelative(-0f)
            close()
            moveTo(11.974f, 3.796f)
            curveToRelative(-0.211f, -0f, -0.373f, 0.141f, -0.559f, 0.326f)
            curveToRelative(-0.186f, 0.185f, -0.327f, 0.348f, -0.326f, 0.559f)
            curveToRelative(0f, 0.21f, 0.14f, 0.374f, 0.326f, 0.559f)
            curveToRelative(0.186f, 0.185f, 0.349f, 0.325f, 0.56f, 0.325f)
            curveToRelative(0.211f, 0f, 0.373f, -0.141f, 0.559f, -0.326f)
            curveToRelative(0.185f, -0.185f, 0.327f, -0.347f, 0.326f, -0.558f)
            curveToRelative(0f, -0.211f, -0.141f, -0.373f, -0.327f, -0.558f)
            curveToRelative(-0.186f, -0.185f, -0.348f, -0.326f, -0.559f, -0.326f)
            close()
            moveTo(8.108f, 4.841f)
            curveToRelative(-0.091f, 0f, -0.176f, 0.018f, -0.255f, 0.064f)
            curveToRelative(-0.181f, 0.104f, -0.25f, 0.305f, -0.318f, 0.556f)
            curveToRelative(-0.067f, 0.25f, -0.108f, 0.459f, -0.003f, 0.64f)
            curveToRelative(0.105f, 0.181f, 0.306f, 0.251f, 0.557f, 0.319f)
            curveToRelative(0.251f, 0.067f, 0.46f, 0.106f, 0.641f, 0.002f)
            curveToRelative(0.181f, -0.104f, 0.251f, -0.305f, 0.318f, -0.556f)
            curveToRelative(0.067f, -0.251f, 0.108f, -0.459f, 0.003f, -0.64f)
            curveToRelative(-0.105f, -0.181f, -0.306f, -0.25f, -0.557f, -0.317f)
            curveToRelative(-0.141f, -0.038f, -0.269f, -0.067f, -0.386f, -0.067f)
            lineToRelative(0f, 0f)
            close()
            moveTo(15.834f, 4.841f)
            curveToRelative(-0.117f, -0f, -0.245f, 0.029f, -0.386f, 0.067f)
            curveToRelative(-0.251f, 0.067f, -0.453f, 0.137f, -0.557f, 0.317f)
            curveToRelative(-0.105f, 0.181f, -0.064f, 0.389f, 0.003f, 0.64f)
            curveToRelative(0.067f, 0.251f, 0.137f, 0.452f, 0.318f, 0.556f)
            curveToRelative(0.181f, 0.104f, 0.39f, 0.065f, 0.641f, -0.002f)
            curveToRelative(0.251f, -0.067f, 0.452f, -0.138f, 0.557f, -0.319f)
            curveToRelative(0.105f, -0.181f, 0.064f, -0.389f, -0.003f, -0.64f)
            curveToRelative(-0.067f, -0.25f, -0.137f, -0.452f, -0.318f, -0.556f)
            curveToRelative(-0.079f, -0.046f, -0.164f, -0.063f, -0.255f, -0.064f)
            verticalLineToRelative(-0f)
            close()
            moveTo(17.563f, 5.054f)
            curveToRelative(-0.07f, 0f, -0.134f, 0.014f, -0.195f, 0.048f)
            curveToRelative(-0.138f, 0.08f, -0.191f, 0.233f, -0.242f, 0.424f)
            curveToRelative(-0.051f, 0.191f, -0.082f, 0.351f, -0.002f, 0.488f)
            curveToRelative(0.08f, 0.138f, 0.233f, 0.192f, 0.425f, 0.243f)
            curveToRelative(0.191f, 0.051f, 0.351f, 0.081f, 0.49f, 0.002f)
            horizontalLineToRelative(0f)
            curveToRelative(0.138f, -0.079f, 0.192f, -0.233f, 0.243f, -0.425f)
            curveToRelative(0.051f, -0.191f, 0.082f, -0.351f, 0.002f, -0.489f)
            curveToRelative(-0.08f, -0.138f, -0.234f, -0.191f, -0.425f, -0.242f)
            curveToRelative(-0.108f, -0.029f, -0.206f, -0.051f, -0.295f, -0.051f)
            lineToRelative(0f, 0f)
            close()
            moveTo(10.321f, 5.359f)
            curveToRelative(-0.047f, 0.001f, -0.093f, 0.007f, -0.141f, 0.019f)
            curveToRelative(-0.252f, 0.067f, -0.4f, 0.287f, -0.562f, 0.567f)
            curveToRelative(-0.162f, 0.28f, -0.278f, 0.518f, -0.211f, 0.77f)
            curveToRelative(0.068f, 0.251f, 0.287f, 0.401f, 0.568f, 0.563f)
            curveToRelative(0.28f, 0.162f, 0.52f, 0.276f, 0.771f, 0.209f)
            curveToRelative(0.252f, -0.067f, 0.401f, -0.287f, 0.563f, -0.567f)
            curveToRelative(0.162f, -0.28f, 0.278f, -0.519f, 0.211f, -0.77f)
            curveToRelative(-0.068f, -0.251f, -0.288f, -0.4f, -0.569f, -0.562f)
            curveToRelative(-0.228f, -0.132f, -0.429f, -0.233f, -0.631f, -0.23f)
            lineToRelative(-0f, -0f)
            close()
            moveTo(13.618f, 5.359f)
            curveToRelative(-0.202f, -0.003f, -0.403f, 0.099f, -0.631f, 0.23f)
            curveToRelative(-0.281f, 0.162f, -0.501f, 0.31f, -0.569f, 0.562f)
            curveToRelative(-0.068f, 0.251f, 0.049f, 0.49f, 0.211f, 0.77f)
            curveToRelative(0.162f, 0.28f, 0.311f, 0.5f, 0.563f, 0.567f)
            curveToRelative(0.251f, 0.067f, 0.491f, -0.048f, 0.771f, -0.209f)
            curveToRelative(0.281f, -0.162f, 0.5f, -0.312f, 0.568f, -0.563f)
            curveToRelative(0.068f, -0.251f, -0.049f, -0.49f, -0.211f, -0.77f)
            curveToRelative(-0.162f, -0.28f, -0.311f, -0.5f, -0.562f, -0.567f)
            curveToRelative(-0.047f, -0.013f, -0.094f, -0.019f, -0.141f, -0.019f)
            verticalLineToRelative(0f)
            close()
            moveTo(5.459f, 5.681f)
            curveToRelative(-0.07f, 0f, -0.134f, 0.014f, -0.195f, 0.048f)
            curveToRelative(-0.138f, 0.08f, -0.191f, 0.233f, -0.242f, 0.424f)
            curveToRelative(-0.051f, 0.191f, -0.082f, 0.351f, -0.002f, 0.488f)
            curveToRelative(0.08f, 0.138f, 0.233f, 0.192f, 0.425f, 0.243f)
            curveToRelative(0.192f, 0.051f, 0.351f, 0.081f, 0.49f, 0.002f)
            curveToRelative(0.138f, -0.079f, 0.192f, -0.233f, 0.243f, -0.425f)
            curveToRelative(0.051f, -0.191f, 0.082f, -0.351f, 0.002f, -0.489f)
            curveToRelative(-0.08f, -0.138f, -0.234f, -0.191f, -0.425f, -0.242f)
            curveToRelative(-0.108f, -0.029f, -0.206f, -0.051f, -0.295f, -0.051f)
            lineToRelative(0f, 0f)
            close()
            moveTo(7.864f, 6.961f)
            curveToRelative(-0.323f, 0f, -0.587f, 0.019f, -0.771f, 0.202f)
            curveToRelative(-0.184f, 0.183f, -0.202f, 0.447f, -0.202f, 0.769f)
            curveToRelative(0f, 0.323f, 0.019f, 0.587f, 0.203f, 0.769f)
            curveToRelative(0.184f, 0.183f, 0.448f, 0.203f, 0.77f, 0.203f)
            curveToRelative(0.323f, -0f, 0.587f, -0.021f, 0.771f, -0.204f)
            curveToRelative(0.184f, -0.183f, 0.202f, -0.447f, 0.202f, -0.769f)
            curveToRelative(0f, -0.322f, -0.019f, -0.586f, -0.202f, -0.769f)
            curveToRelative(-0.183f, -0.183f, -0.448f, -0.202f, -0.771f, -0.202f)
            close()
            moveTo(16.082f, 6.961f)
            curveToRelative(-0.323f, 0f, -0.587f, 0.019f, -0.771f, 0.202f)
            curveToRelative(-0.184f, 0.183f, -0.202f, 0.447f, -0.202f, 0.769f)
            curveToRelative(0f, 0.323f, 0.019f, 0.587f, 0.203f, 0.769f)
            curveToRelative(0.184f, 0.183f, 0.448f, 0.203f, 0.77f, 0.203f)
            curveToRelative(0.323f, -0f, 0.587f, -0.021f, 0.771f, -0.204f)
            curveToRelative(0.184f, -0.183f, 0.202f, -0.447f, 0.202f, -0.769f)
            reflectiveCurveToRelative(-0.018f, -0.586f, -0.202f, -0.769f)
            curveToRelative(-0.183f, -0.183f, -0.448f, -0.202f, -0.771f, -0.202f)
            horizontalLineToRelative(0f)
            close()
            moveTo(5.78f, 7.536f)
            curveToRelative(-0.117f, -0f, -0.245f, 0.029f, -0.387f, 0.067f)
            curveToRelative(-0.251f, 0.067f, -0.453f, 0.137f, -0.557f, 0.317f)
            curveToRelative(-0.105f, 0.181f, -0.064f, 0.389f, 0.003f, 0.64f)
            curveToRelative(0.067f, 0.251f, 0.137f, 0.452f, 0.318f, 0.556f)
            curveToRelative(0.181f, 0.104f, 0.39f, 0.065f, 0.641f, -0.002f)
            curveToRelative(0.251f, -0.067f, 0.452f, -0.138f, 0.557f, -0.319f)
            curveToRelative(0.105f, -0.181f, 0.064f, -0.389f, -0.003f, -0.64f)
            curveToRelative(-0.067f, -0.251f, -0.137f, -0.452f, -0.318f, -0.556f)
            curveToRelative(-0.079f, -0.046f, -0.164f, -0.063f, -0.255f, -0.064f)
            lineToRelative(-0f, -0f)
            close()
            moveTo(18.159f, 7.537f)
            curveToRelative(-0.091f, 0f, -0.176f, 0.018f, -0.255f, 0.064f)
            curveToRelative(-0.181f, 0.104f, -0.251f, 0.305f, -0.318f, 0.556f)
            curveToRelative(-0.067f, 0.251f, -0.108f, 0.46f, -0.003f, 0.64f)
            curveToRelative(0.105f, 0.181f, 0.306f, 0.25f, 0.557f, 0.317f)
            curveToRelative(0.251f, 0.067f, 0.461f, 0.108f, 0.642f, 0.004f)
            curveToRelative(0.181f, -0.104f, 0.25f, -0.305f, 0.318f, -0.556f)
            curveToRelative(0.067f, -0.251f, 0.108f, -0.459f, 0.003f, -0.64f)
            curveToRelative(-0.105f, -0.181f, -0.306f, -0.252f, -0.557f, -0.319f)
            curveToRelative(-0.141f, -0.038f, -0.269f, -0.067f, -0.386f, -0.066f)
            horizontalLineToRelative(0f)
            close()
            moveTo(20.118f, 8.727f)
            curveToRelative(-0.156f, 0f, -0.278f, 0.104f, -0.415f, 0.241f)
            curveToRelative(-0.138f, 0.138f, -0.242f, 0.259f, -0.242f, 0.415f)
            curveToRelative(0f, 0.156f, 0.105f, 0.277f, 0.242f, 0.414f)
            curveToRelative(0.138f, 0.137f, 0.258f, 0.242f, 0.415f, 0.242f)
            curveToRelative(0.157f, -0f, 0.277f, -0.105f, 0.415f, -0.242f)
            curveToRelative(0.138f, -0.138f, 0.242f, -0.258f, 0.243f, -0.414f)
            curveToRelative(0f, -0.156f, -0.105f, -0.277f, -0.242f, -0.414f)
            curveToRelative(-0.138f, -0.138f, -0.259f, -0.242f, -0.415f, -0.242f)
            close()
            moveTo(6.497f, 9.449f)
            curveToRelative(-0.202f, -0.003f, -0.402f, 0.099f, -0.63f, 0.23f)
            curveToRelative(-0.28f, 0.162f, -0.5f, 0.31f, -0.568f, 0.561f)
            curveToRelative(-0.067f, 0.251f, 0.049f, 0.489f, 0.21f, 0.769f)
            curveToRelative(0.162f, 0.28f, 0.311f, 0.5f, 0.562f, 0.566f)
            curveToRelative(0.251f, 0.067f, 0.49f, -0.048f, 0.77f, -0.209f)
            curveToRelative(0.28f, -0.162f, 0.499f, -0.312f, 0.567f, -0.562f)
            curveToRelative(0.067f, -0.251f, -0.049f, -0.489f, -0.21f, -0.768f)
            curveToRelative(-0.162f, -0.28f, -0.31f, -0.499f, -0.561f, -0.566f)
            curveToRelative(-0.047f, -0.013f, -0.094f, -0.019f, -0.14f, -0.019f)
            verticalLineToRelative(-0f)
            close()
            moveTo(17.442f, 9.45f)
            curveToRelative(-0.047f, 0.001f, -0.093f, 0.007f, -0.14f, 0.019f)
            curveToRelative(-0.251f, 0.067f, -0.4f, 0.286f, -0.562f, 0.566f)
            curveToRelative(-0.162f, 0.28f, -0.278f, 0.518f, -0.211f, 0.769f)
            curveToRelative(0.067f, 0.251f, 0.287f, 0.399f, 0.568f, 0.561f)
            curveToRelative(0.28f, 0.162f, 0.519f, 0.278f, 0.77f, 0.211f)
            curveToRelative(0.251f, -0.067f, 0.4f, -0.287f, 0.561f, -0.566f)
            curveToRelative(0.162f, -0.28f, 0.278f, -0.518f, 0.21f, -0.768f)
            curveToRelative(-0.067f, -0.251f, -0.286f, -0.401f, -0.567f, -0.562f)
            curveToRelative(-0.227f, -0.131f, -0.428f, -0.231f, -0.63f, -0.228f)
            lineToRelative(0f, 0f)
            close()
            moveTo(3.724f, 9.636f)
            curveToRelative(-0.088f, -0f, -0.184f, 0.022f, -0.29f, 0.05f)
            curveToRelative(-0.188f, 0.05f, -0.339f, 0.102f, -0.418f, 0.238f)
            curveToRelative(-0.078f, 0.135f, -0.048f, 0.292f, 0.002f, 0.48f)
            curveToRelative(0.05f, 0.188f, 0.103f, 0.339f, 0.238f, 0.417f)
            horizontalLineToRelative(0f)
            curveToRelative(0.136f, 0.078f, 0.292f, 0.049f, 0.48f, -0.002f)
            curveToRelative(0.188f, -0.05f, 0.339f, -0.104f, 0.417f, -0.239f)
            curveToRelative(0.078f, -0.135f, 0.048f, -0.292f, -0.002f, -0.479f)
            curveToRelative(-0.05f, -0.188f, -0.102f, -0.338f, -0.238f, -0.416f)
            curveToRelative(-0.059f, -0.034f, -0.123f, -0.048f, -0.191f, -0.048f)
            lineToRelative(-0f, -0f)
            close()
            moveTo(19.333f, 11.133f)
            curveToRelative(-0.211f, -0f, -0.373f, 0.141f, -0.559f, 0.326f)
            curveToRelative(-0.186f, 0.185f, -0.327f, 0.348f, -0.326f, 0.559f)
            curveToRelative(0f, 0.21f, 0.14f, 0.374f, 0.326f, 0.559f)
            curveToRelative(0.186f, 0.185f, 0.349f, 0.325f, 0.56f, 0.325f)
            curveToRelative(0.211f, 0f, 0.373f, -0.141f, 0.559f, -0.326f)
            curveToRelative(0.185f, -0.185f, 0.327f, -0.347f, 0.326f, -0.558f)
            curveToRelative(0f, -0.211f, -0.141f, -0.373f, -0.327f, -0.558f)
            curveToRelative(-0.186f, -0.185f, -0.348f, -0.326f, -0.559f, -0.327f)
            close()
            moveTo(4.605f, 11.151f)
            curveToRelative(-0.211f, -0f, -0.373f, 0.141f, -0.559f, 0.326f)
            reflectiveCurveToRelative(-0.327f, 0.347f, -0.326f, 0.558f)
            curveToRelative(0f, 0.211f, 0.141f, 0.373f, 0.327f, 0.558f)
            curveToRelative(0.186f, 0.185f, 0.348f, 0.326f, 0.559f, 0.327f)
            curveToRelative(0.211f, 0f, 0.373f, -0.141f, 0.559f, -0.326f)
            curveToRelative(0.186f, -0.185f, 0.327f, -0.348f, 0.326f, -0.559f)
            curveToRelative(-0f, -0.21f, -0.14f, -0.374f, -0.326f, -0.559f)
            curveToRelative(-0.186f, -0.185f, -0.349f, -0.325f, -0.56f, -0.325f)
            verticalLineToRelative(-0f)
            close()
            moveTo(6.211f, 12.458f)
            curveToRelative(-0.047f, 0.001f, -0.093f, 0.007f, -0.14f, 0.019f)
            curveToRelative(-0.251f, 0.067f, -0.4f, 0.287f, -0.561f, 0.566f)
            reflectiveCurveToRelative(-0.278f, 0.518f, -0.21f, 0.768f)
            curveToRelative(0.067f, 0.251f, 0.286f, 0.401f, 0.567f, 0.562f)
            curveToRelative(0.28f, 0.161f, 0.519f, 0.276f, 0.77f, 0.209f)
            curveToRelative(0.251f, -0.067f, 0.4f, -0.286f, 0.562f, -0.566f)
            curveToRelative(0.162f, -0.28f, 0.278f, -0.518f, 0.21f, -0.769f)
            curveToRelative(-0.067f, -0.251f, -0.287f, -0.399f, -0.568f, -0.561f)
            curveToRelative(-0.228f, -0.131f, -0.428f, -0.233f, -0.63f, -0.23f)
            verticalLineToRelative(-0f)
            close()
            moveTo(17.726f, 12.459f)
            curveToRelative(-0.202f, -0.003f, -0.402f, 0.097f, -0.63f, 0.228f)
            curveToRelative(-0.28f, 0.162f, -0.499f, 0.312f, -0.567f, 0.562f)
            curveToRelative(-0.067f, 0.251f, 0.049f, 0.489f, 0.21f, 0.768f)
            reflectiveCurveToRelative(0.31f, 0.499f, 0.561f, 0.566f)
            curveToRelative(0.251f, 0.067f, 0.49f, -0.049f, 0.77f, -0.211f)
            curveToRelative(0.28f, -0.162f, 0.5f, -0.31f, 0.568f, -0.561f)
            curveToRelative(0.067f, -0.251f, -0.049f, -0.489f, -0.21f, -0.769f)
            curveToRelative(-0.162f, -0.28f, -0.311f, -0.5f, -0.562f, -0.566f)
            curveToRelative(-0.047f, -0.012f, -0.094f, -0.019f, -0.14f, -0.019f)
            verticalLineToRelative(0f)
            close()
            moveTo(20.489f, 13.185f)
            curveToRelative(-0.088f, -0f, -0.184f, 0.021f, -0.289f, 0.05f)
            curveToRelative(-0.188f, 0.05f, -0.339f, 0.104f, -0.417f, 0.239f)
            curveToRelative(-0.078f, 0.135f, -0.048f, 0.292f, 0.002f, 0.479f)
            curveToRelative(0.05f, 0.188f, 0.102f, 0.339f, 0.238f, 0.417f)
            curveToRelative(0.136f, 0.078f, 0.292f, 0.048f, 0.481f, -0.003f)
            curveToRelative(0.188f, -0.05f, 0.339f, -0.102f, 0.418f, -0.238f)
            curveToRelative(0.078f, -0.135f, 0.048f, -0.292f, -0.002f, -0.48f)
            curveToRelative(-0.05f, -0.188f, -0.103f, -0.339f, -0.238f, -0.417f)
            curveToRelative(-0.059f, -0.034f, -0.123f, -0.048f, -0.191f, -0.048f)
            verticalLineToRelative(0f)
            close()
            moveTo(3.821f, 14.013f)
            curveToRelative(-0.157f, 0f, -0.277f, 0.105f, -0.415f, 0.242f)
            curveToRelative(-0.138f, 0.138f, -0.243f, 0.258f, -0.243f, 0.414f)
            curveToRelative(-0f, 0.156f, 0.105f, 0.277f, 0.242f, 0.414f)
            curveToRelative(0.138f, 0.138f, 0.259f, 0.242f, 0.415f, 0.242f)
            curveToRelative(0.156f, -0f, 0.278f, -0.104f, 0.415f, -0.241f)
            curveToRelative(0.138f, -0.138f, 0.242f, -0.259f, 0.242f, -0.415f)
            curveToRelative(0f, -0.156f, -0.105f, -0.277f, -0.242f, -0.414f)
            curveToRelative(-0.138f, -0.137f, -0.258f, -0.242f, -0.415f, -0.242f)
            close()
            moveTo(5.412f, 14.872f)
            curveToRelative(-0.091f, 0f, -0.176f, 0.018f, -0.255f, 0.064f)
            curveToRelative(-0.181f, 0.104f, -0.25f, 0.306f, -0.318f, 0.556f)
            curveToRelative(-0.067f, 0.251f, -0.108f, 0.459f, -0.003f, 0.64f)
            curveToRelative(0.105f, 0.181f, 0.306f, 0.252f, 0.557f, 0.319f)
            curveToRelative(0.251f, 0.067f, 0.46f, 0.106f, 0.641f, 0.002f)
            curveToRelative(0.181f, -0.104f, 0.251f, -0.305f, 0.318f, -0.556f)
            curveToRelative(0.067f, -0.251f, 0.108f, -0.46f, 0.003f, -0.64f)
            curveToRelative(-0.105f, -0.181f, -0.306f, -0.25f, -0.557f, -0.317f)
            curveToRelative(-0.141f, -0.038f, -0.269f, -0.067f, -0.387f, -0.067f)
            lineToRelative(0f, 0f)
            close()
            moveTo(18.526f, 14.872f)
            curveToRelative(-0.117f, -0f, -0.245f, 0.028f, -0.386f, 0.066f)
            curveToRelative(-0.251f, 0.067f, -0.452f, 0.138f, -0.557f, 0.319f)
            curveToRelative(-0.105f, 0.181f, -0.064f, 0.389f, 0.003f, 0.64f)
            curveToRelative(0.067f, 0.251f, 0.137f, 0.452f, 0.318f, 0.556f)
            curveToRelative(0.181f, 0.104f, 0.39f, 0.064f, 0.641f, -0.004f)
            curveToRelative(0.251f, -0.067f, 0.453f, -0.137f, 0.557f, -0.317f)
            curveToRelative(0.105f, -0.181f, 0.064f, -0.389f, -0.003f, -0.64f)
            curveToRelative(-0.067f, -0.251f, -0.137f, -0.452f, -0.318f, -0.556f)
            curveToRelative(-0.079f, -0.045f, -0.164f, -0.063f, -0.255f, -0.064f)
            lineToRelative(0f, 0f)
            close()
            moveTo(7.859f, 15.158f)
            curveToRelative(-0.323f, 0f, -0.587f, 0.021f, -0.771f, 0.204f)
            curveToRelative(-0.184f, 0.183f, -0.202f, 0.447f, -0.202f, 0.769f)
            curveToRelative(-0f, 0.322f, 0.019f, 0.586f, 0.202f, 0.769f)
            curveToRelative(0.183f, 0.183f, 0.448f, 0.202f, 0.771f, 0.202f)
            curveToRelative(0.323f, -0f, 0.587f, -0.019f, 0.771f, -0.202f)
            curveToRelative(0.184f, -0.183f, 0.202f, -0.447f, 0.202f, -0.769f)
            curveToRelative(-0f, -0.323f, -0.019f, -0.587f, -0.203f, -0.769f)
            curveToRelative(-0.184f, -0.183f, -0.448f, -0.203f, -0.77f, -0.203f)
            close()
            moveTo(16.077f, 15.158f)
            curveToRelative(-0.323f, 0f, -0.587f, 0.021f, -0.771f, 0.204f)
            curveToRelative(-0.184f, 0.183f, -0.202f, 0.447f, -0.202f, 0.769f)
            curveToRelative(0f, 0.322f, 0.018f, 0.586f, 0.202f, 0.769f)
            curveToRelative(0.183f, 0.183f, 0.448f, 0.202f, 0.771f, 0.202f)
            curveToRelative(0.323f, -0f, 0.587f, -0.019f, 0.771f, -0.202f)
            curveToRelative(0.184f, -0.183f, 0.202f, -0.447f, 0.202f, -0.769f)
            curveToRelative(0f, -0.323f, -0.019f, -0.587f, -0.203f, -0.769f)
            curveToRelative(-0.184f, -0.183f, -0.448f, -0.203f, -0.77f, -0.203f)
            horizontalLineToRelative(-0f)
            close()
            moveTo(10.607f, 16.554f)
            curveToRelative(-0.202f, -0.003f, -0.403f, 0.097f, -0.631f, 0.229f)
            curveToRelative(-0.281f, 0.162f, -0.5f, 0.312f, -0.568f, 0.563f)
            curveToRelative(-0.068f, 0.251f, 0.049f, 0.49f, 0.211f, 0.77f)
            curveToRelative(0.162f, 0.28f, 0.311f, 0.5f, 0.562f, 0.567f)
            curveToRelative(0.252f, 0.067f, 0.491f, -0.049f, 0.771f, -0.211f)
            curveToRelative(0.281f, -0.162f, 0.501f, -0.31f, 0.569f, -0.562f)
            curveToRelative(0.068f, -0.251f, -0.049f, -0.49f, -0.211f, -0.77f)
            curveToRelative(-0.162f, -0.28f, -0.311f, -0.5f, -0.563f, -0.567f)
            horizontalLineToRelative(-0f)
            curveToRelative(-0.047f, -0.012f, -0.094f, -0.019f, -0.14f, -0.019f)
            horizontalLineToRelative(0f)
            close()
            moveTo(13.334f, 16.554f)
            curveToRelative(-0.047f, 0.001f, -0.093f, 0.007f, -0.14f, 0.019f)
            curveToRelative(-0.252f, 0.067f, -0.401f, 0.287f, -0.563f, 0.567f)
            curveToRelative(-0.162f, 0.28f, -0.278f, 0.519f, -0.211f, 0.77f)
            curveToRelative(0.068f, 0.251f, 0.288f, 0.4f, 0.569f, 0.562f)
            curveToRelative(0.281f, 0.162f, 0.52f, 0.278f, 0.771f, 0.211f)
            curveToRelative(0.252f, -0.067f, 0.4f, -0.287f, 0.562f, -0.567f)
            curveToRelative(0.162f, -0.28f, 0.278f, -0.518f, 0.211f, -0.77f)
            curveToRelative(-0.068f, -0.251f, -0.287f, -0.401f, -0.568f, -0.563f)
            curveToRelative(-0.228f, -0.131f, -0.429f, -0.231f, -0.631f, -0.229f)
            horizontalLineToRelative(0f)
            close()
            moveTo(18.201f, 17.126f)
            curveToRelative(-0.07f, 0f, -0.134f, 0.014f, -0.195f, 0.049f)
            curveToRelative(-0.138f, 0.079f, -0.192f, 0.233f, -0.243f, 0.425f)
            curveToRelative(-0.051f, 0.191f, -0.082f, 0.351f, -0.002f, 0.489f)
            curveToRelative(0.08f, 0.138f, 0.234f, 0.191f, 0.425f, 0.242f)
            curveToRelative(0.192f, 0.051f, 0.352f, 0.082f, 0.49f, 0.003f)
            curveToRelative(0.138f, -0.08f, 0.191f, -0.233f, 0.242f, -0.424f)
            curveToRelative(0.051f, -0.191f, 0.082f, -0.351f, 0.002f, -0.489f)
            curveToRelative(-0.08f, -0.138f, -0.233f, -0.192f, -0.425f, -0.243f)
            curveToRelative(-0.108f, -0.029f, -0.205f, -0.051f, -0.295f, -0.051f)
            verticalLineToRelative(-0f)
            close()
            moveTo(8.474f, 17.577f)
            curveToRelative(-0.117f, -0f, -0.245f, 0.028f, -0.386f, 0.066f)
            curveToRelative(-0.251f, 0.067f, -0.452f, 0.138f, -0.557f, 0.319f)
            curveToRelative(-0.105f, 0.181f, -0.064f, 0.389f, 0.003f, 0.64f)
            curveToRelative(0.067f, 0.25f, 0.137f, 0.452f, 0.318f, 0.556f)
            curveToRelative(0.181f, 0.104f, 0.39f, 0.064f, 0.641f, -0.004f)
            curveToRelative(0.251f, -0.067f, 0.453f, -0.137f, 0.557f, -0.317f)
            curveToRelative(0.105f, -0.181f, 0.064f, -0.389f, -0.003f, -0.64f)
            curveToRelative(-0.067f, -0.251f, -0.137f, -0.452f, -0.318f, -0.556f)
            curveToRelative(-0.079f, -0.045f, -0.164f, -0.064f, -0.255f, -0.064f)
            lineToRelative(-0f, 0f)
            close()
            moveTo(15.466f, 17.577f)
            curveToRelative(-0.091f, 0f, -0.176f, 0.019f, -0.255f, 0.064f)
            curveToRelative(-0.181f, 0.104f, -0.251f, 0.305f, -0.318f, 0.556f)
            curveToRelative(-0.067f, 0.251f, -0.108f, 0.459f, -0.003f, 0.64f)
            curveToRelative(0.105f, 0.181f, 0.306f, 0.25f, 0.557f, 0.317f)
            curveToRelative(0.251f, 0.067f, 0.46f, 0.108f, 0.641f, 0.004f)
            curveToRelative(0.181f, -0.104f, 0.25f, -0.305f, 0.317f, -0.556f)
            reflectiveCurveToRelative(0.108f, -0.459f, 0.003f, -0.64f)
            curveToRelative(-0.105f, -0.181f, -0.306f, -0.252f, -0.557f, -0.319f)
            curveToRelative(-0.141f, -0.038f, -0.269f, -0.067f, -0.386f, -0.066f)
            horizontalLineToRelative(0f)
            close()
            moveTo(6.097f, 17.752f)
            curveToRelative(-0.07f, 0f, -0.134f, 0.014f, -0.195f, 0.049f)
            curveToRelative(-0.138f, 0.079f, -0.192f, 0.233f, -0.243f, 0.425f)
            curveToRelative(-0.051f, 0.191f, -0.082f, 0.351f, -0.002f, 0.489f)
            curveToRelative(0.08f, 0.138f, 0.234f, 0.191f, 0.425f, 0.242f)
            curveToRelative(0.192f, 0.051f, 0.352f, 0.082f, 0.49f, 0.003f)
            curveToRelative(0.138f, -0.08f, 0.191f, -0.233f, 0.242f, -0.424f)
            reflectiveCurveToRelative(0.082f, -0.351f, 0.002f, -0.488f)
            curveToRelative(-0.08f, -0.138f, -0.233f, -0.192f, -0.425f, -0.243f)
            curveToRelative(-0.108f, -0.029f, -0.205f, -0.051f, -0.295f, -0.051f)
            verticalLineToRelative(0f)
            close()
            moveTo(11.966f, 18.498f)
            curveToRelative(-0.211f, -0f, -0.373f, 0.141f, -0.559f, 0.326f)
            reflectiveCurveToRelative(-0.327f, 0.347f, -0.326f, 0.558f)
            curveToRelative(0f, 0.211f, 0.141f, 0.373f, 0.327f, 0.558f)
            curveToRelative(0.186f, 0.185f, 0.348f, 0.326f, 0.559f, 0.326f)
            curveToRelative(0.211f, 0f, 0.373f, -0.141f, 0.559f, -0.326f)
            curveToRelative(0.186f, -0.185f, 0.327f, -0.348f, 0.326f, -0.559f)
            curveToRelative(-0f, -0.21f, -0.14f, -0.374f, -0.326f, -0.559f)
            curveToRelative(-0.186f, -0.185f, -0.349f, -0.325f, -0.56f, -0.325f)
            verticalLineToRelative(-0f)
            close()
            moveTo(14.618f, 19.512f)
            curveToRelative(-0.156f, -0f, -0.277f, 0.104f, -0.415f, 0.242f)
            curveToRelative(-0.138f, 0.137f, -0.242f, 0.258f, -0.242f, 0.414f)
            curveToRelative(0f, 0.156f, 0.105f, 0.277f, 0.242f, 0.414f)
            curveToRelative(0.138f, 0.138f, 0.258f, 0.242f, 0.415f, 0.242f)
            curveToRelative(0.156f, 0f, 0.277f, -0.104f, 0.415f, -0.242f)
            curveToRelative(0.138f, -0.138f, 0.242f, -0.258f, 0.242f, -0.414f)
            curveToRelative(-0.001f, -0.156f, -0.104f, -0.277f, -0.242f, -0.415f)
            curveToRelative(-0.138f, -0.138f, -0.259f, -0.241f, -0.416f, -0.241f)
            lineToRelative(0f, -0f)
            close()
            moveTo(10.322f, 19.776f)
            curveToRelative(-0.089f, -0f, -0.187f, 0.022f, -0.295f, 0.051f)
            curveToRelative(-0.192f, 0.051f, -0.345f, 0.105f, -0.425f, 0.243f)
            curveToRelative(-0.08f, 0.138f, -0.049f, 0.297f, 0.002f, 0.489f)
            reflectiveCurveToRelative(0.104f, 0.345f, 0.243f, 0.424f)
            curveToRelative(0.138f, 0.08f, 0.298f, 0.049f, 0.49f, -0.003f)
            curveToRelative(0.192f, -0.051f, 0.346f, -0.104f, 0.425f, -0.242f)
            curveToRelative(0.08f, -0.138f, 0.049f, -0.297f, -0.002f, -0.489f)
            curveToRelative(-0.051f, -0.191f, -0.105f, -0.345f, -0.243f, -0.425f)
            horizontalLineToRelative(-0f)
            curveToRelative(-0.06f, -0.035f, -0.125f, -0.048f, -0.195f, -0.049f)
            lineToRelative(0f, 0f)
            close()
        }
    }.build()
}
