/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2025 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons


import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Outlined.HandshakeAlt: ImageVector by lazy {
    ImageVector.Builder(
        name = "HandshakeAltOutline",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(21.71f, 8.71f)
            curveTo(22.96f, 7.46f, 22.39f, 6f, 21.71f, 5.29f)
            lineTo(18.71f, 2.29f)
            curveTo(17.45f, 1.04f, 16f, 1.61f, 15.29f, 2.29f)
            lineTo(13.59f, 4f)
            horizontalLineTo(11f)
            curveTo(9.1f, 4f, 8f, 5f, 7.44f, 6.15f)
            lineTo(3f, 10.59f)
            verticalLineTo(14.59f)
            lineTo(2.29f, 15.29f)
            curveTo(1.04f, 16.55f, 1.61f, 18f, 2.29f, 18.71f)
            lineTo(5.29f, 21.71f)
            curveTo(5.83f, 22.25f, 6.41f, 22.45f, 6.96f, 22.45f)
            curveTo(7.67f, 22.45f, 8.32f, 22.1f, 8.71f, 21.71f)
            lineTo(11.41f, 19f)
            horizontalLineTo(15f)
            curveTo(16.7f, 19f, 17.56f, 17.94f, 17.87f, 16.9f)
            curveTo(19f, 16.6f, 19.62f, 15.74f, 19.87f, 14.9f)
            curveTo(21.42f, 14.5f, 22f, 13.03f, 22f, 12f)
            verticalLineTo(9f)
            horizontalLineTo(21.41f)
            lineTo(21.71f, 8.71f)
            moveTo(20f, 12f)
            curveTo(20f, 12.45f, 19.81f, 13f, 19f, 13f)
            lineTo(18f, 13f)
            lineTo(18f, 14f)
            curveTo(18f, 14.45f, 17.81f, 15f, 17f, 15f)
            lineTo(16f, 15f)
            lineTo(16f, 16f)
            curveTo(16f, 16.45f, 15.81f, 17f, 15f, 17f)
            horizontalLineTo(10.59f)
            lineTo(7.31f, 20.28f)
            curveTo(7f, 20.57f, 6.82f, 20.4f, 6.71f, 20.29f)
            lineTo(3.72f, 17.31f)
            curveTo(3.43f, 17f, 3.6f, 16.82f, 3.71f, 16.71f)
            lineTo(5f, 15.41f)
            verticalLineTo(11.41f)
            lineTo(7f, 9.41f)
            verticalLineTo(11f)
            curveTo(7f, 12.21f, 7.8f, 14f, 10f, 14f)
            reflectiveCurveTo(13f, 12.21f, 13f, 11f)
            horizontalLineTo(20f)
            verticalLineTo(12f)
            moveTo(20.29f, 7.29f)
            lineTo(18.59f, 9f)
            horizontalLineTo(11f)
            verticalLineTo(11f)
            curveTo(11f, 11.45f, 10.81f, 12f, 10f, 12f)
            reflectiveCurveTo(9f, 11.45f, 9f, 11f)
            verticalLineTo(8f)
            curveTo(9f, 7.54f, 9.17f, 6f, 11f, 6f)
            horizontalLineTo(14.41f)
            lineTo(16.69f, 3.72f)
            curveTo(17f, 3.43f, 17.18f, 3.6f, 17.29f, 3.71f)
            lineTo(20.28f, 6.69f)
            curveTo(20.57f, 7f, 20.4f, 7.18f, 20.29f, 7.29f)
            close()
        }
    }.build()
}
