package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Rounded.Forum: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Rounded.Forum",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(280f, 720f)
            quadTo(263f, 720f, 251.5f, 708.5f)
            quadTo(240f, 697f, 240f, 680f)
            lineTo(240f, 600f)
            lineTo(760f, 600f)
            lineTo(760f, 600f)
            lineTo(760f, 240f)
            lineTo(840f, 240f)
            quadTo(857f, 240f, 868.5f, 251.5f)
            quadTo(880f, 263f, 880f, 280f)
            lineTo(880f, 880f)
            lineTo(720f, 720f)
            lineTo(280f, 720f)
            close()
            moveTo(80f, 680f)
            lineTo(80f, 120f)
            quadTo(80f, 103f, 91.5f, 91.5f)
            quadTo(103f, 80f, 120f, 80f)
            lineTo(640f, 80f)
            quadTo(657f, 80f, 668.5f, 91.5f)
            quadTo(680f, 103f, 680f, 120f)
            lineTo(680f, 480f)
            quadTo(680f, 497f, 668.5f, 508.5f)
            quadTo(657f, 520f, 640f, 520f)
            lineTo(240f, 520f)
            lineTo(80f, 680f)
            close()
        }
    }.build()
}

val Icons.Outlined.Forum: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Outlined.Forum",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(880f, 880f)
            lineTo(720f, 720f)
            lineTo(320f, 720f)
            quadTo(287f, 720f, 263.5f, 696.5f)
            quadTo(240f, 673f, 240f, 640f)
            lineTo(240f, 600f)
            lineTo(680f, 600f)
            quadTo(713f, 600f, 736.5f, 576.5f)
            quadTo(760f, 553f, 760f, 520f)
            lineTo(760f, 240f)
            lineTo(800f, 240f)
            quadTo(833f, 240f, 856.5f, 263.5f)
            quadTo(880f, 287f, 880f, 320f)
            lineTo(880f, 880f)
            close()
            moveTo(160f, 487f)
            lineTo(207f, 440f)
            lineTo(600f, 440f)
            quadTo(600f, 440f, 600f, 440f)
            quadTo(600f, 440f, 600f, 440f)
            lineTo(600f, 160f)
            quadTo(600f, 160f, 600f, 160f)
            quadTo(600f, 160f, 600f, 160f)
            lineTo(160f, 160f)
            quadTo(160f, 160f, 160f, 160f)
            quadTo(160f, 160f, 160f, 160f)
            lineTo(160f, 487f)
            close()
            moveTo(80f, 680f)
            lineTo(80f, 160f)
            quadTo(80f, 127f, 103.5f, 103.5f)
            quadTo(127f, 80f, 160f, 80f)
            lineTo(600f, 80f)
            quadTo(633f, 80f, 656.5f, 103.5f)
            quadTo(680f, 127f, 680f, 160f)
            lineTo(680f, 440f)
            quadTo(680f, 473f, 656.5f, 496.5f)
            quadTo(633f, 520f, 600f, 520f)
            lineTo(240f, 520f)
            lineTo(80f, 680f)
            close()
            moveTo(160f, 440f)
            lineTo(160f, 160f)
            quadTo(160f, 160f, 160f, 160f)
            quadTo(160f, 160f, 160f, 160f)
            lineTo(160f, 160f)
            quadTo(160f, 160f, 160f, 160f)
            quadTo(160f, 160f, 160f, 160f)
            lineTo(160f, 440f)
            quadTo(160f, 440f, 160f, 440f)
            quadTo(160f, 440f, 160f, 440f)
            lineTo(160f, 440f)
            close()
        }
    }.build()
}