/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2024 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Rounded.FontFamily: ImageVector by lazy {
    Builder(
        name = "Font Family", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
        viewportWidth = 960.0f, viewportHeight = 960.0f
    ).apply {
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(186.0f, 880.0f)
            quadToRelative(-54.0f, 0.0f, -80.0f, -22.0f)
            reflectiveQuadToRelative(-26.0f, -66.0f)
            quadToRelative(0.0f, -58.0f, 49.0f, -74.0f)
            reflectiveQuadToRelative(116.0f, -16.0f)
            horizontalLineToRelative(21.0f)
            verticalLineToRelative(-56.0f)
            quadToRelative(0.0f, -34.0f, -1.0f, -55.5f)
            reflectiveQuadToRelative(-6.0f, -35.5f)
            quadToRelative(-5.0f, -14.0f, -11.5f, -19.5f)
            reflectiveQuadTo(230.0f, 530.0f)
            quadToRelative(-9.0f, 0.0f, -16.5f, 3.0f)
            reflectiveQuadToRelative(-12.5f, 8.0f)
            quadToRelative(-4.0f, 5.0f, -5.0f, 10.5f)
            reflectiveQuadToRelative(1.0f, 11.5f)
            quadToRelative(6.0f, 11.0f, 14.0f, 21.5f)
            reflectiveQuadToRelative(8.0f, 24.5f)
            quadToRelative(0.0f, 25.0f, -17.5f, 42.5f)
            reflectiveQuadTo(159.0f, 669.0f)
            quadToRelative(-25.0f, 0.0f, -42.5f, -17.5f)
            reflectiveQuadTo(99.0f, 609.0f)
            quadToRelative(0.0f, -27.0f, 12.0f, -44.0f)
            reflectiveQuadToRelative(32.5f, -27.0f)
            quadToRelative(20.5f, -10.0f, 47.5f, -14.0f)
            reflectiveQuadToRelative(58.0f, -4.0f)
            quadToRelative(85.0f, 0.0f, 118.0f, 30.5f)
            reflectiveQuadTo(400.0f, 658.0f)
            verticalLineToRelative(147.0f)
            quadToRelative(0.0f, 19.0f, 4.5f, 28.0f)
            reflectiveQuadToRelative(15.5f, 9.0f)
            quadToRelative(12.0f, 0.0f, 19.5f, -18.0f)
            reflectiveQuadToRelative(9.5f, -56.0f)
            horizontalLineToRelative(11.0f)
            quadToRelative(-3.0f, 62.0f, -23.5f, 87.0f)
            reflectiveQuadTo(368.0f, 880.0f)
            quadToRelative(-43.0f, 0.0f, -67.5f, -13.5f)
            reflectiveQuadTo(269.0f, 826.0f)
            quadToRelative(-10.0f, 29.0f, -29.5f, 41.5f)
            reflectiveQuadTo(186.0f, 880.0f)
            close()
            moveTo(559.0f, 880.0f)
            quadToRelative(-20.0f, 0.0f, -32.5f, -16.5f)
            reflectiveQuadTo(522.0f, 828.0f)
            lineToRelative(102.0f, -269.0f)
            quadToRelative(7.0f, -17.0f, 22.0f, -28.0f)
            reflectiveQuadToRelative(34.0f, -11.0f)
            quadToRelative(19.0f, 0.0f, 34.0f, 11.0f)
            reflectiveQuadToRelative(22.0f, 28.0f)
            lineToRelative(102.0f, 269.0f)
            quadToRelative(8.0f, 19.0f, -4.5f, 35.5f)
            reflectiveQuadTo(801.0f, 880.0f)
            quadToRelative(-12.0f, 0.0f, -22.0f, -7.0f)
            reflectiveQuadToRelative(-15.0f, -19.0f)
            lineToRelative(-20.0f, -58.0f)
            lineTo(616.0f, 796.0f)
            lineToRelative(-20.0f, 58.0f)
            quadToRelative(-4.0f, 11.0f, -14.0f, 18.5f)
            reflectiveQuadTo(559.0f, 880.0f)
            close()
            moveTo(235.0f, 851.0f)
            quadToRelative(13.0f, 0.0f, 22.0f, -20.5f)
            reflectiveQuadToRelative(9.0f, -49.5f)
            verticalLineToRelative(-67.0f)
            quadToRelative(-26.0f, 0.0f, -38.0f, 15.5f)
            reflectiveQuadTo(216.0f, 780.0f)
            verticalLineToRelative(11.0f)
            quadToRelative(0.0f, 36.0f, 4.0f, 48.0f)
            reflectiveQuadToRelative(15.0f, 12.0f)
            close()
            moveTo(642.0f, 726.0f)
            horizontalLineToRelative(77.0f)
            lineToRelative(-39.0f, -114.0f)
            lineToRelative(-38.0f, 114.0f)
            close()
            moveTo(605.0f, 441.0f)
            quadToRelative(-48.0f, 0.0f, -76.5f, -33.5f)
            reflectiveQuadTo(500.0f, 317.0f)
            quadToRelative(0.0f, -104.0f, 66.0f, -170.5f)
            reflectiveQuadTo(735.0f, 80.0f)
            quadToRelative(42.0f, 0.0f, 68.0f, 9.5f)
            reflectiveQuadToRelative(26.0f, 24.5f)
            quadToRelative(0.0f, 6.0f, -2.0f, 12.0f)
            reflectiveQuadToRelative(-7.0f, 11.0f)
            quadToRelative(-5.0f, 7.0f, -12.5f, 10.0f)
            reflectiveQuadToRelative(-15.5f, 1.0f)
            quadToRelative(-14.0f, -4.0f, -32.0f, -7.0f)
            reflectiveQuadToRelative(-33.0f, -3.0f)
            quadToRelative(-71.0f, 0.0f, -114.0f, 48.0f)
            reflectiveQuadToRelative(-43.0f, 127.0f)
            quadToRelative(0.0f, 22.0f, 8.0f, 46.0f)
            reflectiveQuadToRelative(36.0f, 24.0f)
            quadToRelative(11.0f, 0.0f, 21.5f, -5.0f)
            reflectiveQuadToRelative(18.5f, -14.0f)
            quadToRelative(17.0f, -18.0f, 31.5f, -60.0f)
            reflectiveQuadTo(712.0f, 202.0f)
            quadToRelative(2.0f, -13.0f, 10.5f, -18.5f)
            reflectiveQuadTo(746.0f, 178.0f)
            quadToRelative(18.0f, 0.0f, 27.5f, 9.5f)
            reflectiveQuadTo(779.0f, 211.0f)
            quadToRelative(-12.0f, 43.0f, -17.5f, 75.0f)
            reflectiveQuadToRelative(-5.5f, 58.0f)
            quadToRelative(0.0f, 20.0f, 5.5f, 29.0f)
            reflectiveQuadToRelative(16.5f, 9.0f)
            quadToRelative(11.0f, 0.0f, 21.5f, -8.0f)
            reflectiveQuadToRelative(29.5f, -30.0f)
            quadToRelative(2.0f, -3.0f, 15.0f, -7.0f)
            quadToRelative(8.0f, 0.0f, 12.0f, 6.0f)
            reflectiveQuadToRelative(4.0f, 17.0f)
            quadToRelative(0.0f, 28.0f, -32.0f, 54.0f)
            reflectiveQuadToRelative(-67.0f, 26.0f)
            quadToRelative(-26.0f, 0.0f, -44.5f, -14.0f)
            reflectiveQuadTo(691.0f, 386.0f)
            quadToRelative(-15.0f, 26.0f, -37.0f, 40.5f)
            reflectiveQuadTo(605.0f, 441.0f)
            close()
            moveTo(120.0f, 440.0f)
            verticalLineToRelative(-220.0f)
            quadToRelative(0.0f, -58.0f, 41.0f, -99.0f)
            reflectiveQuadToRelative(99.0f, -41.0f)
            quadToRelative(58.0f, 0.0f, 99.0f, 41.0f)
            reflectiveQuadToRelative(41.0f, 99.0f)
            verticalLineToRelative(220.0f)
            horizontalLineToRelative(-80.0f)
            verticalLineToRelative(-80.0f)
            lineTo(200.0f, 360.0f)
            verticalLineToRelative(80.0f)
            horizontalLineToRelative(-80.0f)
            close()
            moveTo(200.0f, 280.0f)
            horizontalLineToRelative(120.0f)
            verticalLineToRelative(-60.0f)
            quadToRelative(0.0f, -25.0f, -17.5f, -42.5f)
            reflectiveQuadTo(260.0f, 160.0f)
            quadToRelative(-25.0f, 0.0f, -42.5f, 17.5f)
            reflectiveQuadTo(200.0f, 220.0f)
            verticalLineToRelative(60.0f)
            close()
        }
    }
        .build()
}