/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2025 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Outlined.ExifEdit: ImageVector by lazy {
    ImageVector.Builder(
        name = "Outlined.ExifEdit",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(17.138f, 9.874f)
            lineToRelative(-7.023f, -7.023f)
            curveTo(9.803f, 2.539f, 9.413f, 2.383f, 9.023f, 2.383f)
            horizontalLineTo(3.561f)
            curveTo(2.702f, 2.383f, 2f, 3.085f, 2f, 3.944f)
            verticalLineToRelative(5.462f)
            curveToRelative(0f, 0.39f, 0.156f, 0.78f, 0.468f, 1.092f)
            lineToRelative(7.023f, 7.023f)
            curveToRelative(0.312f, 0.312f, 0.702f, 0.468f, 1.092f, 0.468f)
            reflectiveCurveToRelative(0.78f, -0.156f, 1.092f, -0.468f)
            lineToRelative(5.462f, -5.462f)
            curveToRelative(0.312f, -0.312f, 0.468f, -0.702f, 0.468f, -1.092f)
            curveTo(17.606f, 10.576f, 17.45f, 10.186f, 17.138f, 9.874f)
            close()
            moveTo(10.584f, 16.429f)
            lineToRelative(-7.023f, -7.023f)
            verticalLineTo(3.944f)
            horizontalLineTo(9.023f)
            lineToRelative(7.023f, 7.023f)
            lineTo(10.584f, 16.429f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(5.322f, 4.724f)
            curveToRelative(0.523f, 0f, 0.981f, 0.458f, 0.981f, 0.981f)
            reflectiveCurveTo(5.845f, 6.686f, 5.322f, 6.686f)
            reflectiveCurveTo(4.341f, 6.228f, 4.341f, 5.705f)
            reflectiveCurveTo(4.799f, 4.724f, 5.322f, 4.724f)
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(9.605f, 12.27f)
            lineToRelative(-0.576f, -0.576f)
            lineToRelative(2.302f, -2.302f)
            lineToRelative(0.576f, 0.576f)
            lineToRelative(-2.302f, 2.302f)
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(13.058f, 12.27f)
            lineToRelative(-0.576f, -0.576f)
            lineToRelative(-0.384f, 0.384f)
            lineToRelative(0.576f, 0.576f)
            lineToRelative(-0.576f, 0.576f)
            lineToRelative(-0.576f, -0.576f)
            lineToRelative(-0.767f, 0.767f)
            lineToRelative(-0.576f, -0.576f)
            lineToRelative(2.302f, -2.302f)
            lineToRelative(1.151f, 1.151f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(8.117f, 7.329f)
            lineToRelative(0.576f, 0.576f)
            lineToRelative(0.576f, -0.576f)
            lineToRelative(-0.576f, -0.576f)
            lineToRelative(-0.576f, -0.576f)
            lineToRelative(-0.904f, 0.904f)
            lineToRelative(-0.495f, 0.495f)
            lineToRelative(-0.904f, 0.904f)
            lineToRelative(0.576f, 0.576f)
            lineToRelative(0.576f, 0.576f)
            lineToRelative(0.576f, -0.576f)
            lineToRelative(-0.576f, -0.576f)
            lineToRelative(0.192f, -0.192f)
            lineToRelative(0.136f, -0.136f)
            lineToRelative(0.576f, 0.576f)
            lineToRelative(0.495f, -0.495f)
            lineToRelative(-0.576f, -0.576f)
            lineToRelative(0.136f, -0.136f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(9.612f, 7.659f)
            lineTo(8.917f, 9.28f)
            lineTo(7.295f, 9.975f)
            lineToRelative(0.463f, 0.463f)
            lineToRelative(0.811f, -0.347f)
            lineToRelative(-0.347f, 0.811f)
            lineToRelative(0.463f, 0.463f)
            lineToRelative(0.695f, -1.621f)
            lineToRelative(1.621f, -0.695f)
            lineToRelative(-0.463f, -0.463f)
            lineTo(9.728f, 8.933f)
            lineToRelative(0.347f, -0.811f)
            lineTo(9.612f, 7.659f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(21.886f, 14.399f)
            curveToRelative(-0.076f, -0.186f, -0.182f, -0.355f, -0.317f, -0.507f)
            lineToRelative(-0.937f, -0.937f)
            curveToRelative(-0.152f, -0.152f, -0.321f, -0.266f, -0.507f, -0.342f)
            curveTo(19.94f, 12.538f, 19.746f, 12.5f, 19.543f, 12.5f)
            curveToRelative(-0.186f, 0f, -0.371f, 0.034f, -0.557f, 0.101f)
            curveToRelative(-0.186f, 0.068f, -0.355f, 0.177f, -0.507f, 0.329f)
            lineToRelative(-5.293f, 5.268f)
            curveToRelative(-0.101f, 0.101f, -0.177f, 0.215f, -0.228f, 0.342f)
            reflectiveCurveToRelative(-0.076f, 0.258f, -0.076f, 0.393f)
            verticalLineToRelative(1.671f)
            curveToRelative(0f, 0.287f, 0.097f, 0.528f, 0.291f, 0.722f)
            curveToRelative(0.194f, 0.194f, 0.435f, 0.291f, 0.722f, 0.291f)
            horizontalLineToRelative(1.671f)
            curveToRelative(0.135f, 0f, 0.266f, -0.025f, 0.392f, -0.076f)
            curveToRelative(0.127f, -0.051f, 0.241f, -0.127f, 0.342f, -0.228f)
            lineToRelative(5.268f, -5.268f)
            curveToRelative(0.152f, -0.152f, 0.262f, -0.325f, 0.329f, -0.519f)
            curveTo(21.966f, 15.332f, 22f, 15.142f, 22f, 14.957f)
            reflectiveCurveTo(21.962f, 14.585f, 21.886f, 14.399f)
            close()
            moveTo(15.365f, 20.098f)
            horizontalLineTo(14.402f)
            verticalLineToRelative(-0.962f)
            lineToRelative(3.09f, -3.064f)
            lineToRelative(0.481f, 0.456f)
            lineToRelative(0.456f, 0.481f)
            lineTo(15.365f, 20.098f)
            close()
        }
    }.build()
}

val Icons.TwoTone.ExifEdit: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "TwoTone.ExifEdit",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(
            fill = SolidColor(Color(0xFF000000)),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(10.584f, 16.429f)
            lineToRelative(-7.023f, -7.023f)
            lineToRelative(0f, -5.462f)
            lineToRelative(5.462f, 0f)
            lineToRelative(7.023f, 7.023f)
            lineToRelative(-5.462f, 5.462f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(5.322f, 4.724f)
            curveToRelative(0.523f, 0f, 0.981f, 0.458f, 0.981f, 0.981f)
            reflectiveCurveToRelative(-0.458f, 0.981f, -0.981f, 0.981f)
            reflectiveCurveToRelative(-0.981f, -0.458f, -0.981f, -0.981f)
            reflectiveCurveToRelative(0.458f, -0.981f, 0.981f, -0.981f)
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(9.605f, 12.27f)
            lineToRelative(-0.576f, -0.576f)
            lineToRelative(2.302f, -2.302f)
            lineToRelative(0.576f, 0.576f)
            lineToRelative(-2.302f, 2.302f)
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(13.058f, 12.27f)
            lineToRelative(-0.576f, -0.576f)
            lineToRelative(-0.384f, 0.384f)
            lineToRelative(0.576f, 0.576f)
            lineToRelative(-0.576f, 0.576f)
            lineToRelative(-0.576f, -0.576f)
            lineToRelative(-0.767f, 0.767f)
            lineToRelative(-0.576f, -0.576f)
            lineToRelative(2.302f, -2.302f)
            lineToRelative(1.151f, 1.151f)
            lineToRelative(-0.574f, 0.576f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(8.117f, 7.329f)
            lineToRelative(0.576f, 0.576f)
            lineToRelative(0.576f, -0.576f)
            lineToRelative(-0.576f, -0.576f)
            lineToRelative(-0.576f, -0.576f)
            lineToRelative(-0.904f, 0.904f)
            lineToRelative(-0.495f, 0.495f)
            lineToRelative(-0.904f, 0.904f)
            lineToRelative(0.576f, 0.576f)
            lineToRelative(0.576f, 0.576f)
            lineToRelative(0.576f, -0.576f)
            lineToRelative(-0.576f, -0.576f)
            lineToRelative(0.192f, -0.192f)
            lineToRelative(0.136f, -0.136f)
            lineToRelative(0.576f, 0.576f)
            lineToRelative(0.495f, -0.495f)
            lineToRelative(-0.576f, -0.576f)
            lineToRelative(0.136f, -0.136f)
            lineToRelative(0.192f, -0.192f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(9.612f, 7.659f)
            lineToRelative(-0.695f, 1.621f)
            lineToRelative(-1.622f, 0.695f)
            lineToRelative(0.463f, 0.463f)
            lineToRelative(0.811f, -0.347f)
            lineToRelative(-0.347f, 0.811f)
            lineToRelative(0.463f, 0.463f)
            lineToRelative(0.695f, -1.621f)
            lineToRelative(1.621f, -0.695f)
            lineToRelative(-0.463f, -0.463f)
            lineToRelative(-0.81f, 0.347f)
            lineToRelative(0.347f, -0.811f)
            lineToRelative(-0.463f, -0.463f)
            close()
        }
        path(
            fill = SolidColor(Color(0xFF000000)),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(15.365f, 20.098f)
            lineToRelative(-0.963f, 0f)
            lineToRelative(0f, -0.962f)
            lineToRelative(3.09f, -3.064f)
            lineToRelative(0.481f, 0.456f)
            lineToRelative(0.456f, 0.481f)
            lineToRelative(-3.064f, 3.089f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(21.886f, 14.399f)
            curveToRelative(-0.076f, -0.186f, -0.182f, -0.355f, -0.317f, -0.507f)
            lineToRelative(-0.937f, -0.937f)
            curveToRelative(-0.152f, -0.152f, -0.321f, -0.266f, -0.507f, -0.342f)
            curveToRelative(-0.185f, -0.075f, -0.379f, -0.113f, -0.582f, -0.113f)
            curveToRelative(-0.186f, 0f, -0.371f, 0.034f, -0.557f, 0.101f)
            curveToRelative(-0.186f, 0.068f, -0.355f, 0.177f, -0.507f, 0.329f)
            lineToRelative(-5.293f, 5.268f)
            curveToRelative(-0.101f, 0.101f, -0.177f, 0.215f, -0.228f, 0.342f)
            curveToRelative(-0.051f, 0.127f, -0.076f, 0.258f, -0.076f, 0.393f)
            verticalLineToRelative(1.671f)
            curveToRelative(0f, 0.287f, 0.097f, 0.528f, 0.291f, 0.722f)
            curveToRelative(0.194f, 0.194f, 0.435f, 0.291f, 0.722f, 0.291f)
            horizontalLineToRelative(1.671f)
            curveToRelative(0.135f, 0f, 0.266f, -0.025f, 0.392f, -0.076f)
            curveToRelative(0.127f, -0.051f, 0.241f, -0.127f, 0.342f, -0.228f)
            lineToRelative(5.268f, -5.268f)
            curveToRelative(0.152f, -0.152f, 0.262f, -0.325f, 0.329f, -0.519f)
            curveToRelative(0.069f, -0.194f, 0.103f, -0.384f, 0.103f, -0.569f)
            reflectiveCurveToRelative(-0.038f, -0.372f, -0.114f, -0.558f)
            close()
            moveTo(15.365f, 20.098f)
            horizontalLineToRelative(-0.963f)
            verticalLineToRelative(-0.962f)
            lineToRelative(3.09f, -3.064f)
            lineToRelative(0.481f, 0.456f)
            lineToRelative(0.456f, 0.481f)
            lineToRelative(-3.064f, 3.089f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(17.138f, 9.874f)
            lineToRelative(-7.023f, -7.023f)
            curveToRelative(-0.312f, -0.312f, -0.702f, -0.468f, -1.092f, -0.468f)
            horizontalLineTo(3.561f)
            curveToRelative(-0.859f, 0f, -1.561f, 0.702f, -1.561f, 1.561f)
            verticalLineToRelative(5.462f)
            curveToRelative(0f, 0.39f, 0.156f, 0.78f, 0.468f, 1.092f)
            lineToRelative(7.023f, 7.023f)
            curveToRelative(0.312f, 0.312f, 0.702f, 0.468f, 1.092f, 0.468f)
            reflectiveCurveToRelative(0.78f, -0.156f, 1.092f, -0.468f)
            lineToRelative(5.462f, -5.462f)
            curveToRelative(0.312f, -0.312f, 0.468f, -0.702f, 0.468f, -1.092f)
            curveToRelative(0.001f, -0.391f, -0.155f, -0.781f, -0.467f, -1.093f)
            close()
            moveTo(10.584f, 16.429f)
            lineToRelative(-7.023f, -7.023f)
            verticalLineTo(3.944f)
            horizontalLineToRelative(5.462f)
            lineToRelative(7.023f, 7.023f)
            lineToRelative(-5.462f, 5.462f)
            close()
        }
    }.build()
}