/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2024 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Outlined.AppShortcut: ImageVector by lazy {
    ImageVector.Builder(
        name = "AppShortcutOutlined",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(280f, 800f)
            lineTo(280f, 840f)
            quadTo(280f, 840f, 280f, 840f)
            quadTo(280f, 840f, 280f, 840f)
            lineTo(680f, 840f)
            quadTo(680f, 840f, 680f, 840f)
            quadTo(680f, 840f, 680f, 840f)
            lineTo(680f, 800f)
            lineTo(280f, 800f)
            close()
            moveTo(280f, 160f)
            lineTo(680f, 160f)
            lineTo(680f, 120f)
            quadTo(680f, 120f, 680f, 120f)
            quadTo(680f, 120f, 680f, 120f)
            lineTo(280f, 120f)
            quadTo(280f, 120f, 280f, 120f)
            quadTo(280f, 120f, 280f, 120f)
            lineTo(280f, 160f)
            close()
            moveTo(280f, 160f)
            lineTo(280f, 120f)
            quadTo(280f, 120f, 280f, 120f)
            quadTo(280f, 120f, 280f, 120f)
            lineTo(280f, 120f)
            quadTo(280f, 120f, 280f, 120f)
            quadTo(280f, 120f, 280f, 120f)
            lineTo(280f, 160f)
            close()
            moveTo(280f, 800f)
            lineTo(280f, 800f)
            lineTo(280f, 840f)
            quadTo(280f, 840f, 280f, 840f)
            quadTo(280f, 840f, 280f, 840f)
            lineTo(280f, 840f)
            quadTo(280f, 840f, 280f, 840f)
            quadTo(280f, 840f, 280f, 840f)
            lineTo(280f, 800f)
            close()
            moveTo(686f, 520f)
            lineTo(480f, 520f)
            quadTo(480f, 520f, 480f, 520f)
            quadTo(480f, 520f, 480f, 520f)
            lineTo(480f, 600f)
            quadTo(480f, 617f, 468.5f, 628.5f)
            quadTo(457f, 640f, 440f, 640f)
            quadTo(423f, 640f, 411.5f, 628.5f)
            quadTo(400f, 617f, 400f, 600f)
            lineTo(400f, 520f)
            quadTo(400f, 487f, 423.5f, 463.5f)
            quadTo(447f, 440f, 480f, 440f)
            lineTo(686f, 440f)
            lineTo(651f, 404f)
            quadTo(640f, 393f, 640f, 376.5f)
            quadTo(640f, 360f, 652f, 348f)
            quadTo(663f, 337f, 680f, 337f)
            quadTo(697f, 337f, 708f, 348f)
            lineTo(812f, 452f)
            quadTo(824f, 464f, 824f, 480f)
            quadTo(824f, 496f, 812f, 508f)
            lineTo(708f, 612f)
            quadTo(697f, 623f, 680.5f, 623.5f)
            quadTo(664f, 624f, 652f, 612f)
            quadTo(641f, 601f, 640.5f, 584.5f)
            quadTo(640f, 568f, 651f, 556f)
            lineTo(686f, 520f)
            close()
            moveTo(280f, 920f)
            quadTo(247f, 920f, 223.5f, 896.5f)
            quadTo(200f, 873f, 200f, 840f)
            lineTo(200f, 120f)
            quadTo(200f, 87f, 223.5f, 63.5f)
            quadTo(247f, 40f, 280f, 40f)
            lineTo(680f, 40f)
            quadTo(713f, 40f, 736.5f, 63.5f)
            quadTo(760f, 87f, 760f, 120f)
            lineTo(760f, 240f)
            quadTo(760f, 257f, 748.5f, 268.5f)
            quadTo(737f, 280f, 720f, 280f)
            quadTo(703f, 280f, 691.5f, 268.5f)
            quadTo(680f, 257f, 680f, 240f)
            lineTo(680f, 240f)
            lineTo(280f, 240f)
            lineTo(280f, 720f)
            lineTo(680f, 720f)
            lineTo(680f, 720f)
            quadTo(680f, 703f, 691.5f, 691.5f)
            quadTo(703f, 680f, 720f, 680f)
            quadTo(737f, 680f, 748.5f, 691.5f)
            quadTo(760f, 703f, 760f, 720f)
            lineTo(760f, 840f)
            quadTo(760f, 873f, 736.5f, 896.5f)
            quadTo(713f, 920f, 680f, 920f)
            lineTo(280f, 920f)
            close()
        }
    }.build()
}

val Icons.Rounded.AppShortcut: ImageVector by lazy {
    ImageVector.Builder(
        name = "AppShortcut",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(686f, 520f)
            lineTo(480f, 520f)
            quadTo(480f, 520f, 480f, 520f)
            quadTo(480f, 520f, 480f, 520f)
            lineTo(480f, 600f)
            quadTo(480f, 617f, 468.5f, 628.5f)
            quadTo(457f, 640f, 440f, 640f)
            quadTo(423f, 640f, 411.5f, 628.5f)
            quadTo(400f, 617f, 400f, 600f)
            lineTo(400f, 520f)
            quadTo(400f, 487f, 423.5f, 463.5f)
            quadTo(447f, 440f, 480f, 440f)
            lineTo(686f, 440f)
            lineTo(651f, 404f)
            quadTo(640f, 393f, 640f, 376.5f)
            quadTo(640f, 360f, 652f, 348f)
            quadTo(663f, 337f, 680f, 337f)
            quadTo(697f, 337f, 708f, 348f)
            lineTo(812f, 452f)
            quadTo(824f, 464f, 824f, 480f)
            quadTo(824f, 496f, 812f, 508f)
            lineTo(708f, 612f)
            quadTo(697f, 623f, 680.5f, 623.5f)
            quadTo(664f, 624f, 652f, 612f)
            quadTo(641f, 601f, 640.5f, 584.5f)
            quadTo(640f, 568f, 651f, 556f)
            lineTo(686f, 520f)
            close()
            moveTo(280f, 920f)
            quadTo(247f, 920f, 223.5f, 896.5f)
            quadTo(200f, 873f, 200f, 840f)
            lineTo(200f, 120f)
            quadTo(200f, 87f, 223.5f, 63.5f)
            quadTo(247f, 40f, 280f, 40f)
            lineTo(680f, 40f)
            quadTo(713f, 40f, 736.5f, 63.5f)
            quadTo(760f, 87f, 760f, 120f)
            lineTo(760f, 240f)
            quadTo(760f, 257f, 748.5f, 268.5f)
            quadTo(737f, 280f, 720f, 280f)
            quadTo(703f, 280f, 691.5f, 268.5f)
            quadTo(680f, 257f, 680f, 240f)
            lineTo(680f, 240f)
            lineTo(280f, 240f)
            lineTo(280f, 720f)
            lineTo(680f, 720f)
            lineTo(680f, 720f)
            quadTo(680f, 703f, 691.5f, 691.5f)
            quadTo(703f, 680f, 720f, 680f)
            quadTo(737f, 680f, 748.5f, 691.5f)
            quadTo(760f, 703f, 760f, 720f)
            lineTo(760f, 840f)
            quadTo(760f, 873f, 736.5f, 896.5f)
            quadTo(713f, 920f, 680f, 920f)
            lineTo(280f, 920f)
            close()
        }
    }.build()
}