/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2025 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Outlined.AddPhotoAlt: ImageVector by lazy {
    ImageVector.Builder(
        name = "Outlined.AddPhotoAlt",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            lineTo(480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            lineTo(480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            lineTo(480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            lineTo(480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            close()
            moveTo(200f, 840f)
            quadTo(167f, 840f, 143.5f, 816.5f)
            quadTo(120f, 793f, 120f, 760f)
            lineTo(120f, 200f)
            quadTo(120f, 167f, 143.5f, 143.5f)
            quadTo(167f, 120f, 200f, 120f)
            lineTo(520f, 120f)
            quadTo(520f, 137f, 520f, 157f)
            quadTo(520f, 177f, 520f, 200f)
            lineTo(200f, 200f)
            quadTo(200f, 200f, 200f, 200f)
            quadTo(200f, 200f, 200f, 200f)
            lineTo(200f, 760f)
            quadTo(200f, 760f, 200f, 760f)
            quadTo(200f, 760f, 200f, 760f)
            lineTo(760f, 760f)
            quadTo(760f, 760f, 760f, 760f)
            quadTo(760f, 760f, 760f, 760f)
            lineTo(760f, 440f)
            quadTo(783f, 440f, 803f, 440f)
            quadTo(823f, 440f, 840f, 440f)
            lineTo(840f, 760f)
            quadTo(840f, 793f, 816.5f, 816.5f)
            quadTo(793f, 840f, 760f, 840f)
            lineTo(200f, 840f)
            close()
            moveTo(240f, 680f)
            lineTo(720f, 680f)
            lineTo(570f, 480f)
            lineTo(450f, 640f)
            lineTo(360f, 520f)
            lineTo(240f, 680f)
            close()
            moveTo(680f, 360f)
            lineTo(680f, 280f)
            lineTo(600f, 280f)
            lineTo(600f, 200f)
            lineTo(680f, 200f)
            lineTo(680f, 120f)
            lineTo(760f, 120f)
            lineTo(760f, 200f)
            lineTo(840f, 200f)
            lineTo(840f, 280f)
            lineTo(760f, 280f)
            lineTo(760f, 360f)
            lineTo(680f, 360f)
            close()
        }
    }.build()
}

val Icons.Rounded.AddPhotoAlt: ImageVector by lazy {
    ImageVector.Builder(
        name = "Rounded.AddPhotoAlt",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(200f, 840f)
            quadTo(167f, 840f, 143.5f, 816.5f)
            quadTo(120f, 793f, 120f, 760f)
            lineTo(120f, 200f)
            quadTo(120f, 167f, 143.5f, 143.5f)
            quadTo(167f, 120f, 200f, 120f)
            lineTo(560f, 120f)
            quadTo(540f, 146f, 530f, 177f)
            quadTo(520f, 208f, 520f, 240f)
            quadTo(520f, 323f, 578.5f, 381.5f)
            quadTo(637f, 440f, 720f, 440f)
            quadTo(752f, 440f, 783f, 430f)
            quadTo(814f, 420f, 840f, 400f)
            lineTo(840f, 760f)
            quadTo(840f, 793f, 816.5f, 816.5f)
            quadTo(793f, 840f, 760f, 840f)
            lineTo(200f, 840f)
            close()
            moveTo(240f, 680f)
            lineTo(720f, 680f)
            lineTo(570f, 480f)
            lineTo(450f, 640f)
            lineTo(360f, 520f)
            lineTo(240f, 680f)
            close()
            moveTo(680f, 360f)
            lineTo(680f, 280f)
            lineTo(600f, 280f)
            lineTo(600f, 200f)
            lineTo(680f, 200f)
            lineTo(680f, 120f)
            lineTo(760f, 120f)
            lineTo(760f, 200f)
            lineTo(840f, 200f)
            lineTo(840f, 280f)
            lineTo(760f, 280f)
            lineTo(760f, 360f)
            lineTo(680f, 360f)
            close()
        }
    }.build()
}

val Icons.TwoTone.AddPhotoAlt: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "TwoTone.AddPhotoAlt",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(12f, 12f)
            horizontalLineToRelative(0f)
            close()
            moveTo(5f, 21f)
            curveToRelative(-0.55f, 0f, -1.021f, -0.196f, -1.413f, -0.587f)
            curveToRelative(-0.392f, -0.392f, -0.587f, -0.863f, -0.587f, -1.413f)
            verticalLineTo(5f)
            curveToRelative(0f, -0.55f, 0.196f, -1.021f, 0.587f, -1.413f)
            curveToRelative(0.392f, -0.392f, 0.863f, -0.587f, 1.413f, -0.587f)
            horizontalLineToRelative(8f)
            verticalLineToRelative(2f)
            horizontalLineTo(5f)
            verticalLineToRelative(14f)
            horizontalLineToRelative(14f)
            verticalLineToRelative(-8f)
            horizontalLineToRelative(2f)
            verticalLineToRelative(8f)
            curveToRelative(0f, 0.55f, -0.196f, 1.021f, -0.587f, 1.413f)
            reflectiveCurveToRelative(-0.863f, 0.587f, -1.413f, 0.587f)
            horizontalLineTo(5f)
            close()
            moveTo(6f, 17f)
            horizontalLineToRelative(12f)
            lineToRelative(-3.75f, -5f)
            lineToRelative(-3f, 4f)
            lineToRelative(-2.25f, -3f)
            lineToRelative(-3f, 4f)
            close()
            moveTo(17f, 9f)
            verticalLineToRelative(-2f)
            horizontalLineToRelative(-2f)
            verticalLineToRelative(-2f)
            horizontalLineToRelative(2f)
            verticalLineToRelative(-2f)
            horizontalLineToRelative(2f)
            verticalLineToRelative(2f)
            horizontalLineToRelative(2f)
            verticalLineToRelative(2f)
            horizontalLineToRelative(-2f)
            verticalLineToRelative(2f)
            horizontalLineToRelative(-2f)
            close()
        }
        path(fill = SolidColor(Color.Black)) {
            moveTo(13.099f, 5.001f)
            curveToRelative(0.039f, -0.193f, 0.089f, -0.385f, 0.151f, -0.576f)
            curveToRelative(0.167f, -0.517f, 0.417f, -0.992f, 0.75f, -1.425f)
            horizontalLineToRelative(-1f)
            verticalLineToRelative(2f)
            lineToRelative(0.099f, 0.001f)
            close()
        }
        path(
            fill = SolidColor(Color.Black),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(19f, 10.9f)
            curveToRelative(-0.33f, 0.066f, -0.664f, 0.1f, -1f, 0.1f)
            curveToRelative(-1.383f, 0f, -2.563f, -0.487f, -3.538f, -1.463f)
            curveToRelative(-0.975f, -0.975f, -1.462f, -2.154f, -1.462f, -3.537f)
            curveToRelative(0f, -0.336f, 0.033f, -0.669f, 0.099f, -0.999f)
            lineToRelative(-0.099f, -0.001f)
            horizontalLineToRelative(-8f)
            verticalLineToRelative(14f)
            horizontalLineToRelative(14f)
            verticalLineToRelative(-8f)
            lineToRelative(0f, -0.1f)
            close()
        }
        path(fill = SolidColor(Color.Black)) {
            moveTo(19f, 11f)
            horizontalLineToRelative(2f)
            verticalLineToRelative(-1f)
            curveToRelative(-0.433f, 0.333f, -0.908f, 0.583f, -1.425f, 0.75f)
            curveToRelative(-0.19f, 0.061f, -0.382f, 0.111f, -0.575f, 0.15f)
            lineToRelative(-0f, 0.1f)
            close()
        }
        path(
            fill = SolidColor(Color.Black),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(6f, 17f)
            lineToRelative(3f, -4f)
            lineToRelative(2.25f, 3f)
            lineToRelative(3f, -4f)
            lineToRelative(3.75f, 5f)
            lineToRelative(-12f, 0f)
            close()
        }
    }.build()
}