<div align="center">
</br>
<img src="./fastlane/metadata/android/en-US/images/logo/logo.png" width="200" />

</div>

<div align="center">

# Image Toolbox

</div>

</br>

<p align="center">
  <img alt="API" src="https://img.shields.io/badge/Api%2023+-50f270?logo=android&logoColor=black&style=for-the-badge"/></a>
  <img alt="Kotlin" src="https://img.shields.io/badge/Kotlin-a503fc?logo=kotlin&logoColor=white&style=for-the-badge"/></a>
  <img alt="Jetpack Compose" src="https://img.shields.io/static/v1?style=for-the-badge&message=Jetpack+Compose&color=4285F4&logo=Jetpack+Compose&logoColor=FFFFFF&label="/></a> 
    <img alt="material" src="https://custom-icon-badges.demolab.com/badge/material%20you-lightblue?style=for-the-badge&logoColor=333&logo=material-you"/></a>
  </br>
  </br>
  
 <img src="https://img.shields.io/badge/228.5K-aeff4d?style=for-the-badge&logo=data%3Aimage%2Fsvg%2Bxml%3Bbase64%2CPHN2ZyB2aWV3Qm94PSIwIDAgMjQgMjQiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI%2BCiAgICA8cGF0aCBkPSJNMTIuODksM0wxNC44NSwzLjRMMTEuMTEsMjFMOS4xNSwyMC42TDEyLjg5LDNNMTkuNTksMTJMMTYsOC40MVY1LjU4TDIyLjQyLDEyTDE2LDE4LjQxVjE1LjU4TDE5LjU5LDEyTTEuNTgsMTJMOCw1LjU4VjguNDFMNC40MSwxMkw4LDE1LjU4VjE4LjQxTDEuNTgsMTJaIgogICAgICAgIGZpbGw9IndoaXRlIiAvPgo8L3N2Zz4%3D&label=Lines%20of%20code&labelColor=4b731a"/>

<img src="https://img.shields.io/github/commits-since/t8rin/ImageResizer/v1.0?color=palegreen&label=Commits&style=for-the-badge&logo=data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHRpdGxlPnNvdXJjZS1jb21taXQ8L3RpdGxlPjxwYXRoIGQ9Ik0xNywxMkMxNywxNC40MiAxNS4yOCwxNi40NCAxMywxNi45VjIxSDExVjE2LjlDOC43MiwxNi40NCA3LDE0LjQyIDcsMTJDNyw5LjU4IDguNzIsNy41NiAxMSw3LjFWM0gxM1Y3LjFDMTUuMjgsNy41NiAxNyw5LjU4IDE3LDEyTTEyLDlBMywzIDAgMCwwIDksMTJBMywzIDAgMCwwIDEyLDE1QTMsMyAwIDAsMCAxNSwxMkEzLDMgMCAwLDAgMTIsOVoiIGZpbGw9IndoaXRlIiAvPjwvc3ZnPg==&labelColor=07ab4e">
 
<img src="https://img.shields.io/github/languages/code-size/t8rin/imageresizer?style=for-the-badge&color=8ce2ff&logo=data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHRpdGxlPndlaWdodDwvdGl0bGU+PHBhdGggZD0iTTEyLDNBNCw0IDAgMCwxIDE2LDdDMTYsNy43MyAxNS44MSw4LjQxIDE1LjQ2LDlIMThDMTguOTUsOSAxOS43NSw5LjY3IDE5Ljk1LDEwLjU2QzIxLjk2LDE4LjU3IDIyLDE4Ljc4IDIyLDE5QTIsMiAwIDAsMSAyMCwyMUg0QTIsMiAwIDAsMSAyLDE5QzIsMTguNzggMi4wNCwxOC41NyA0LjA1LDEwLjU2QzQuMjUsOS42NyA1LjA1LDkgNiw5SDguNTRDOC4xOSw4LjQxIDgsNy43MyA4LDdBNCw0IDAgMCwxIDEyLDNNMTIsNUEyLDIgMCAwLDAgMTAsN0EyLDIgMCAwLDAgMTIsOUEyLDIgMCAwLDAgMTQsN0EyLDIgMCAwLDAgMTIsNVoiIGZpbGw9IndoaXRlIiAvPjwvc3ZnPg==&labelColor=0782ab">
 
</br>
</br>

<a href="https://hits.sh/github.com/t8rin/ImageResizer/">

  <img src="https://hits.sh/github.com/t8rin/ImageResizer.svg?style=for-the-badge&label=Page%20Views&extraCount=7500&color=ff3f6f&logo=data%3Aimage%2Fsvg%2Bxml%3Bbase64%2CPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGNsYXNzPSJzdmctaWNvbiIgc3R5bGU9IndpZHRoOiAxZW07IGhlaWdodDogMWVtO3ZlcnRpY2FsLWFsaWduOiBtaWRkbGU7ZmlsbDojZmZmZmZmO292ZXJmbG93OiBoaWRkZW47IiB2aWV3Qm94PSIwIDAgMTAyNCAxMDI0IiB2ZXJzaW9uPSIxLjEiPjxwYXRoIGQ9Ik01MTIgMzg0YTEyOCAxMjggMCAwIDAtMTI4IDEyOCAxMjggMTI4IDAgMCAwIDEyOCAxMjggMTI4IDEyOCAwIDAgMCAxMjgtMTI4IDEyOCAxMjggMCAwIDAtMTI4LTEyOG0wIDM0MS4zMzMzMzNhMjEzLjMzMzMzMyAyMTMuMzMzMzMzIDAgMCAxLTIxMy4zMzMzMzMtMjEzLjMzMzMzMyAyMTMuMzMzMzMzIDIxMy4zMzMzMzMgMCAwIDEgMjEzLjMzMzMzMy0yMTMuMzMzMzMzIDIxMy4zMzMzMzMgMjEzLjMzMzMzMyAwIDAgMSAyMTMuMzMzMzMzIDIxMy4zMzMzMzMgMjEzLjMzMzMzMyAyMTMuMzMzMzMzIDAgMCAxLTIxMy4zMzMzMzMgMjEzLjMzMzMzM20wLTUzMy4zMzMzMzNDMjk4LjY2NjY2NyAxOTIgMTE2LjQ4IDMyNC42OTMzMzMgNDIuNjY2NjY3IDUxMmM3My44MTMzMzMgMTg3LjMwNjY2NyAyNTYgMzIwIDQ2OS4zMzMzMzMgMzIwczM5NS41Mi0xMzIuNjkzMzMzIDQ2OS4zMzMzMzMtMzIwYy03My44MTMzMzMtMTg3LjMwNjY2Ny0yNTYtMzIwLTQ2OS4zMzMzMzMtMzIweiIgZmlsbD0iIi8%2BPC9zdmc%2B&labelColor=870b2a"/>
  
</a>
  
<a href="https://github.com/t8rin/ImageResizer/releases">
  
  <img src="https://img.shields.io/github/downloads/t8rin/ImageResizer/total?color=ff9500&style=for-the-badge&logo=data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHRpdGxlPmRvd25sb2FkPC90aXRsZT48cGF0aCBkPSJNNSwyMEgxOVYxOEg1TTE5LDlIMTVWM0g5VjlINUwxMiwxNkwxOSw5WiIgZmlsbD0id2hpdGUiIC8+PC9zdmc+&labelColor=a6660d"/>
  
</a>
  
<a href="https://github.com/t8rin/ImageResizer/stargazers">
  
  <img src="https://img.shields.io/github/stars/t8rin/imageresizer?color=ffff00&style=for-the-badge&labelColor=a1a116&logo=data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHRpdGxlPnN0YXI8L3RpdGxlPjxwYXRoIGQ9Ik0xMiwxNy4yN0wxOC4xOCwyMUwxNi41NCwxMy45N0wyMiw5LjI0TDE0LjgxLDguNjJMMTIsMkw5LjE5LDguNjJMMiw5LjI0TDcuNDUsMTMuOTdMNS44MiwyMUwxMiwxNy4yN1oiIGZpbGw9IndoaXRlIiAvPjwvc3ZnPg=="/>
  
</a>
  
</br>

<a href="https://github.com/t8rin/imageresizer/releases/latest">

  <img src="https://img.shields.io/github/v/release/t8rin/imageresizer?color=a1168e&include_prereleases&logo=github&style=for-the-badge&labelColor=700f63"/>
  
</a>

<a href="https://play.google.com/store/apps/details?id=ru.tech.imageresizershrinker">

  <img src="https://img.shields.io/endpoint?color=a1168e&logo=google-play&style=for-the-badge&label=Play%20store&url=https%3A%2F%2Fplay.cuzi.workers.dev%2Fplay%3Fi%3Dru.tech.imageresizershrinker%26l%3DAndroid%26m%3D%24version&labelColor=700f63"/>
  
</a>

<a href="https://f-droid.org/packages/ru.tech.imageresizershrinker">

  <img src="https://img.shields.io/f-droid/v/ru.tech.imageresizershrinker?color=a1168e&include_prereleases&logo=FDROID&style=for-the-badge&labelColor=700f63"/>
  
</a>

</br>
</br>

<img src="https://wakatime.com/badge/user/7fa5ec35-3afd-4c14-984e-6ea7daf545c7.svg?style=social" style="height: 28px;"/>

</br>
</br>

  <a href="https://hellogithub.com/repository/4c5f2fae4eb545ab87cad9ffd19870ca" target="_blank">
    <img src="https://abroad.hellogithub.com/v1/widgets/recommend.svg?rid=4c5f2fae4eb545ab87cad9ffd19870ca&claim_uid=ubtZe5aXVz0n2QA&theme=dark" alt="Featured｜HelloGitHub" style="width: 250px; height: 54px;" width="250" height="54" />
  </a>
  

</p>

<div align="center">


# 🗺️ Project Overview

ImageToolbox is a versatile image editing tool designed for efficient photo manipulation. It allows
users to crop, apply filters, edit EXIF data, erase backgrounds, and even convert images to PDFs.
Ideal for both photographers and developers, the tool offers a simple interface with powerful
capabilities.

</div>

<p align="middle">
    <img src="./fastlane/metadata/android/en-US/images/banner/banner1.png" width="99%" />
    <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/01.png" width="13%" />
    <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/02.png" width="13%" />
    <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/03.png" width="13%" />
    <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/04.png" width="13%" />
    <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/05.png" width="13%" />
    <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/06.png" width="13%" />
    <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/07.png" width="13%" />
</p>

<div align="center">

# 📔 Wiki
Check out Image Toolbox [Wiki](https://github.com/T8RIN/ImageToolbox/wiki) for FAQ and useful info
</br>
</br>

# ✈️ Telegram Links

</br>

  [![ImageToolbox Chat](https://img.shields.io/endpoint?&style=for-the-badge&colorA=246732&colorB=A2FFB0&logo=telegram&logoColor=A2FFB0&label=ImageToolbox%20Chat&url=https://tg.sumanjay.workers.dev/t8rin_imagetoolbox)](https://t.me/t8rin_imagetoolbox)
[![CI Telegram](https://img.shields.io/endpoint?&style=for-the-badge&colorA=29626B&colorB=B5DFE8&logo=telegram&logoColor=B5DFE8&url=https://tg.sumanjay.workers.dev/t8rin_imagetoolbox_ci)](https://t.me/t8rin_imagetoolbox_ci)


  </br>
  </br>
  Join our chat where you can discuss anything you want and also look into the CI channel where I post betas and announcements
  </br>

# ☕ Buy me a coffee

This application is completely free, but if you want to support the project development, you can
send a donation to the crypto wallets below

| </br> ![Bitcoin](https://img.shields.io/badge/Bitcoin-EAB300?style=for-the-badge&logo=Bitcoin%20SV&logoColor=white) <br/> <br/> -> `18QFWMREkjzQa4yetfYsN5Ua51UubKmJut` <- <br/> <br/> | </br> ![Tether](https://img.shields.io/badge/USDT%20(TRC20)-168363?style=for-the-badge&logo=tether&logoColor=white) <br/> <br/> -> `TVdw6fP8dYsYA6HgQiSYNijBqPJ3k5BbYo` <- <br/> <br/> |
|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|

# 📲 Download

Go to the [Releases](https://github.com/t8rin/imageresizer/releases/latest) and the download latest
apk
or click one of the badges below.

</br>

<p align="middle">
    <a href="https://play.google.com/store/apps/details?id=ru.tech.imageresizershrinker"><img alt="Google Play" src="./fastlane/metadata/android/en-US/images/buttons/gplay.svg" height="60"></a>
    <a href="https://f-droid.org/packages/ru.tech.imageresizershrinker"><img alt="F-Droid" src="./fastlane/metadata/android/en-US/images/buttons/fdroid.svg" height="60"/></a>
    <a href="https://github.com/t8rin/imageresizer/releases/latest"><img alt="GitHub" src="./fastlane/metadata/android/en-US/images/buttons/github.svg" height="60"/></a>
    <a href="https://apps.obtainium.imranr.dev/redirect?r=obtainium://app/%7B%22id%22%3A%22ru.tech.imageresizershrinker%22%2C%22url%22%3A%22https%3A%2F%2Fgithub.com%2FT8RIN%2FImageToolbox%22%2C%22author%22%3A%22T8RIN%22%2C%22name%22%3A%22Image%20Toolbox%22%2C%22preferredApkIndex%22%3A1%2C%22additionalSettings%22%3A%22%7B%5C%22includePrereleases%5C%22%3Afalse%2C%5C%22fallbackToOlderReleases%5C%22%3Atrue%2C%5C%22filterReleaseTitlesByRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22filterReleaseNotesByRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22verifyLatestTag%5C%22%3Afalse%2C%5C%22dontSortReleasesList%5C%22%3Afalse%2C%5C%22useLatestAssetDateAsReleaseDate%5C%22%3Afalse%2C%5C%22trackOnly%5C%22%3Afalse%2C%5C%22versionExtractionRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22matchGroupToUse%5C%22%3A%5C%22%5C%22%2C%5C%22versionDetection%5C%22%3Atrue%2C%5C%22releaseDateAsVersion%5C%22%3Afalse%2C%5C%22useVersionCodeAsOSVersion%5C%22%3Afalse%2C%5C%22apkFilterRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22invertAPKFilter%5C%22%3Afalse%2C%5C%22autoApkFilterByArch%5C%22%3Atrue%2C%5C%22appName%5C%22%3A%5C%22Image%20Toolbox%5C%22%2C%5C%22shizukuPretendToBeGooglePlay%5C%22%3Afalse%2C%5C%22exemptFromBackgroundUpdates%5C%22%3Afalse%2C%5C%22skipUpdateNotifications%5C%22%3Afalse%2C%5C%22about%5C%22%3A%5C%22Image%20Toolbox%20is%20an%20powerful%20picture%20editor%2C%20which%20can%20crop%2C%20apply%20filters%2C%20add%20some%20drawing%2C%20erase%20background%2C%20edit%20EXIF%20or%20even%20create%20PDF%20file.%5C%22%2C%5C%22appAuthor%5C%22%3A%5C%22T8RIN%5C%22%7D%22%7D"><img alt="Obtainium" src="./fastlane/metadata/android/en-US/images/buttons/obtainium.svg" height="60"/></a>
    <a href="https://apps.obtainium.imranr.dev/redirect?r=obtainium://app/%7B%22id%22%3A%22ru.tech.imageresizershrinker%22%2C%22url%22%3A%22https%3A%2F%2Fgithub.com%2FT8RIN%2FImageToolbox%22%2C%22author%22%3A%22T8RIN%22%2C%22name%22%3A%22Image%20Toolbox%22%2C%22preferredApkIndex%22%3A1%2C%22additionalSettings%22%3A%22%7B%5C%22includePrereleases%5C%22%3Atrue%2C%5C%22fallbackToOlderReleases%5C%22%3Atrue%2C%5C%22filterReleaseTitlesByRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22filterReleaseNotesByRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22verifyLatestTag%5C%22%3Afalse%2C%5C%22dontSortReleasesList%5C%22%3Afalse%2C%5C%22useLatestAssetDateAsReleaseDate%5C%22%3Afalse%2C%5C%22trackOnly%5C%22%3Afalse%2C%5C%22versionExtractionRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22matchGroupToUse%5C%22%3A%5C%22%5C%22%2C%5C%22versionDetection%5C%22%3Atrue%2C%5C%22releaseDateAsVersion%5C%22%3Afalse%2C%5C%22useVersionCodeAsOSVersion%5C%22%3Afalse%2C%5C%22apkFilterRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22invertAPKFilter%5C%22%3Afalse%2C%5C%22autoApkFilterByArch%5C%22%3Atrue%2C%5C%22appName%5C%22%3A%5C%22Image%20Toolbox%5C%22%2C%5C%22shizukuPretendToBeGooglePlay%5C%22%3Afalse%2C%5C%22exemptFromBackgroundUpdates%5C%22%3Afalse%2C%5C%22skipUpdateNotifications%5C%22%3Afalse%2C%5C%22about%5C%22%3A%5C%22Image%20Toolbox%20is%20an%20powerful%20picture%20editor%2C%20which%20can%20crop%2C%20apply%20filters%2C%20add%20some%20drawing%2C%20erase%20background%2C%20edit%20EXIF%20or%20even%20create%20PDF%20file.%5C%22%2C%5C%22appAuthor%5C%22%3A%5C%22T8RIN%5C%22%7D%22%7D"><img alt="Obtainium (Pre-release)" src="./fastlane/metadata/android/en-US/images/buttons/obtainium-pre-release.svg" height="60"/></a>

</p>
</div>

# 💻 Installation Instructions

1. Clone the repository:
   ```bash
   git clone https://github.com/yourusername/ImageToolbox.git
   ```
2. Install dependencies using your preferred package manager (e.g., Gradle).
3. Build the project:
   bash ./gradlew build
4. Run the application:
   bash ./gradlew run

# ⚔️ FOSS vs MARKET

|    **Feature**     |      **FOSS**      |     **Market**     |
|:------------------:|:------------------:|:------------------:|
|     QR Scanner     |       Zxing        |       MlKit        |
|   Auto erase BG    |       U2Net        |       MlKit        |
|  Document Scanner  |       OpenCV       |       MlKit        |
|     Analytics      |        :x:         | :white_check_mark: |
|    Crashlytics     |        :x:         | :white_check_mark: |
| Other Google deps  |        :x:         | :white_check_mark: |
| All Other Features | :white_check_mark: | :white_check_mark: |

# ✨ Features

- Batch processing
- Applying filter chains (More than 310 various filters)

  <details>
  <summary>Available filters</summary>
  <br>

    - [x] Saturation
    - [x] Contrast
    - [x] Brightness
    - [x] Exposure
    - [x] RGB
    - [x] Hue
    - [x] White Balance
    - [x] Monochrome
    - [x] Black and White
    - [x] False Color
    - [x] Sharpen
    - [x] Gamma
    - [x] Highlights and Shadows
    - [x] Haze
    - [x] Sepia Tone
    - [x] Color Inversion
    - [x] Solarize
    - [x] Vibrance
    - [x] Luminance Threshold
    - [x] Pixellate
    - [x] Halftone
    - [x] Crosshatch
    - [x] Sobel Edge Detection
    - [x] Sketch Filter
    - [x] Toon Filter
    - [x] SmoothToon Filter
    - [x] CGA Colorspace Filter
    - [x] Posterize
    - [x] Convolution 3x3
    - [x] Emboss Filter
    - [x] Laplacian
    - [x] Kuwahara Filter
    - [x] Vignette
    - [x] Gaussian Blur
    - [x] Box Blur
    - [x] Stack Blur
    - [x] Fast Blur
    - [x] Bilaterial Blur
    - [x] Zoom Blur
    - [x] Median Blur
    - [x] Pixelation
    - [x] Enhanced Pixelation
    - [x] Stroke Pixelation
    - [x] Circle Pixelation
    - [x] Enhanced Circle Pixelation
    - [x] Diamond Pixelation
    - [x] Enhanced Diamond Pixelation
    - [x] Swirl Distortion
    - [x] Bulge Distortion
    - [x] Sphere Refraction
    - [x] Glass Sphere Refraction
    - [x] Dilation
    - [x] Non Maximum Suppression
    - [x] Opacity
    - [x] Weak Pixel Inclusion Filter
    - [x] Color Matrix 4x4
    - [x] Lookup
    - [x] Color Replacement
    - [x] Color Removance
    - [x] Bayer Two Dithering
    - [x] Bayer Three Dithering
    - [x] Bayer Four Dithering
    - [x] Bayer Eight Dithering
    - [x] Floyd Steinberg Dithering
    - [x] Jarvis Judice Ninke Dithering
    - [x] Sierra Dithering
    - [x] Two Row Sierra Dithering
    - [x] Sierra Lite Dithering
    - [x] Atkinson Dithering
    - [x] Stucki Dithering
    - [x] Burkes Dithering
    - [x] False Floyd Steinberg Dithering
    - [x] Left To Right Dithering
    - [x] Random Dithering
    - [x] Simple Threshold Dithering
    - [x] Quantizier
    - [x] Glitch Effect
    - [x] Enhanced Glitch Effect
    - [x] Anaglyph
    - [x] Noise
    - [x] Tent Blur
    - [x] Side Fade
    - [x] Erode
    - [x] Anisotropic Diffusion
    - [x] Horizontal Wind Stagger
    - [x] Fast Bilaterial Blur
    - [x] Poisson Blur
    - [x] Logarithmic Tone Mapping
    - [x] Aces Filmic Tone Mapping
    - [x] Crystallize
    - [x] Fractal Glass
    - [x] Marble
    - [x] Oil
    - [x] Water Effect
    - [x] Hable Filmic Tone Mapping
    - [x] Aces Hill Tone Mapping
    - [x] Hejl Burgess Tone Mapping
    - [x] Perlin Distortion
    - [x] Grayscale
    - [x] Dehaze
    - [x] Color Matrix 3x3
    - [x] Achromatomaly
    - [x] Achromatopsia
    - [x] Browni
    - [x] CodaChrome
    - [x] Cool
    - [x] Deutaromaly
    - [x] Deutaronotopia
    - [x] Night Vision
    - [x] Polaroid
    - [x] Protanopia
    - [x] Protonomaly
    - [x] Tritanopia
    - [x] Tritonomaly
    - [x] Vintage
    - [x] Warm
    - [x] Grain
    - [x] Unsharp
    - [x] Pastel
    - [x] Orange Haze
    - [x] Pink Dream
    - [x] Golden Hour
    - [x] Hot Summer
    - [x] Purple Mist
    - [x] Sunrise
    - [x] Colorful Swirl
    - [x] Soft Spring Light
    - [x] Autumn Tones
    - [x] Lavender Dream
    - [x] Cyberpunk
    - [x] Lemonade Light
    - [x] Spectral Fire
    - [x] Night Magic
    - [x] Fantasy Landscape
    - [x] Color Explosion
    - [x] Electric Gradient
    - [x] Caramel Darkness
    - [x] Futuristic Gradient
    - [x] Green Sun
    - [x] Rainbow World
    - [x] Deep Purple
    - [x] Space Portal
    - [x] Red Swirl
    - [x] Digital Code
    - [x] Bokeh
    - [x] Neon
    - [x] Old Tv
    - [x] Shuffle Blur
    - [x] Mobius
    - [x] Uchimura
    - [x] Aldridge
    - [x] Drago
    - [x] Color Anomaly
    - [x] Quantizier
    - [x] Ring Blur
    - [x] Cross Blur
    - [x] Circle Blur
    - [x] Star Blur
    - [x] Motion Blur
    - [x] Fast Gaussian Blur 2D
    - [x] Fast Gaussian Blur 3D
    - [x] Fast Gaussian Blur 4D
    - [x] Equalize Histogram
    - [x] Equalize Histogram HSV
    - [x] Equalize Histogram Pixelation
    - [x] Equalize Histogram Adaptive
    - [x] Equalize Histogram Adaptive LUV
    - [x] Equalize Histogram Adaptive LAB
    - [x] Equalize Histogram Adaptive HSV
    - [x] Equalize Histogram Adaptive HSL
    - [x] Clahe
    - [x] Clahe LUV
    - [x] Clahe LAB
    - [x] Clahe HSL
    - [x] Clahe HSV
    - [x] Crop To Content
    - [x] Linear Box Blur
    - [x] Linear Tent Blur
    - [x] Linear Gaussian Box Blur
    - [x] Linear Stack Blur
    - [x] Gaussian Box Blur
    - [x] Linear Fast Gaussian Next
    - [x] LinearFast Gaussian
    - [x] Linear Gaussian
    - [x] Low Poly
    - [x] Sand Painting
    - [x] Palette Transfer
    - [x] Enhanced Oil
    - [x] Simple Old TV
    - [x] HDR
    - [x] Simple Sketch
    - [x] Gotham
    - [x] Color Poster
    - [x] Tri Tone
    - [x] Clahe Oklch
    - [x] Clahe Jzazbz
    - [x] Clahe Oklab
    - [x] Yililoma Dithering
    - [x] Clustered 2x2 Dithering
    - [x] Clustered 4x4 Dithering
    - [x] Clustered8x8 Dithering
    - [x] Polka Dot
    - [x] LUT 512\*512
    - [x] Amatorka
    - [x] Miss Etikate
    - [x] Soft Elegance
    - [x] Soft Elegance Variant
    - [x] Bleach Bypass
    - [x] Candlelight
    - [x] Drop Blues
    - [x] Edgy Amber
    - [x] Fall Colors
    - [x] Film Stock 50
    - [x] Foggy Night
    - [x] Kodak
    - [x] Palette Transfer Variant
    - [x] 3D LUT (.cube / .CUBE)
    - [x] Pop Art
    - [x] Celluloid
    - [x] Coffee
    - [x] Golden Forest
    - [x] Greenish
    - [x] Retro Yellow
    - [x] Auto Crop
    - [x] Opening
    - [x] Closing
    - [x] Morphological Gradient
    - [x] Top Hat
    - [x] Black Hat
    - [x] Enhanced Zoom Blur
    - [x] Simple Sobel
    - [x] Simple Laplacian
    - [x] Auto Red Eyes remover
    - [x] Tone Curves 
    - [x] Mirror
    - [x] Kaleidoscope  
    - [x] Channel Mix  
    - [x] Color Halftone  
    - [x] Contour  
    - [x] Voronoi Crystallize  
    - [x] Despeckle  
    - [x] Diffuse  
    - [x] DoG  
    - [x] Equalize  
    - [x] Glow  
    - [x] Offset  
    - [x] Pinch  
    - [x] Pointillize  
    - [x] Polar Coordinates  
    - [x] Reduce Noise  
    - [x] Simple Solarize  
    - [x] Weave  
    - [x] Twirl  
    - [x] Rubber Stamp  
    - [x] Smear  
    - [x] Sphere Lens Distortion  
    - [x] Arc  
    - [x] Sparkle
    - [x] ASCII
    - [x] Moire
    - [x] Autumn
    - [x] Bone
    - [x] Jet
    - [x] Winter
    - [x] Rainbow
    - [x] Ocean
    - [x] Summer
    - [x] Spring
    - [x] Cool Variant 
    - [x] Hsv
    - [x] Pink
    - [x] Hot
    - [x] Parula
    - [x] Magma
    - [x] Inferno
    - [x] Plasma
    - [x] Viridis
    - [x] Cividis
    - [x] Twilight
    - [x] Twilight Shifted
    - [x] Deskew
    - [x] Auto Perspective
    - [x] Crop Or Perspective
    - [x] Turbo
    - [x] Deep Green 
    - [x] Lens Correction
    - [x] Seam Carving
    - [x] Error Level Analysis
    - [x] Luminance Gradient
    - [x] Average Distance
    - [x] Copy Move Detection
    - [x] Simple Weave Pixelization
    - [x] Staggered Pixelization
    - [x] Cross Pixelization
    - [x] Micro Macro Pixelization
    - [x] Orbital Pixelization
    - [x] Vortex Pixelization
    - [x] Pulse Grid Pixelization
    - [x] Nucleus Pixelization
    - [x] Radial Weave Pixelization
    - [x] Border Frame
    - [x] Glitch Variant
    - [x] VHS
    - [x] Block Glitch
    - [x] Crt Curvature
    - [x] Pixel Melt


  </details>

- Custom Filters Creation by Template filters
    - You can create filter from any filter chain
    - Share created filters by QR code
    - Scan filters from the app to get them on your device
- Files encryption and decryption with 100+ different algorithms available
- Adding Stickers and Text (Markup Layers Mode)
- Extract Text From Images (OCR)
    - 120+ languages
    - 3 Type of data: Fast, Standard, Best
    - Segmentation Mode Selection
    - Engine Mode Selection
    - Custom Tesseract options entering
    - Multiple languages at the same time
    - Reading from batch of images to file
    - Placing in EXIF metadata of batch images
- EXIF metadata editing/deleting
- Loading images from internet
- Image Stitching
- Image Stacking
- Image Splitting
- Background Removal
    - By drawing
    - Automatically
- Watermarking
    - Repeating Text
    - Image
    - Stamp
    - Timestamp
    - Digital (Steganography)
- Drawing on Image/Background
    - Pen
    - Flood Fil
    - Spray
    - Neon
    - Highlighter
    - Privacy Blur
    - Pixelation Paint
    - Text
    - Image Brush
    - Filter Brush
    - Spot Healing (with ability to download AI model for generative inpainting)
    - Pointing Arrow
    - Line
    - Double Pointing Arrow
    - Line Pointing Arrow
    - Double Line Pointing Arrow
    - Outlined Rect
    - Outlined Oval
    - Outlined Triangle
    - Outlined Polygon
    - Outlined Star
    - Rect
    - Oval
    - Triangle
    - Polygon
    - Star
    - Lasso
    - Line Style
        - Dashed
        - Dot Dashed
        - Zigzag
        - Stamped
- Image Resizing
    - Width changing
    - Height changing
    - Adaptive resize
    - Resize retaining aspect ratio
    - Resize by given limits
    - Center Crop with
        - Background color changing
        - Background blur drawing
    - Different Scaling Algorithms

      <details>
      <summary>Available methods</summary>
      <br>

      - Bilinear
      - Nearest Neighbour
      - Cubic
      - Mitchell-Netravalli
      - Catmull-Rom
      - Hermite
      - B-Spline
      - Hann
      - Bicubic
      - Hamming
      - Hanning
      - Blackman
      - Welch
      - Quadric
      - Gaussian
      - Sphinx
      - Bartlett
      - Robidoux
      - Robidoux Sharp
      - Spline 16
      - Spline 36
      - Spline 64
      - Kaiser
      - Bartlett-Hann
      - Box
      - Bohman
      - Lanczos 2
      - Lanczos 3
      - Lanczos 4
      - Lanczos 2 Jinc
      - Lanczos 3 Jinc
      - Lanczos 4 Jinc
      - Ewa Hanning
      - Ewa Robidoux
      - Ewa Blackman
      - Ewa Quadric
      - Ewa Robidoux Sharp
      - Ewa Lanczos 3 Jinc
      - Ginseng
      - Ginseng EWA
      - Lanczos Sharp EWA
      - Lanczos 4 Sharpest EWA
      - Lanczos Soft EWA
      - Haasn Soft
      - Lagrange 2
      - Lagrange 3
      - Lanczos 6
      - Lanczos 6 Jinc

      </details>

    - Different Scale Color Spaces
        - Linear
        - sRGB
        - LAB
        - LUV
        - Sigmoidal
        - XYZ
        - F32 Gamma 2.2
        - F32 Gamma 2.8
        - F32 Rec.709
        - F32 sRGB
        - LCH
        - Oklab sRGB
        - Oklab Rec.709
        - Oklab Gamma 2.2
        - Oklab Gamma 2.8
        - Jzazbz sRGB
        - Jzazbz Rec.709
        - Jzazbz Gamma 2.2
        - Jzazbz Gamma 2.8
- GIF conversion
    - GIF to images
    - Images to GIF
    - GIF to WEBP
- WEBP conversion
    - WEBP to images
    - Images to WEBP
- APNG conversion
    - APNG to images
    - Images to APNG
- JXL transcoding
    - JXL to JPEG
    - JPEG to JXL
- Animated JXL conversion
    - Images to JXL
    - JXL to Images
    - APNG to JXL
    - GIF to JXL
- PDF tools
    - PDF to images
    - Images to PDF
    - PDF previewing
- Document Scanning
- Barcodes
    - Scanning
    - Creating & Parsing common types
      - Plain
      - Url
      - WiFi
      - Email
      - Geolocation
      - Phone
      - SMS
      - Contact (vCard)
      - Calendar event
    - Sharing as images
    - 13 formats available
      - QR CODE
      - AZTEC
      - CODABAR
      - CODE 39
      - CODE 93
      - CODE 128
      - DATA MATRIX
      - EAN 8
      - EAN 13
      - ITF
      - PDF 417
      - UPC A
      - UPC E
- Collage Creation
    - From 2 to 10 images
    - More than 180 various collage layouts
- Image Shrinking
    - Quality compressing
    - Preset shrinking
    - Reducing size by given weight (in KB)
- Cropping
    - Regular crop
    - Free rotation crop
    - Free corners crop (can be used as Perspective Correction)
    - Crop by aspect ratio
    - Crop with shape mask
        
        <details>
          <summary>List of shapes</summary>
          <br/>
          
        - Rounded Corners
        - Cut Corners
        - Oval
        - Squircle
        - Octagon
        - Rounded Pentagon
        - Clover
        - Material Star
        - Kotlin Logo
        - Small Material Star
        - Heart
        - Shuriken
        - Explosion
        - Bookmark
        - Pill
        - Burger
        - Shield
        - Droplet
        - Arrow
        - Egg
        - Map
        - Enhanced Heart
        - Star
        - Image Mask
        - <details>
          <summary>Additional Shapes</summary>
          </br>
        
          ![image](./fastlane/metadata/android/en-US/images/banner/banner_shapes.png)

          </details>
        
        </details>


- Image Cutting (can be used as batch crop)         
- Tracing raster images to SVG
- Format Conversion
    - HEIF
    - HEIC
    - AVIF
    - WEBP
    - JPEG
    - JPG
    - PNG Lossless
    - PNG Lossy
    - MozJpeg
    - Jpegli
    - JXL
    - JP2
    - J2K
    - TIFF
    - TIF
    - QOI
    - ICO
    - SVG, DNG, PSD, GIF to static raster images
    - Telegram sticker PNG format
- Files to Zip
- Comparing images
    - Slide
    - Toggle Tap
    - Transparency
    - Side By Side
    - Pixel By Pixel (7 Methods)
        - SSIM
        - AE
        - MAE
        - NCC
        - PSNR
        - RMSE
- Color Utils
    - Palette generation
        - Material You Scheme
        - Simple Colors
    - Import/Export palette across 41 format
      - ACB
      - ACO
      - ACT  
      - Android Xml  
      - ASE
      - Basic Xml  
      - Corel Painter  
      - Corel Draw  
      - Scribus Xml  
      - Corel Palette  
      - CSV
      - DCP
      - Gimp
      - Hex Rgba  
      - Image  
      - Json  
      - Open Office  
      - Paint Net  
      - Paint Shop Pro  
      - Rgba  
      - Rgb  
      - Riff  
      - Sketch  
      - SKP
      - SVG  
      - Swift  
      - Kotlin  
      - Corel Draw V3  
      - CLF
      - Swatches  
      - Autodesk Color Book  
      - Simple Palette  
      - Swatchbooker  
      - Afpalette  
      - Xara  
      - Koffice
      - KPL
      - HPL
      - Skencil  
      - Vga 24Bit  
      - Vga 18Bit  
    - Picking color from image
    - Gradient creation (Mesh gradients too)
    - Overlaying image with gradient
    - Mixing
    - Conversion
    - Harmonies
    - Shading
    - Tone Curves applying
- Histograms
    - RGB
    - Brightness
    - Camera Like RGB
- Image source selection
- Additional Features
    - Base64 Decode/Encode
    - Rotating
    - Flipping
    - Perlin Noise Generation
    - Previewing SVG, DNG, PSD, DJVU and almost all types of images
    - Saving to any specific folder
    - Long press on save to choose one time output folder
    - Randomizing output filename
    - Using image cheksum as filename
    - Checksum Tools with ability to calculate and compare hashes
    - 64 different hashing algorithms
    - Audio files Album Cover export
    - Embedded media picker
    - Wallpapers Export
    - Ascii Art

**And More!**

#

<img src="./fastlane/metadata/android/en-US/images/banner/banner2.png" width="99%" />

# 🌟 UI tweaks

- Selecting Emoji for top app bar
- Ability to use Pixel like switch instead of Material You
- Secure Mode for app
- Maximum brightness for selected screens
- In app language changing
- Enabling or Disabling confetti
- Custom app color scheme
    - Different palette styles
    - Predefined schemes
    - Color inversion
    - Contrast adjusting
- Controlling borders thickness
- Enabling and disabling each existing shadow
- Haptics controls
- Light/Dark mode
- AMOLED mode
- Monet implementation (Dynamic colors) even for Android versions less than 12
  by [Dynamic Theme](https://github.com/T8RIN/DynamicTheme)
- Image based color scheme
- Icons Background shape selection
    - Rounded Corners
    - Cut Corners
    - Oval
    - Squircle
    - Octagon
    - Rounded Pentagon
    - Clover
    - Material Star
    - Small Material Star
    - Heart
    - Enhanced Heart
- Custom fonts

  <details>
  <summary>Preinstalled fonts</summary>
  <br>

    - Montserrat
    - Comfortaa
    - Caveat
    - Handjet
    - Jura
    - Podkova
    - Tektur
    - YsabeauSC
    - DejaVu
    - BadScript
    - RuslanDisplay
    - Catterdale
    - FRM32
    - Tokeely Brookings
    - Nunito
    - Nothing
    - WOPR Tweaked
    - Alegreya Sans
    - Minecraft Gnu
    - Granite Fixed
    - Nokia Pixel
    - Ztivalia
    - Axotrel
    - Lcd Octagon
    - Lcd Moving
    - Unisource

  </details>

- Ability to import any font (OTF/TTF) to further use
- In app font scale changing
- Changing between options list and grouped view
- Confetti Type selection
    - Default
    - Festive
    - Explode
    - Rain
    - Side
    - Corners
    - ImageToolbox
- Switch Type selection:
    - Material You
    - Compose
    - Pixel
    - Fluent
    - Cupertino
    - Liquid Glas
    - HyperOS
- Slider Type Selection:
    - Fancy
    - Material You
    - Material
    - HyperOS
- Main screen layout customization

(Yes, the app supports dynamic coloring based on wallpapers for every android version)

# 📚 Tech stack & Open-source libraries

- Minimum SDK level 23

- [Kotlin](https://kotlinlang.org/) based

- [Image Toolbox Libs](https://github.com/T8RIN/ImageToolboxLibs) - set of essential libraries for
  Image Toolbox.

- [Dynamic Theme](https://github.com/T8RIN/DynamicTheme) - library, which allows you to easily
  implement custom color theming.

- [Modal Sheet](https://github.com/T8RIN/ModalSheet) - modal bottom sheet that follows M3
  guidelines.

- [Coroutines](https://github.com/Kotlin/kotlinx.coroutines) for asynchronous work.

- [Flow](https://kotlin.github.io/kotlinx.coroutines/kotlinx-coroutines-core/kotlinx.coroutines.flow/)
  to emit values from data layer reactively.

- [Accompanist](https://github.com/google/accompanist) to expand jetpack compose opportunities.

- [Decompose](https://github.com/arkivanov/Decompose) - KMP lifecycle-aware business logic
  components (aka BLoCs) with routing (navigation) and pluggable UI

- [Hilt](https://dagger.dev/hilt/) for dependency injection.

- [Coil](https://github.com/coil-kt/coil) for loading images.

- [Konfetti](https://github.com/DanielMartinus/Konfetti) to establish beautiful particle system.

- Jetpack

    - [Compose](https://developer.android.com/jetpack/compose) - Modern Declarative UI style
      framework based on composable functions.

    - [Material You Kit](https://developer.android.com/jetpack/androidx/releases/compose-material3) -
      Material 3 powerful UI components.

    - [Data Store](https://developer.android.com/jetpack/androidx/releases/datastore) - Store data
      asynchronously, consistently, and transactionally.

    - [Lifecycle](https://developer.android.com/jetpack/androidx/releases/lifecycle) - Observe
      Android lifecycles and handle UI states upon the lifecycle changes.

    - [Exif Interface](https://developer.android.com/jetpack/androidx/releases/exifinterface) - Read
      and write image file EXIF tags.

- [GPU Image](https://github.com/cats-oss/android-gpuimage) for creating and applying filters to the
  images.

- [SmartToolFactory](https://github.com/SmartToolFactory) provides a bunch of helpful libraries.

- [AVIF Coder](https://github.com/awxkee/avif-coder)
  and [JXL Coder](https://github.com/awxkee/jxl-coder) libraries which provide avif, heic, heif and
  jxl support.

- [Aire](https://github.com/awxkee/aire) and [Trickle](https://github.com/T8RIN/Trickle) for
  creating and applying filters to the images on CPU
  using native cpp code.


# 📐 App Architecture

See Modules Graph at [ARCHITECTURE.md](https://github.com/T8RIN/ImageToolbox/blob/master/ARCHITECTURE.md)

<div align="center">

#

<img src="./fastlane/metadata/android/en-US/images/banner/banner3.png" width="99%" />

# 🌐 Translation

You can help translate Image Toolbox into your language
on [Hosted Weblate](https://hosted.weblate.org/engage/image-resizer/)

[![Состояние перевода](https://hosted.weblate.org/widgets/image-resizer/-/horizontal-auto.svg)](https://hosted.weblate.org/engage/image-resizer/)
</br>
[![Translation status](https://hosted.weblate.org/widgets/image-resizer/-/image-resizer/287x66-black.png)](https://hosted.weblate.org/engage/image-resizer/)

# ❤️ Find this repository useful?

Support it by joining **[stargazers](https://github.com/t8rin/ImageToolbox/stargazers)** for this
repository. :star: <br>
And **[follow](https://github.com/t8rin)** me for my next creations! 🤩

# ⭐ Star History

<a href="https://star-history.com/#T8RIN/ImageToolbox&Date">
 <picture>
   <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=T8RIN/ImageToolbox&type=Date&theme=dark" />
   <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=T8RIN/ImageToolbox&type=Date" />
   <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=T8RIN/ImageToolbox&type=Date" />
 </picture>
</a>

![](https://repobeats.axiom.co/api/embed/c62092c6ec0d00e67496223d50e39f48a582c532.svg)

# 📢 Contributors

<a href="https://github.com/t8rin/imageresizer/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=t8rin/Imageresizer" />
</a>

# 🔒 Signing Certificate Hashes

SHA-256: `20d7689de0874f00015ea3e31fa067c15c03457d362d41d5e793db3a864fa534`

SHA-1: `d69eacb30eeae804e8b72d2384c3c616b1906785`

MD5: `db6f6b76c503d31099e4754e676353cf`

For more info, see [wiki](https://github.com/T8RIN/ImageToolbox/wiki/FAQ#how-can-i-verify-my-download-of-imagetoolbox-is-legitimate)

# ⚖️ License

```xml
Designed and developed by 2023 T8RIN

    Licensed under the Apache License, Version 2.0 (the "License");you may not use this file except in compliance with the License.You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, softwaredistributed under the License is distributed on an "AS IS" BASIS,WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.See the License for the specific language governing permissions andlimitations under the License.
```
