package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Rounded.Tonality: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Rounded.Tonality",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(480f, 880f)
            quadTo(397f, 880f, 324f, 848.5f)
            quadTo(251f, 817f, 197f, 763f)
            quadTo(143f, 709f, 111.5f, 636f)
            quadTo(80f, 563f, 80f, 480f)
            quadTo(80f, 397f, 111.5f, 324f)
            quadTo(143f, 251f, 197f, 197f)
            quadTo(251f, 143f, 324f, 111.5f)
            quadTo(397f, 80f, 480f, 80f)
            quadTo(563f, 80f, 636f, 111.5f)
            quadTo(709f, 143f, 763f, 197f)
            quadTo(817f, 251f, 848.5f, 324f)
            quadTo(880f, 397f, 880f, 480f)
            quadTo(880f, 563f, 848.5f, 636f)
            quadTo(817f, 709f, 763f, 763f)
            quadTo(709f, 817f, 636f, 848.5f)
            quadTo(563f, 880f, 480f, 880f)
            close()
            moveTo(520f, 798f)
            quadTo(550f, 793f, 579f, 784.5f)
            quadTo(608f, 776f, 634f, 760f)
            lineTo(520f, 760f)
            lineTo(520f, 798f)
            close()
            moveTo(520f, 680f)
            lineTo(730f, 680f)
            quadTo(738f, 671f, 744f, 661f)
            quadTo(750f, 651f, 756f, 640f)
            lineTo(520f, 640f)
            lineTo(520f, 680f)
            close()
            moveTo(520f, 560f)
            lineTo(790f, 560f)
            quadTo(792f, 550f, 794f, 540f)
            quadTo(796f, 530f, 798f, 520f)
            lineTo(520f, 520f)
            lineTo(520f, 560f)
            close()
            moveTo(520f, 440f)
            lineTo(798f, 440f)
            quadTo(796f, 430f, 794f, 420f)
            quadTo(792f, 410f, 790f, 400f)
            lineTo(520f, 400f)
            lineTo(520f, 440f)
            close()
            moveTo(520f, 320f)
            lineTo(756f, 320f)
            quadTo(750f, 309f, 744f, 299f)
            quadTo(738f, 289f, 730f, 280f)
            lineTo(520f, 280f)
            lineTo(520f, 320f)
            close()
            moveTo(520f, 200f)
            lineTo(634f, 200f)
            quadTo(608f, 184f, 579f, 175.5f)
            quadTo(550f, 167f, 520f, 162f)
            lineTo(520f, 200f)
            close()
        }
    }.build()
}

val Icons.Outlined.Tonality: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Outlined.Tonality",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(480f, 880f)
            quadTo(397f, 880f, 324f, 848.5f)
            quadTo(251f, 817f, 197f, 763f)
            quadTo(143f, 709f, 111.5f, 636f)
            quadTo(80f, 563f, 80f, 480f)
            quadTo(80f, 397f, 111.5f, 324f)
            quadTo(143f, 251f, 197f, 197f)
            quadTo(251f, 143f, 324f, 111.5f)
            quadTo(397f, 80f, 480f, 80f)
            quadTo(563f, 80f, 636f, 111.5f)
            quadTo(709f, 143f, 763f, 197f)
            quadTo(817f, 251f, 848.5f, 324f)
            quadTo(880f, 397f, 880f, 480f)
            quadTo(880f, 563f, 848.5f, 636f)
            quadTo(817f, 709f, 763f, 763f)
            quadTo(709f, 817f, 636f, 848.5f)
            quadTo(563f, 880f, 480f, 880f)
            close()
            moveTo(440f, 798f)
            lineTo(440f, 162f)
            quadTo(319f, 177f, 239.5f, 268f)
            quadTo(160f, 359f, 160f, 480f)
            quadTo(160f, 601f, 239.5f, 692f)
            quadTo(319f, 783f, 440f, 798f)
            close()
            moveTo(520f, 798f)
            quadTo(550f, 793f, 579f, 784.5f)
            quadTo(608f, 776f, 634f, 760f)
            lineTo(520f, 760f)
            lineTo(520f, 798f)
            close()
            moveTo(520f, 680f)
            lineTo(730f, 680f)
            quadTo(738f, 671f, 744f, 661f)
            quadTo(750f, 651f, 756f, 640f)
            lineTo(520f, 640f)
            lineTo(520f, 680f)
            close()
            moveTo(520f, 560f)
            lineTo(790f, 560f)
            quadTo(792f, 550f, 794f, 540f)
            quadTo(796f, 530f, 798f, 520f)
            lineTo(520f, 520f)
            lineTo(520f, 560f)
            close()
            moveTo(520f, 440f)
            lineTo(798f, 440f)
            quadTo(796f, 430f, 794f, 420f)
            quadTo(792f, 410f, 790f, 400f)
            lineTo(520f, 400f)
            lineTo(520f, 440f)
            close()
            moveTo(520f, 320f)
            lineTo(756f, 320f)
            quadTo(750f, 309f, 744f, 299f)
            quadTo(738f, 289f, 730f, 280f)
            lineTo(520f, 280f)
            lineTo(520f, 320f)
            close()
            moveTo(520f, 200f)
            lineTo(634f, 200f)
            quadTo(608f, 184f, 579f, 175.5f)
            quadTo(550f, 167f, 520f, 162f)
            lineTo(520f, 200f)
            close()
            moveTo(440f, 480f)
            quadTo(440f, 480f, 440f, 480f)
            quadTo(440f, 480f, 440f, 480f)
            quadTo(440f, 480f, 440f, 480f)
            quadTo(440f, 480f, 440f, 480f)
            close()
        }
    }.build()
}