/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2024 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Outlined.SettingsTimelapse: ImageVector by lazy {
    ImageVector.Builder(
        name = "SettingsTimelapse",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(720f, 840f)
            lineTo(720f, 600f)
            lineTo(920f, 720f)
            lineTo(720f, 840f)
            close()
            moveTo(520f, 840f)
            lineTo(520f, 600f)
            lineTo(720f, 720f)
            lineTo(520f, 840f)
            close()
            moveTo(480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            lineTo(480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            quadTo(480f, 480f, 480f, 480f)
            close()
            moveTo(370f, 880f)
            lineTo(354f, 752f)
            quadTo(341f, 747f, 329.5f, 740f)
            quadTo(318f, 733f, 307f, 725f)
            lineTo(188f, 775f)
            lineTo(78f, 585f)
            lineTo(181f, 507f)
            quadTo(180f, 500f, 180f, 493.5f)
            quadTo(180f, 487f, 180f, 480f)
            quadTo(180f, 473f, 180f, 466.5f)
            quadTo(180f, 460f, 181f, 453f)
            lineTo(78f, 375f)
            lineTo(188f, 185f)
            lineTo(307f, 235f)
            quadTo(318f, 227f, 330f, 220f)
            quadTo(342f, 213f, 354f, 208f)
            lineTo(370f, 80f)
            lineTo(590f, 80f)
            lineTo(606f, 208f)
            quadTo(619f, 213f, 630.5f, 220f)
            quadTo(642f, 227f, 653f, 235f)
            lineTo(772f, 185f)
            lineTo(882f, 375f)
            lineTo(779f, 453f)
            quadTo(780f, 460f, 780f, 466.5f)
            quadTo(780f, 473f, 780f, 480f)
            quadTo(780f, 490f, 780f, 500f)
            quadTo(780f, 510f, 778f, 520f)
            lineTo(696f, 520f)
            quadTo(698f, 510f, 699f, 500f)
            quadTo(700f, 490f, 700f, 480f)
            quadTo(699f, 461f, 697f, 446.5f)
            quadTo(695f, 432f, 691f, 419f)
            lineTo(777f, 354f)
            lineTo(738f, 286f)
            lineTo(639f, 328f)
            quadTo(617f, 305f, 590.5f, 289.5f)
            quadTo(564f, 274f, 533f, 266f)
            lineTo(520f, 160f)
            lineTo(441f, 160f)
            lineTo(427f, 266f)
            quadTo(396f, 274f, 369.5f, 289.5f)
            quadTo(343f, 305f, 321f, 327f)
            lineTo(222f, 286f)
            lineTo(183f, 354f)
            lineTo(269f, 418f)
            quadTo(264f, 433f, 262f, 448f)
            quadTo(260f, 463f, 260f, 480f)
            quadTo(260f, 496f, 262f, 511f)
            quadTo(264f, 526f, 269f, 541f)
            lineTo(183f, 606f)
            lineTo(222f, 674f)
            lineTo(321f, 632f)
            quadTo(345f, 657f, 375f, 674f)
            quadTo(405f, 691f, 440f, 696f)
            lineTo(440f, 880f)
            lineTo(370f, 880f)
            close()
            moveTo(440f, 614f)
            lineTo(440f, 523f)
            quadTo(432f, 515f, 427f, 504f)
            quadTo(422f, 493f, 422f, 480f)
            quadTo(422f, 455f, 439.5f, 437.5f)
            quadTo(457f, 420f, 482f, 420f)
            quadTo(507f, 420f, 524.5f, 437.5f)
            quadTo(542f, 455f, 542f, 480f)
            quadTo(542f, 491f, 538.5f, 501.5f)
            quadTo(535f, 512f, 527f, 520f)
            lineTo(616f, 520f)
            quadTo(619f, 510f, 620.5f, 500.5f)
            quadTo(622f, 491f, 622f, 480f)
            quadTo(622f, 422f, 581f, 381f)
            quadTo(540f, 340f, 482f, 340f)
            quadTo(423f, 340f, 382.5f, 381f)
            quadTo(342f, 422f, 342f, 480f)
            quadTo(342f, 528f, 369.5f, 564f)
            quadTo(397f, 600f, 440f, 614f)
            close()
        }
    }.build()
}
