package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.TwoTone.Scissors: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "TwoTone.Scissors",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(12f, 14f)
            lineToRelative(-2.35f, 2.35f)
            curveToRelative(0.133f, 0.25f, 0.225f, 0.517f, 0.275f, 0.8f)
            reflectiveCurveToRelative(0.075f, 0.567f, 0.075f, 0.85f)
            curveToRelative(0f, 1.1f, -0.392f, 2.042f, -1.175f, 2.825f)
            curveToRelative(-0.783f, 0.783f, -1.725f, 1.175f, -2.825f, 1.175f)
            reflectiveCurveToRelative(-2.042f, -0.392f, -2.825f, -1.175f)
            curveToRelative(-0.783f, -0.783f, -1.175f, -1.725f, -1.175f, -2.825f)
            reflectiveCurveToRelative(0.392f, -2.042f, 1.175f, -2.825f)
            curveToRelative(0.783f, -0.783f, 1.725f, -1.175f, 2.825f, -1.175f)
            curveToRelative(0.283f, 0f, 0.567f, 0.025f, 0.85f, 0.075f)
            reflectiveCurveToRelative(0.55f, 0.142f, 0.8f, 0.275f)
            lineToRelative(2.35f, -2.35f)
            lineToRelative(-2.35f, -2.35f)
            curveToRelative(-0.25f, 0.133f, -0.517f, 0.225f, -0.8f, 0.275f)
            reflectiveCurveToRelative(-0.567f, 0.075f, -0.85f, 0.075f)
            curveToRelative(-1.1f, 0f, -2.042f, -0.392f, -2.825f, -1.175f)
            curveToRelative(-0.783f, -0.783f, -1.175f, -1.725f, -1.175f, -2.825f)
            reflectiveCurveToRelative(0.392f, -2.042f, 1.175f, -2.825f)
            curveToRelative(0.783f, -0.783f, 1.725f, -1.175f, 2.825f, -1.175f)
            reflectiveCurveToRelative(2.042f, 0.392f, 2.825f, 1.175f)
            reflectiveCurveToRelative(1.175f, 1.725f, 1.175f, 2.825f)
            curveToRelative(0f, 0.283f, -0.025f, 0.567f, -0.075f, 0.85f)
            reflectiveCurveToRelative(-0.142f, 0.55f, -0.275f, 0.8f)
            lineToRelative(10.95f, 10.95f)
            curveToRelative(0.45f, 0.45f, 0.55f, 0.962f, 0.3f, 1.538f)
            reflectiveCurveToRelative(-0.692f, 0.863f, -1.325f, 0.863f)
            curveToRelative(-0.183f, 0f, -0.363f, -0.038f, -0.538f, -0.112f)
            reflectiveCurveToRelative(-0.329f, -0.179f, -0.463f, -0.313f)
            lineToRelative(-6.575f, -6.575f)
            close()
            moveTo(15f, 11f)
            lineToRelative(-2f, -2f)
            lineToRelative(5.575f, -5.575f)
            curveToRelative(0.133f, -0.133f, 0.287f, -0.237f, 0.463f, -0.313f)
            reflectiveCurveToRelative(0.354f, -0.112f, 0.538f, -0.112f)
            curveToRelative(0.633f, 0f, 1.071f, 0.292f, 1.313f, 0.875f)
            reflectiveCurveToRelative(0.138f, 1.1f, -0.313f, 1.55f)
            lineToRelative(-5.575f, 5.575f)
            close()
            moveTo(6f, 8f)
            curveToRelative(0.55f, 0f, 1.021f, -0.196f, 1.413f, -0.587f)
            reflectiveCurveToRelative(0.587f, -0.863f, 0.587f, -1.413f)
            reflectiveCurveToRelative(-0.196f, -1.021f, -0.587f, -1.413f)
            reflectiveCurveToRelative(-0.863f, -0.587f, -1.413f, -0.587f)
            reflectiveCurveToRelative(-1.021f, 0.196f, -1.413f, 0.587f)
            reflectiveCurveToRelative(-0.587f, 0.863f, -0.587f, 1.413f)
            reflectiveCurveToRelative(0.196f, 1.021f, 0.587f, 1.413f)
            reflectiveCurveToRelative(0.863f, 0.587f, 1.413f, 0.587f)
            close()
            moveTo(12f, 12.5f)
            curveToRelative(0.133f, 0f, 0.25f, -0.05f, 0.35f, -0.15f)
            reflectiveCurveToRelative(0.15f, -0.217f, 0.15f, -0.35f)
            reflectiveCurveToRelative(-0.05f, -0.25f, -0.15f, -0.35f)
            reflectiveCurveToRelative(-0.217f, -0.15f, -0.35f, -0.15f)
            reflectiveCurveToRelative(-0.25f, 0.05f, -0.35f, 0.15f)
            reflectiveCurveToRelative(-0.15f, 0.217f, -0.15f, 0.35f)
            reflectiveCurveToRelative(0.05f, 0.25f, 0.15f, 0.35f)
            reflectiveCurveToRelative(0.217f, 0.15f, 0.35f, 0.15f)
            close()
            moveTo(6f, 20f)
            curveToRelative(0.55f, 0f, 1.021f, -0.196f, 1.413f, -0.587f)
            reflectiveCurveToRelative(0.587f, -0.863f, 0.587f, -1.413f)
            reflectiveCurveToRelative(-0.196f, -1.021f, -0.587f, -1.413f)
            reflectiveCurveToRelative(-0.863f, -0.587f, -1.413f, -0.587f)
            reflectiveCurveToRelative(-1.021f, 0.196f, -1.413f, 0.587f)
            reflectiveCurveToRelative(-0.587f, 0.863f, -0.587f, 1.413f)
            reflectiveCurveToRelative(0.196f, 1.021f, 0.587f, 1.413f)
            reflectiveCurveToRelative(0.863f, 0.587f, 1.413f, 0.587f)
            close()
        }
        path(
            fill = SolidColor(Color(0xFF000000)),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(6f, 4f)
            lineTo(6f, 4f)
            arcTo(2f, 2f, 0f, isMoreThanHalf = false, isPositiveArc = true, 8f, 6f)
            lineTo(8f, 6f)
            arcTo(2f, 2f, 0f, isMoreThanHalf = false, isPositiveArc = true, 6f, 8f)
            lineTo(6f, 8f)
            arcTo(2f, 2f, 0f, isMoreThanHalf = false, isPositiveArc = true, 4f, 6f)
            lineTo(4f, 6f)
            arcTo(2f, 2f, 0f, isMoreThanHalf = false, isPositiveArc = true, 6f, 4f)
            close()
        }
        path(
            fill = SolidColor(Color(0xFF000000)),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(6f, 16f)
            lineTo(6f, 16f)
            arcTo(2f, 2f, 0f, isMoreThanHalf = false, isPositiveArc = true, 8f, 18f)
            lineTo(8f, 18f)
            arcTo(2f, 2f, 0f, isMoreThanHalf = false, isPositiveArc = true, 6f, 20f)
            lineTo(6f, 20f)
            arcTo(2f, 2f, 0f, isMoreThanHalf = false, isPositiveArc = true, 4f, 18f)
            lineTo(4f, 18f)
            arcTo(2f, 2f, 0f, isMoreThanHalf = false, isPositiveArc = true, 6f, 16f)
            close()
        }
        path(
            fill = SolidColor(Color(0xFF000000)),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(12.008f, 11.5f)
            lineTo(12.008f, 11.5f)
            arcTo(0.5f, 0.5f, 0f, isMoreThanHalf = false, isPositiveArc = true, 12.508f, 12f)
            lineTo(12.508f, 12f)
            arcTo(0.5f, 0.5f, 0f, isMoreThanHalf = false, isPositiveArc = true, 12.008f, 12.5f)
            lineTo(12.008f, 12.5f)
            arcTo(0.5f, 0.5f, 0f, isMoreThanHalf = false, isPositiveArc = true, 11.508f, 12f)
            lineTo(11.508f, 12f)
            arcTo(0.5f, 0.5f, 0f, isMoreThanHalf = false, isPositiveArc = true, 12.008f, 11.5f)
            close()
        }
    }.build()
}

val Icons.Rounded.Scissors: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Outlined.Scissors",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(12f, 14f)
            lineToRelative(-2.35f, 2.35f)
            curveToRelative(0.133f, 0.25f, 0.225f, 0.517f, 0.275f, 0.8f)
            reflectiveCurveToRelative(0.075f, 0.567f, 0.075f, 0.85f)
            curveToRelative(0f, 1.1f, -0.392f, 2.042f, -1.175f, 2.825f)
            curveToRelative(-0.783f, 0.783f, -1.725f, 1.175f, -2.825f, 1.175f)
            reflectiveCurveToRelative(-2.042f, -0.392f, -2.825f, -1.175f)
            curveToRelative(-0.783f, -0.783f, -1.175f, -1.725f, -1.175f, -2.825f)
            reflectiveCurveToRelative(0.392f, -2.042f, 1.175f, -2.825f)
            curveToRelative(0.783f, -0.783f, 1.725f, -1.175f, 2.825f, -1.175f)
            curveToRelative(0.283f, 0f, 0.567f, 0.025f, 0.85f, 0.075f)
            reflectiveCurveToRelative(0.55f, 0.142f, 0.8f, 0.275f)
            lineToRelative(2.35f, -2.35f)
            lineToRelative(-2.35f, -2.35f)
            curveToRelative(-0.25f, 0.133f, -0.517f, 0.225f, -0.8f, 0.275f)
            reflectiveCurveToRelative(-0.567f, 0.075f, -0.85f, 0.075f)
            curveToRelative(-1.1f, 0f, -2.042f, -0.392f, -2.825f, -1.175f)
            curveToRelative(-0.783f, -0.783f, -1.175f, -1.725f, -1.175f, -2.825f)
            reflectiveCurveToRelative(0.392f, -2.042f, 1.175f, -2.825f)
            curveToRelative(0.783f, -0.783f, 1.725f, -1.175f, 2.825f, -1.175f)
            reflectiveCurveToRelative(2.042f, 0.392f, 2.825f, 1.175f)
            reflectiveCurveToRelative(1.175f, 1.725f, 1.175f, 2.825f)
            curveToRelative(0f, 0.283f, -0.025f, 0.567f, -0.075f, 0.85f)
            reflectiveCurveToRelative(-0.142f, 0.55f, -0.275f, 0.8f)
            lineToRelative(10.95f, 10.95f)
            curveToRelative(0.45f, 0.45f, 0.55f, 0.962f, 0.3f, 1.538f)
            reflectiveCurveToRelative(-0.692f, 0.863f, -1.325f, 0.863f)
            curveToRelative(-0.183f, 0f, -0.363f, -0.038f, -0.538f, -0.112f)
            reflectiveCurveToRelative(-0.329f, -0.179f, -0.463f, -0.313f)
            lineToRelative(-6.575f, -6.575f)
            close()
            moveTo(15f, 11f)
            lineToRelative(-2f, -2f)
            lineToRelative(5.575f, -5.575f)
            curveToRelative(0.133f, -0.133f, 0.287f, -0.237f, 0.463f, -0.313f)
            reflectiveCurveToRelative(0.354f, -0.112f, 0.538f, -0.112f)
            curveToRelative(0.633f, 0f, 1.071f, 0.292f, 1.313f, 0.875f)
            reflectiveCurveToRelative(0.138f, 1.1f, -0.313f, 1.55f)
            lineToRelative(-5.575f, 5.575f)
            close()
            moveTo(6f, 8f)
            curveToRelative(0.55f, 0f, 1.021f, -0.196f, 1.413f, -0.587f)
            reflectiveCurveToRelative(0.587f, -0.863f, 0.587f, -1.413f)
            reflectiveCurveToRelative(-0.196f, -1.021f, -0.587f, -1.413f)
            reflectiveCurveToRelative(-0.863f, -0.587f, -1.413f, -0.587f)
            reflectiveCurveToRelative(-1.021f, 0.196f, -1.413f, 0.587f)
            reflectiveCurveToRelative(-0.587f, 0.863f, -0.587f, 1.413f)
            reflectiveCurveToRelative(0.196f, 1.021f, 0.587f, 1.413f)
            reflectiveCurveToRelative(0.863f, 0.587f, 1.413f, 0.587f)
            close()
            moveTo(12f, 12.5f)
            curveToRelative(0.133f, 0f, 0.25f, -0.05f, 0.35f, -0.15f)
            reflectiveCurveToRelative(0.15f, -0.217f, 0.15f, -0.35f)
            reflectiveCurveToRelative(-0.05f, -0.25f, -0.15f, -0.35f)
            reflectiveCurveToRelative(-0.217f, -0.15f, -0.35f, -0.15f)
            reflectiveCurveToRelative(-0.25f, 0.05f, -0.35f, 0.15f)
            reflectiveCurveToRelative(-0.15f, 0.217f, -0.15f, 0.35f)
            reflectiveCurveToRelative(0.05f, 0.25f, 0.15f, 0.35f)
            reflectiveCurveToRelative(0.217f, 0.15f, 0.35f, 0.15f)
            close()
            moveTo(6f, 20f)
            curveToRelative(0.55f, 0f, 1.021f, -0.196f, 1.413f, -0.587f)
            reflectiveCurveToRelative(0.587f, -0.863f, 0.587f, -1.413f)
            reflectiveCurveToRelative(-0.196f, -1.021f, -0.587f, -1.413f)
            reflectiveCurveToRelative(-0.863f, -0.587f, -1.413f, -0.587f)
            reflectiveCurveToRelative(-1.021f, 0.196f, -1.413f, 0.587f)
            reflectiveCurveToRelative(-0.587f, 0.863f, -0.587f, 1.413f)
            reflectiveCurveToRelative(0.196f, 1.021f, 0.587f, 1.413f)
            reflectiveCurveToRelative(0.863f, 0.587f, 1.413f, 0.587f)
            close()
        }
    }.build()
}