package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Rounded.MobileLayout: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Rounded.MobileLayout",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(120f, 840f)
            quadTo(87f, 840f, 63.5f, 816.5f)
            quadTo(40f, 793f, 40f, 760f)
            lineTo(40f, 680f)
            quadTo(40f, 647f, 63.5f, 623.5f)
            quadTo(87f, 600f, 120f, 600f)
            lineTo(360f, 600f)
            quadTo(393f, 600f, 416.5f, 623.5f)
            quadTo(440f, 647f, 440f, 680f)
            lineTo(440f, 760f)
            quadTo(440f, 793f, 416.5f, 816.5f)
            quadTo(393f, 840f, 360f, 840f)
            lineTo(120f, 840f)
            close()
            moveTo(600f, 840f)
            quadTo(567f, 840f, 543.5f, 816.5f)
            quadTo(520f, 793f, 520f, 760f)
            lineTo(520f, 200f)
            quadTo(520f, 167f, 543.5f, 143.5f)
            quadTo(567f, 120f, 600f, 120f)
            lineTo(840f, 120f)
            quadTo(873f, 120f, 896.5f, 143.5f)
            quadTo(920f, 167f, 920f, 200f)
            lineTo(920f, 760f)
            quadTo(920f, 793f, 896.5f, 816.5f)
            quadTo(873f, 840f, 840f, 840f)
            lineTo(600f, 840f)
            close()
            moveTo(720f, 720f)
            quadTo(737f, 720f, 748.5f, 708.5f)
            quadTo(760f, 697f, 760f, 680f)
            quadTo(760f, 663f, 748.5f, 651.5f)
            quadTo(737f, 640f, 720f, 640f)
            quadTo(703f, 640f, 691.5f, 651.5f)
            quadTo(680f, 663f, 680f, 680f)
            quadTo(680f, 697f, 691.5f, 708.5f)
            quadTo(703f, 720f, 720f, 720f)
            close()
            moveTo(120f, 520f)
            quadTo(87f, 520f, 63.5f, 496.5f)
            quadTo(40f, 473f, 40f, 440f)
            lineTo(40f, 200f)
            quadTo(40f, 167f, 63.5f, 143.5f)
            quadTo(87f, 120f, 120f, 120f)
            lineTo(360f, 120f)
            quadTo(393f, 120f, 416.5f, 143.5f)
            quadTo(440f, 167f, 440f, 200f)
            lineTo(440f, 440f)
            quadTo(440f, 473f, 416.5f, 496.5f)
            quadTo(393f, 520f, 360f, 520f)
            lineTo(120f, 520f)
            close()
            moveTo(280f, 320f)
            quadTo(297f, 320f, 308.5f, 308.5f)
            quadTo(320f, 297f, 320f, 280f)
            quadTo(320f, 263f, 308.5f, 251.5f)
            quadTo(297f, 240f, 280f, 240f)
            quadTo(263f, 240f, 251.5f, 251.5f)
            quadTo(240f, 263f, 240f, 280f)
            quadTo(240f, 297f, 251.5f, 308.5f)
            quadTo(263f, 320f, 280f, 320f)
            close()
            moveTo(110f, 440f)
            lineTo(290f, 440f)
            lineTo(200f, 320f)
            lineTo(110f, 440f)
            close()
        }
    }.build()
}
