/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2025 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Outlined.MeshDownload: ImageVector by lazy {
    ImageVector.Builder(
        name = "MeshDownloadOutlined",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(15f, 20f)
            curveToRelative(0f, -0.552f, -0.448f, -1f, -1f, -1f)
            horizontalLineToRelative(-1f)
            verticalLineToRelative(-2f)
            horizontalLineToRelative(4f)
            curveToRelative(1.105f, 0f, 2f, -0.895f, 2f, -2f)
            verticalLineTo(5f)
            curveToRelative(0f, -1.105f, -0.895f, -2f, -2f, -2f)
            horizontalLineTo(7f)
            curveTo(5.895f, 3f, 5f, 3.895f, 5f, 5f)
            verticalLineToRelative(10f)
            curveToRelative(0f, 1.105f, 0.895f, 2f, 2f, 2f)
            horizontalLineToRelative(4f)
            verticalLineToRelative(2f)
            horizontalLineToRelative(-1f)
            curveToRelative(-0.552f, 0f, -1f, 0.448f, -1f, 1f)
            horizontalLineTo(2f)
            verticalLineToRelative(2f)
            horizontalLineToRelative(7f)
            curveToRelative(0f, 0.552f, 0.448f, 1f, 1f, 1f)
            horizontalLineToRelative(4f)
            curveToRelative(0.552f, 0f, 1f, -0.448f, 1f, -1f)
            horizontalLineToRelative(7f)
            verticalLineToRelative(-2f)
            horizontalLineTo(15f)
            close()
            moveTo(17f, 15f)
            horizontalLineToRelative(-1.518f)
            curveToRelative(-0.017f, -0.055f, -0.533f, -1.283f, -0.562f, -1.348f)
            curveToRelative(0.703f, -0.081f, 1.37f, -0.296f, 1.994f, -0.631f)
            lineToRelative(0f, -0f)
            curveTo(16.934f, 13.01f, 16.967f, 12.996f, 17f, 12.982f)
            verticalLineTo(15f)
            close()
            moveTo(17f, 5f)
            verticalLineToRelative(1.59f)
            lineToRelative(-0.004f, 0.001f)
            curveTo(16.94f, 6.609f, 16.5f, 6.784f, 16.5f, 6.784f)
            curveToRelative(-0.138f, 0.055f, -0.275f, 0.098f, -0.414f, 0.17f)
            curveToRelative(-0.139f, 0.072f, -0.273f, 0.138f, -0.405f, 0.196f)
            curveToRelative(-0.087f, -0.745f, -0.324f, -1.445f, -0.674f, -2.095f)
            curveTo(15.001f, 5.044f, 14.992f, 5.02f, 14.984f, 5f)
            horizontalLineTo(17f)
            close()
            moveTo(14.982f, 10.612f)
            curveToRelative(0.224f, -0.445f, 0.454f, -0.928f, 0.585f, -1.478f)
            curveTo(16.104f, 9.003f, 16.569f, 8.783f, 17f, 8.574f)
            verticalLineToRelative(2.413f)
            lineToRelative(-0.169f, 0.06f)
            curveToRelative(-0.214f, 0.077f, -0.446f, 0.16f, -0.685f, 0.282f)
            curveToRelative(-0.406f, 0.208f, -0.776f, 0.379f, -1.146f, 0.442f)
            curveToRelative(-0.112f, 0.019f, -0.226f, 0.021f, -0.339f, 0.032f)
            curveTo(14.699f, 11.389f, 14.79f, 10.992f, 14.982f, 10.612f)
            close()
            moveTo(13.002f, 5f)
            lineToRelative(0.032f, 0.098f)
            curveToRelative(0.007f, 0.023f, 0.011f, 0.041f, 0.019f, 0.064f)
            lineTo(13.169f, 5.5f)
            lineToRelative(0.126f, 0.277f)
            lineToRelative(0.002f, -0.004f)
            curveToRelative(0.008f, 0.017f, 0.012f, 0.034f, 0.02f, 0.051f)
            lineToRelative(0f, 0f)
            curveToRelative(0.202f, 0.404f, 0.382f, 0.761f, 0.458f, 1.113f)
            curveToRelative(0.032f, 0.146f, 0.034f, 0.302f, 0.049f, 0.453f)
            curveToRelative(-0.421f, -0.039f, -0.825f, -0.136f, -1.215f, -0.335f)
            curveToRelative(-0.433f, -0.22f, -0.911f, -0.429f, -1.443f, -0.557f)
            curveTo(11.032f, 5.937f, 10.796f, 5.45f, 10.575f, 5f)
            horizontalLineTo(13.002f)
            close()
            moveTo(10.695f, 10.376f)
            curveToRelative(0.311f, -0.596f, 0.508f, -1.233f, 0.582f, -1.899f)
            curveToRelative(0.19f, 0.084f, 0.387f, 0.18f, 0.597f, 0.285f)
            curveToRelative(0.544f, 0.268f, 1.116f, 0.424f, 1.701f, 0.489f)
            curveToRelative(-0.134f, 0.29f, -0.276f, 0.583f, -0.412f, 0.89f)
            curveToRelative(-0.205f, 0.46f, -0.312f, 0.933f, -0.362f, 1.404f)
            curveToRelative(-0.22f, -0.098f, -0.448f, -0.209f, -0.702f, -0.33f)
            lineToRelative(0f, 0f)
            curveToRelative(-0.516f, -0.243f, -1.053f, -0.38f, -1.599f, -0.439f)
            curveTo(10.558f, 10.645f, 10.624f, 10.512f, 10.695f, 10.376f)
            close()
            moveTo(7f, 5f)
            horizontalLineToRelative(1.592f)
            lineToRelative(0.197f, 0.5f)
            curveToRelative(0.069f, 0.173f, 0.128f, 0.347f, 0.218f, 0.519f)
            curveToRelative(0.062f, 0.119f, 0.117f, 0.236f, 0.168f, 0.352f)
            curveTo(8.494f, 6.448f, 7.842f, 6.648f, 7.232f, 6.974f)
            horizontalLineToRelative(-0f)
            curveTo(7.168f, 7.008f, 7.079f, 7.043f, 7f, 7.076f)
            verticalLineTo(5f)
            close()
            moveTo(7f, 15f)
            verticalLineToRelative(-1.52f)
            lineToRelative(0.159f, -0.054f)
            curveToRelative(0.315f, -0.106f, 0.619f, -0.238f, 0.912f, -0.391f)
            horizontalLineToRelative(-0f)
            curveToRelative(0.11f, -0.057f, 0.22f, -0.089f, 0.329f, -0.137f)
            curveToRelative(0.078f, 0.674f, 0.279f, 1.32f, 0.601f, 1.924f)
            verticalLineToRelative(0f)
            curveTo(9.026f, 14.867f, 9.055f, 14.941f, 9.08f, 15f)
            horizontalLineTo(7f)
            close()
            moveTo(9.114f, 9.383f)
            curveToRelative(-0.225f, 0.452f, -0.465f, 0.944f, -0.6f, 1.509f)
            curveTo(7.943f, 11.03f, 7.453f, 11.273f, 7f, 11.492f)
            verticalLineTo(9.067f)
            lineToRelative(0.159f, -0.053f)
            curveToRelative(0.228f, -0.077f, 0.47f, -0.164f, 0.714f, -0.286f)
            lineToRelative(0f, -0f)
            curveToRelative(0.396f, -0.199f, 0.75f, -0.376f, 1.099f, -0.45f)
            horizontalLineToRelative(-0f)
            curveToRelative(0.147f, -0.032f, 0.299f, -0.033f, 0.449f, -0.047f)
            curveTo(9.384f, 8.631f, 9.297f, 9.015f, 9.114f, 9.383f)
            close()
            moveTo(11.018f, 14.835f)
            curveToRelative(-0.08f, -0.228f, -0.169f, -0.47f, -0.293f, -0.715f)
            lineToRelative(0f, 0f)
            curveToRelative(-0.183f, -0.36f, -0.341f, -0.688f, -0.414f, -1.013f)
            curveToRelative(-0.035f, -0.152f, -0.037f, -0.313f, -0.053f, -0.471f)
            curveToRelative(0.426f, 0.04f, 0.835f, 0.139f, 1.233f, 0.342f)
            horizontalLineToRelative(0f)
            curveToRelative(0.352f, 0.179f, 0.733f, 0.374f, 1.174f, 0.499f)
            curveToRelative(0.09f, 0.025f, 0.176f, 0.044f, 0.263f, 0.065f)
            curveToRelative(0.117f, 0.486f, 0.3f, 0.933f, 0.51f, 1.342f)
            verticalLineToRelative(0f)
            curveTo(13.454f, 14.91f, 13.474f, 14.964f, 13.49f, 15f)
            horizontalLineToRelative(-2.413f)
            lineTo(11.018f, 14.835f)
            close()
        }
    }.build()
}
