/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2025 T8RIN (Malik Mukhametzyanov)
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Rounded.HistoryCreate: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Rounded.HistoryEdu",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(320f, 800f)
            quadTo(287f, 800f, 263.5f, 776.5f)
            quadTo(240f, 753f, 240f, 720f)
            lineTo(240f, 600f)
            lineTo(360f, 600f)
            lineTo(360f, 510f)
            quadTo(325f, 508f, 293.5f, 494.5f)
            quadTo(262f, 481f, 236f, 454f)
            lineTo(236f, 410f)
            lineTo(190f, 410f)
            lineTo(60f, 280f)
            quadTo(96f, 234f, 149f, 215f)
            quadTo(202f, 196f, 256f, 196f)
            quadTo(283f, 196f, 308.5f, 200f)
            quadTo(334f, 204f, 360f, 215f)
            lineTo(360f, 160f)
            lineTo(840f, 160f)
            lineTo(840f, 680f)
            quadTo(840f, 730f, 805f, 765f)
            quadTo(770f, 800f, 720f, 800f)
            lineTo(320f, 800f)
            close()
            moveTo(440f, 600f)
            lineTo(680f, 600f)
            lineTo(680f, 680f)
            quadTo(680f, 697f, 691.5f, 708.5f)
            quadTo(703f, 720f, 720f, 720f)
            quadTo(737f, 720f, 748.5f, 708.5f)
            quadTo(760f, 697f, 760f, 680f)
            lineTo(760f, 240f)
            lineTo(440f, 240f)
            lineTo(440f, 264f)
            lineTo(680f, 504f)
            lineTo(680f, 560f)
            lineTo(624f, 560f)
            lineTo(510f, 446f)
            lineTo(502f, 454f)
            quadTo(488f, 468f, 472.5f, 479f)
            quadTo(457f, 490f, 440f, 496f)
            lineTo(440f, 600f)
            close()
            moveTo(224f, 330f)
            lineTo(316f, 330f)
            lineTo(316f, 416f)
            quadTo(328f, 424f, 341f, 427f)
            quadTo(354f, 430f, 368f, 430f)
            quadTo(391f, 430f, 409.5f, 423f)
            quadTo(428f, 416f, 446f, 398f)
            lineTo(454f, 390f)
            lineTo(398f, 334f)
            quadTo(369f, 305f, 333f, 290.5f)
            quadTo(297f, 276f, 256f, 276f)
            quadTo(236f, 276f, 218f, 279f)
            quadTo(200f, 282f, 182f, 288f)
            lineTo(224f, 330f)
            close()
        }
    }.build()
}

val Icons.Outlined.HistoryCreate: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Outlined.HistoryEdu",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(320f, 800f)
            quadTo(287f, 800f, 263.5f, 776.5f)
            quadTo(240f, 753f, 240f, 720f)
            lineTo(240f, 600f)
            lineTo(360f, 600f)
            lineTo(360f, 510f)
            quadTo(325f, 508f, 293.5f, 494.5f)
            quadTo(262f, 481f, 236f, 454f)
            lineTo(236f, 410f)
            lineTo(190f, 410f)
            lineTo(60f, 280f)
            quadTo(96f, 234f, 149f, 215f)
            quadTo(202f, 196f, 256f, 196f)
            quadTo(283f, 196f, 308.5f, 200f)
            quadTo(334f, 204f, 360f, 215f)
            lineTo(360f, 160f)
            lineTo(840f, 160f)
            lineTo(840f, 680f)
            quadTo(840f, 730f, 805f, 765f)
            quadTo(770f, 800f, 720f, 800f)
            lineTo(320f, 800f)
            close()
            moveTo(440f, 600f)
            lineTo(680f, 600f)
            lineTo(680f, 680f)
            quadTo(680f, 697f, 691.5f, 708.5f)
            quadTo(703f, 720f, 720f, 720f)
            quadTo(737f, 720f, 748.5f, 708.5f)
            quadTo(760f, 697f, 760f, 680f)
            lineTo(760f, 240f)
            lineTo(440f, 240f)
            lineTo(440f, 264f)
            lineTo(680f, 504f)
            lineTo(680f, 560f)
            lineTo(624f, 560f)
            lineTo(510f, 446f)
            lineTo(502f, 454f)
            quadTo(488f, 468f, 472.5f, 479f)
            quadTo(457f, 490f, 440f, 496f)
            lineTo(440f, 600f)
            close()
            moveTo(224f, 330f)
            lineTo(316f, 330f)
            lineTo(316f, 416f)
            quadTo(328f, 424f, 341f, 427f)
            quadTo(354f, 430f, 368f, 430f)
            quadTo(391f, 430f, 409.5f, 423f)
            quadTo(428f, 416f, 446f, 398f)
            lineTo(454f, 390f)
            lineTo(398f, 334f)
            quadTo(369f, 305f, 333f, 290.5f)
            quadTo(297f, 276f, 256f, 276f)
            quadTo(236f, 276f, 218f, 279f)
            quadTo(200f, 282f, 182f, 288f)
            lineTo(224f, 330f)
            close()
            moveTo(600f, 680f)
            lineTo(320f, 680f)
            lineTo(320f, 720f)
            quadTo(320f, 720f, 320f, 720f)
            quadTo(320f, 720f, 320f, 720f)
            lineTo(606f, 720f)
            quadTo(603f, 711f, 601.5f, 701f)
            quadTo(600f, 691f, 600f, 680f)
            close()
            moveTo(320f, 720f)
            quadTo(320f, 711f, 320f, 701f)
            quadTo(320f, 691f, 320f, 680f)
            lineTo(320f, 680f)
            quadTo(320f, 690f, 320f, 700f)
            quadTo(320f, 710f, 320f, 720f)
            lineTo(320f, 720f)
            close()
        }
    }.build()
}