/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2024 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Outlined.Exif: ImageVector by lazy {
    Builder(
        name = "Exif", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
        viewportWidth = 24.0f, viewportHeight = 24.0f
    ).apply {
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(22.37f, 11.58f)
            lineToRelative(-9.45f, -9.45f)
            curveTo(12.5f, 1.71f, 11.975f, 1.5f, 11.45f, 1.5f)
            horizontalLineTo(4.1f)
            curveTo(2.945f, 1.5f, 2.0f, 2.445f, 2.0f, 3.6f)
            verticalLineToRelative(7.35f)
            curveTo(2.0f, 11.475f, 2.21f, 12.0f, 2.63f, 12.42f)
            lineToRelative(9.45f, 9.45f)
            curveTo(12.5f, 22.29f, 13.025f, 22.5f, 13.55f, 22.5f)
            curveToRelative(0.525f, 0.0f, 1.05f, -0.21f, 1.47f, -0.63f)
            lineToRelative(7.35f, -7.35f)
            curveTo(22.79f, 14.1f, 23.0f, 13.575f, 23.0f, 13.05f)
            curveTo(23.0f, 12.525f, 22.79f, 12.0f, 22.37f, 11.58f)
            close()
            moveTo(13.55f, 20.4f)
            lineToRelative(-9.45f, -9.45f)
            verticalLineTo(3.6f)
            horizontalLineToRelative(7.35f)
            lineToRelative(9.45f, 9.45f)
            lineTo(13.55f, 20.4f)
            close()
        }
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(6.4701f, 4.65f)
            curveToRelative(0.704f, 0.0f, 1.3201f, 0.616f, 1.3201f, 1.3201f)
            reflectiveCurveTo(7.1741f, 7.2901f, 6.4701f, 7.2901f)
            reflectiveCurveTo(5.15f, 6.6741f, 5.15f, 5.9701f)
            reflectiveCurveTo(5.766f, 4.65f, 6.4701f, 4.65f)
        }
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(12.233f, 14.8042f)
            lineToRelative(-0.7744f, -0.7744f)
            lineToRelative(3.0977f, -3.0977f)
            lineToRelative(0.7744f, 0.7744f)
            lineToRelative(-3.0977f, 3.0977f)
        }
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(16.8796f, 14.8042f)
            lineToRelative(-0.7744f, -0.7744f)
            lineToRelative(-0.5163f, 0.5163f)
            lineToRelative(0.7744f, 0.7744f)
            lineToRelative(-0.7744f, 0.7744f)
            lineToRelative(-0.7744f, -0.7744f)
            lineToRelative(-1.0326f, 1.0326f)
            lineToRelative(-0.7744f, -0.7744f)
            lineToRelative(3.0977f, -3.0977f)
            lineToRelative(1.5489f, 1.5489f)
            close()
        }
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(10.231f, 8.1556f)
            lineToRelative(0.7744f, 0.7744f)
            lineToRelative(0.7744f, -0.7744f)
            lineToRelative(-0.7744f, -0.7744f)
            lineToRelative(-0.7744f, -0.7744f)
            lineToRelative(-1.2159f, 1.2159f)
            lineToRelative(-0.666f, 0.666f)
            lineToRelative(-1.2159f, 1.2159f)
            lineToRelative(0.7744f, 0.7744f)
            lineToRelative(0.7744f, 0.7744f)
            lineToRelative(0.7744f, -0.7744f)
            lineToRelative(-0.7744f, -0.7744f)
            lineToRelative(0.2581f, -0.2581f)
            lineToRelative(0.1833f, -0.1833f)
            lineToRelative(0.7744f, 0.7744f)
            lineToRelative(0.666f, -0.666f)
            lineToRelative(-0.7744f, -0.7744f)
            lineToRelative(0.1833f, -0.1833f)
            close()
        }
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(12.2426f, 8.5991f)
            lineToRelative(-0.9351f, 2.1819f)
            lineToRelative(-2.1819f, 0.9351f)
            lineToRelative(0.6234f, 0.6234f)
            lineToRelative(1.0909f, -0.4675f)
            lineToRelative(-0.4675f, 1.0909f)
            lineToRelative(0.6234f, 0.6234f)
            lineToRelative(0.9351f, -2.1819f)
            lineToRelative(2.1819f, -0.9351f)
            lineToRelative(-0.6234f, -0.6234f)
            lineToRelative(-1.0909f, 0.4675f)
            lineToRelative(0.4675f, -1.0909f)
            lineTo(12.2426f, 8.5991f)
            close()
        }
    }.build()
}

val Icons.Rounded.Exif: ImageVector by lazy {
    Builder(
        name = "Exif Rounded", defaultWidth = 24.0.dp, defaultHeight =
            24.0.dp, viewportWidth = 24.0f, viewportHeight = 24.0f
    ).apply {
        path(
            fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(22.3701f, 11.58f)
            lineToRelative(-9.45f, -9.45f)
            curveTo(12.5f, 1.71f, 11.975f, 1.5f, 11.45f, 1.5f)
            horizontalLineTo(4.1f)
            curveTo(2.945f, 1.5f, 2.0f, 2.445f, 2.0f, 3.6f)
            verticalLineToRelative(7.35f)
            curveTo(2.0f, 11.475f, 2.21f, 12.0f, 2.63f, 12.42f)
            lineToRelative(9.45f, 9.45f)
            curveTo(12.5f, 22.29f, 13.025f, 22.5f, 13.55f, 22.5f)
            curveToRelative(0.525f, 0.0f, 1.05f, -0.21f, 1.47f, -0.63f)
            lineToRelative(7.35f, -7.35f)
            curveTo(22.79f, 14.1f, 23.0f, 13.575f, 23.0f, 13.05f)
            curveTo(23.0f, 12.525f, 22.79f, 12.0f, 22.3701f, 11.58f)
            close()
            moveTo(5.15f, 5.9701f)
            curveToRelative(0.0f, -0.704f, 0.616f, -1.3201f, 1.3201f, -1.3201f)
            curveToRelative(0.704f, 0.0f, 1.3201f, 0.616f, 1.3201f, 1.3201f)
            curveToRelative(0.0f, 0.704f, -0.6161f, 1.3201f, -1.3201f, 1.3201f)
            curveTo(5.7661f, 7.2902f, 5.15f, 6.6741f, 5.15f, 5.9701f)
            close()
            moveTo(7.9077f, 10.4789f)
            lineTo(7.1332f, 9.7044f)
            lineToRelative(1.2159f, -1.2159f)
            lineToRelative(0.666f, -0.666f)
            lineToRelative(1.2159f, -1.2159f)
            lineToRelative(0.7744f, 0.7744f)
            lineToRelative(0.7745f, 0.7745f)
            lineToRelative(-0.7745f, 0.7744f)
            lineTo(10.231f, 8.1556f)
            lineTo(9.9728f, 8.4137f)
            lineTo(9.7895f, 8.597f)
            lineTo(10.564f, 9.3715f)
            lineToRelative(-0.666f, 0.666f)
            lineTo(9.1235f, 9.263f)
            lineTo(8.9402f, 9.4463f)
            lineTo(8.6821f, 9.7044f)
            lineToRelative(0.7745f, 0.7745f)
            lineToRelative(-0.7745f, 0.7744f)
            lineTo(7.9077f, 10.4789f)
            close()
            moveTo(10.3724f, 12.9628f)
            lineToRelative(0.4676f, -1.0909f)
            lineToRelative(-1.0909f, 0.4675f)
            lineToRelative(-0.6234f, -0.6234f)
            lineToRelative(2.1819f, -0.9351f)
            lineToRelative(0.9351f, -2.1819f)
            lineToRelative(0.6234f, 0.6234f)
            lineToRelative(-0.4675f, 1.0909f)
            lineToRelative(1.0909f, -0.4675f)
            lineToRelative(0.6234f, 0.6234f)
            lineToRelative(-2.1819f, 0.9351f)
            lineToRelative(-0.9351f, 2.1819f)
            lineTo(10.3724f, 12.9628f)
            close()
            moveTo(11.4585f, 14.0297f)
            lineToRelative(3.0978f, -3.0977f)
            lineToRelative(0.7744f, 0.7744f)
            lineToRelative(-3.0977f, 3.0977f)
            lineTo(11.4585f, 14.0297f)
            close()
            moveTo(16.8796f, 14.8041f)
            lineToRelative(-0.7744f, -0.7744f)
            lineToRelative(-0.5163f, 0.5163f)
            lineToRelative(0.7744f, 0.7744f)
            lineToRelative(-0.7744f, 0.7745f)
            lineToRelative(-0.7745f, -0.7745f)
            lineToRelative(-1.0325f, 1.0326f)
            lineToRelative(-0.7745f, -0.7744f)
            lineToRelative(3.0978f, -3.0978f)
            lineToRelative(1.5488f, 1.5489f)
            lineTo(16.8796f, 14.8041f)
            close()
        }
    }.build()
}

val Icons.TwoTone.Exif: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    Builder(
        name = "TwoTone.Exif",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(22.37f, 11.58f)
            lineTo(12.92f, 2.13f)
            curveToRelative(-0.42f, -0.42f, -0.945f, -0.63f, -1.47f, -0.63f)
            horizontalLineToRelative(-7.35f)
            curveToRelative(-1.155f, 0f, -2.1f, 0.945f, -2.1f, 2.1f)
            verticalLineToRelative(7.35f)
            curveToRelative(0f, 0.525f, 0.21f, 1.05f, 0.63f, 1.47f)
            lineToRelative(9.45f, 9.45f)
            curveToRelative(0.42f, 0.42f, 0.945f, 0.63f, 1.47f, 0.63f)
            curveToRelative(0.525f, 0f, 1.05f, -0.21f, 1.47f, -0.63f)
            lineToRelative(7.35f, -7.35f)
            curveToRelative(0.42f, -0.42f, 0.63f, -0.945f, 0.63f, -1.47f)
            reflectiveCurveToRelative(-0.21f, -1.05f, -0.63f, -1.47f)
            close()
            moveTo(13.55f, 20.4f)
            lineTo(4.1f, 10.95f)
            verticalLineTo(3.6f)
            horizontalLineToRelative(7.35f)
            lineToRelative(9.45f, 9.45f)
            lineToRelative(-7.35f, 7.35f)
            close()
        }
        path(
            fill = SolidColor(Color(0xFF000000)),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(13.55f, 20.4f)
            lineToRelative(-9.45f, -9.45f)
            lineToRelative(0f, -7.35f)
            lineToRelative(7.35f, 0f)
            lineToRelative(9.45f, 9.45f)
            lineToRelative(-7.35f, 7.35f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(6.47f, 4.65f)
            curveToRelative(0.704f, 0f, 1.32f, 0.616f, 1.32f, 1.32f)
            reflectiveCurveToRelative(-0.616f, 1.32f, -1.32f, 1.32f)
            reflectiveCurveToRelative(-1.32f, -0.616f, -1.32f, -1.32f)
            reflectiveCurveToRelative(0.616f, -1.32f, 1.32f, -1.32f)
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(12.233f, 14.804f)
            lineToRelative(-0.774f, -0.774f)
            lineToRelative(3.098f, -3.098f)
            lineToRelative(0.774f, 0.774f)
            lineToRelative(-3.098f, 3.098f)
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(16.88f, 14.804f)
            lineToRelative(-0.774f, -0.774f)
            lineToRelative(-0.516f, 0.516f)
            lineToRelative(0.774f, 0.774f)
            lineToRelative(-0.774f, 0.774f)
            lineToRelative(-0.774f, -0.774f)
            lineToRelative(-1.033f, 1.033f)
            lineToRelative(-0.774f, -0.774f)
            lineToRelative(3.098f, -3.098f)
            lineToRelative(1.549f, 1.549f)
            lineToRelative(-0.775f, 0.774f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(10.231f, 8.156f)
            lineToRelative(0.774f, 0.774f)
            lineToRelative(0.774f, -0.774f)
            lineToRelative(-0.774f, -0.774f)
            lineToRelative(-0.774f, -0.774f)
            lineToRelative(-1.216f, 1.216f)
            lineToRelative(-0.666f, 0.666f)
            lineToRelative(-1.216f, 1.216f)
            lineToRelative(0.774f, 0.774f)
            lineToRelative(0.774f, 0.774f)
            lineToRelative(0.774f, -0.774f)
            lineToRelative(-0.774f, -0.774f)
            lineToRelative(0.258f, -0.258f)
            lineToRelative(0.183f, -0.183f)
            lineToRelative(0.774f, 0.774f)
            lineToRelative(0.666f, -0.666f)
            lineToRelative(-0.774f, -0.774f)
            lineToRelative(0.183f, -0.183f)
            lineToRelative(0.258f, -0.258f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(12.243f, 8.599f)
            lineToRelative(-0.935f, 2.182f)
            lineToRelative(-2.182f, 0.935f)
            lineToRelative(0.623f, 0.623f)
            lineToRelative(1.091f, -0.467f)
            lineToRelative(-0.467f, 1.091f)
            lineToRelative(0.623f, 0.623f)
            lineToRelative(0.935f, -2.182f)
            lineToRelative(2.182f, -0.935f)
            lineToRelative(-0.623f, -0.623f)
            lineToRelative(-1.091f, 0.467f)
            lineToRelative(0.467f, -1.091f)
            lineToRelative(-0.623f, -0.623f)
            close()
        }
    }.build()
}