/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2024 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Outlined.Draw: ImageVector by lazy {
    ImageVector.Builder(
        name = "Draw",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(200f, 840f)
            quadTo(183f, 840f, 171.5f, 828.5f)
            quadTo(160f, 817f, 160f, 800f)
            lineTo(160f, 703f)
            quadTo(160f, 687f, 166f, 672.5f)
            quadTo(172f, 658f, 183f, 647f)
            lineTo(687f, 144f)
            quadTo(699f, 132f, 714f, 126f)
            quadTo(729f, 120f, 744f, 120f)
            quadTo(760f, 120f, 774.5f, 126f)
            quadTo(789f, 132f, 800f, 144f)
            lineTo(856f, 200f)
            quadTo(868f, 211f, 874f, 225.5f)
            quadTo(880f, 240f, 880f, 256f)
            quadTo(880f, 271f, 874f, 286f)
            quadTo(868f, 301f, 856f, 313f)
            lineTo(353f, 817f)
            quadTo(342f, 828f, 327.5f, 834f)
            quadTo(313f, 840f, 297f, 840f)
            lineTo(200f, 840f)
            close()
            moveTo(240f, 760f)
            lineTo(296f, 760f)
            lineTo(689f, 368f)
            lineTo(661f, 339f)
            lineTo(632f, 311f)
            lineTo(240f, 704f)
            lineTo(240f, 760f)
            close()
            moveTo(800f, 257f)
            lineTo(800f, 257f)
            lineTo(743f, 200f)
            lineTo(743f, 200f)
            lineTo(800f, 257f)
            close()
            moveTo(661f, 339f)
            lineTo(632f, 311f)
            lineTo(632f, 311f)
            lineTo(689f, 368f)
            lineTo(689f, 368f)
            lineTo(661f, 339f)
            close()
            moveTo(560f, 840f)
            quadTo(634f, 840f, 697f, 803f)
            quadTo(760f, 766f, 760f, 700f)
            quadTo(760f, 668f, 744f, 644.5f)
            quadTo(728f, 621f, 702f, 601f)
            quadTo(688f, 591f, 672f, 591f)
            quadTo(656f, 591f, 645f, 603f)
            quadTo(634f, 615f, 634f, 632.5f)
            quadTo(634f, 650f, 648f, 660f)
            quadTo(662f, 671f, 671f, 680f)
            quadTo(680f, 689f, 680f, 700f)
            quadTo(680f, 723f, 643.5f, 741.5f)
            quadTo(607f, 760f, 560f, 760f)
            quadTo(543f, 760f, 531.5f, 771.5f)
            quadTo(520f, 783f, 520f, 800f)
            quadTo(520f, 817f, 531.5f, 828.5f)
            quadTo(543f, 840f, 560f, 840f)
            close()
            moveTo(360f, 240f)
            quadTo(360f, 254f, 342.5f, 265.5f)
            quadTo(325f, 277f, 262f, 306f)
            quadTo(182f, 341f, 151f, 369.5f)
            quadTo(120f, 398f, 120f, 440f)
            quadTo(120f, 466f, 132f, 486f)
            quadTo(144f, 506f, 163f, 521f)
            quadTo(176f, 532f, 192f, 530.5f)
            quadTo(208f, 529f, 219f, 516f)
            quadTo(230f, 503f, 229f, 487f)
            quadTo(228f, 471f, 215f, 460f)
            quadTo(208f, 455f, 204f, 450f)
            quadTo(200f, 445f, 200f, 440f)
            quadTo(200f, 428f, 218f, 416f)
            quadTo(236f, 404f, 294f, 379f)
            quadTo(382f, 341f, 411f, 310f)
            quadTo(440f, 279f, 440f, 240f)
            quadTo(440f, 185f, 396f, 152.5f)
            quadTo(352f, 120f, 280f, 120f)
            quadTo(235f, 120f, 199.5f, 136f)
            quadTo(164f, 152f, 145f, 175f)
            quadTo(134f, 188f, 136f, 204f)
            quadTo(138f, 220f, 151f, 230f)
            quadTo(164f, 241f, 180f, 239f)
            quadTo(196f, 237f, 207f, 226f)
            quadTo(221f, 212f, 238f, 206f)
            quadTo(255f, 200f, 280f, 200f)
            quadTo(321f, 200f, 340.5f, 212f)
            quadTo(360f, 224f, 360f, 240f)
            close()
        }
    }.build()
}

val Icons.Rounded.Draw: ImageVector by lazy {
    ImageVector.Builder(
        name = "Draw",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(200f, 840f)
            quadTo(183f, 840f, 171.5f, 828.5f)
            quadTo(160f, 817f, 160f, 800f)
            lineTo(160f, 703f)
            quadTo(160f, 687f, 166f, 672.5f)
            quadTo(172f, 658f, 183f, 647f)
            lineTo(687f, 144f)
            quadTo(699f, 132f, 714f, 126f)
            quadTo(729f, 120f, 744f, 120f)
            quadTo(760f, 120f, 774.5f, 126f)
            quadTo(789f, 132f, 800f, 144f)
            lineTo(856f, 200f)
            quadTo(868f, 211f, 874f, 225.5f)
            quadTo(880f, 240f, 880f, 256f)
            quadTo(880f, 271f, 874f, 286f)
            quadTo(868f, 301f, 856f, 313f)
            lineTo(353f, 817f)
            quadTo(342f, 828f, 327.5f, 834f)
            quadTo(313f, 840f, 297f, 840f)
            lineTo(200f, 840f)
            close()
            moveTo(746f, 311f)
            lineTo(800f, 257f)
            lineTo(743f, 200f)
            lineTo(689f, 254f)
            lineTo(746f, 311f)
            close()
            moveTo(560f, 840f)
            quadTo(634f, 840f, 697f, 803f)
            quadTo(760f, 766f, 760f, 700f)
            quadTo(760f, 668f, 744f, 644.5f)
            quadTo(728f, 621f, 702f, 601f)
            quadTo(688f, 591f, 672f, 591f)
            quadTo(656f, 591f, 645f, 603f)
            quadTo(634f, 615f, 634f, 632.5f)
            quadTo(634f, 650f, 648f, 660f)
            quadTo(662f, 671f, 671f, 680f)
            quadTo(680f, 689f, 680f, 700f)
            quadTo(680f, 723f, 643.5f, 741.5f)
            quadTo(607f, 760f, 560f, 760f)
            quadTo(543f, 760f, 531.5f, 771.5f)
            quadTo(520f, 783f, 520f, 800f)
            quadTo(520f, 817f, 531.5f, 828.5f)
            quadTo(543f, 840f, 560f, 840f)
            close()
            moveTo(360f, 240f)
            quadTo(360f, 254f, 342.5f, 265.5f)
            quadTo(325f, 277f, 262f, 306f)
            quadTo(182f, 341f, 151f, 369.5f)
            quadTo(120f, 398f, 120f, 440f)
            quadTo(120f, 466f, 132f, 486f)
            quadTo(144f, 506f, 163f, 521f)
            quadTo(176f, 532f, 192f, 530.5f)
            quadTo(208f, 529f, 219f, 516f)
            quadTo(230f, 503f, 229f, 487f)
            quadTo(228f, 471f, 215f, 460f)
            quadTo(208f, 455f, 204f, 450f)
            quadTo(200f, 445f, 200f, 440f)
            quadTo(200f, 428f, 218f, 416f)
            quadTo(236f, 404f, 294f, 379f)
            quadTo(382f, 341f, 411f, 310f)
            quadTo(440f, 279f, 440f, 240f)
            quadTo(440f, 185f, 396f, 152.5f)
            quadTo(352f, 120f, 280f, 120f)
            quadTo(235f, 120f, 199.5f, 136f)
            quadTo(164f, 152f, 145f, 175f)
            quadTo(134f, 188f, 136f, 204f)
            quadTo(138f, 220f, 151f, 230f)
            quadTo(164f, 241f, 180f, 239f)
            quadTo(196f, 237f, 207f, 226f)
            quadTo(221f, 212f, 238f, 206f)
            quadTo(255f, 200f, 280f, 200f)
            quadTo(321f, 200f, 340.5f, 212f)
            quadTo(360f, 224f, 360f, 240f)
            close()
        }
    }.build()
}

val Icons.TwoTone.Draw: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "TwoTone.Draw",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(
            fill = SolidColor(Color(0xFF000000)),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(6f, 19f)
            lineToRelative(1.4f, 0f)
            lineToRelative(9.825f, -9.8f)
            lineToRelative(-0.7f, -0.725f)
            lineToRelative(-0.725f, -0.7f)
            lineToRelative(-9.8f, 9.825f)
            lineToRelative(0f, 1.4f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(16.525f, 8.475f)
            lineToRelative(-0.725f, -0.7f)
            lineToRelative(0f, 0f)
            lineToRelative(1.425f, 1.425f)
            lineToRelative(0f, 0f)
            lineToRelative(-0.7f, -0.725f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(14f, 21f)
            curveToRelative(1.233f, 0f, 2.375f, -0.308f, 3.425f, -0.925f)
            reflectiveCurveToRelative(1.575f, -1.475f, 1.575f, -2.575f)
            curveToRelative(0f, -0.533f, -0.133f, -0.996f, -0.4f, -1.388f)
            reflectiveCurveToRelative(-0.617f, -0.754f, -1.05f, -1.087f)
            curveToRelative(-0.233f, -0.167f, -0.483f, -0.25f, -0.75f, -0.25f)
            reflectiveCurveToRelative(-0.492f, 0.1f, -0.675f, 0.3f)
            reflectiveCurveToRelative(-0.275f, 0.446f, -0.275f, 0.738f)
            reflectiveCurveToRelative(0.117f, 0.521f, 0.35f, 0.688f)
            curveToRelative(0.233f, 0.183f, 0.425f, 0.35f, 0.575f, 0.5f)
            reflectiveCurveToRelative(0.225f, 0.317f, 0.225f, 0.5f)
            curveToRelative(0f, 0.383f, -0.304f, 0.729f, -0.913f, 1.038f)
            reflectiveCurveToRelative(-1.304f, 0.463f, -2.088f, 0.463f)
            curveToRelative(-0.283f, 0f, -0.521f, 0.096f, -0.712f, 0.287f)
            reflectiveCurveToRelative(-0.287f, 0.429f, -0.287f, 0.712f)
            reflectiveCurveToRelative(0.096f, 0.521f, 0.287f, 0.712f)
            reflectiveCurveToRelative(0.429f, 0.287f, 0.712f, 0.287f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(9f, 6f)
            curveToRelative(0f, 0.233f, -0.146f, 0.446f, -0.438f, 0.637f)
            reflectiveCurveToRelative(-0.962f, 0.529f, -2.013f, 1.013f)
            curveToRelative(-1.333f, 0.583f, -2.258f, 1.112f, -2.775f, 1.587f)
            reflectiveCurveToRelative(-0.775f, 1.063f, -0.775f, 1.763f)
            curveToRelative(0f, 0.433f, 0.1f, 0.817f, 0.3f, 1.15f)
            reflectiveCurveToRelative(0.458f, 0.625f, 0.775f, 0.875f)
            curveToRelative(0.217f, 0.183f, 0.458f, 0.262f, 0.725f, 0.237f)
            reflectiveCurveToRelative(0.492f, -0.146f, 0.675f, -0.363f)
            curveToRelative(0.183f, -0.217f, 0.267f, -0.458f, 0.25f, -0.725f)
            reflectiveCurveToRelative(-0.133f, -0.492f, -0.35f, -0.675f)
            curveToRelative(-0.117f, -0.083f, -0.208f, -0.167f, -0.275f, -0.25f)
            reflectiveCurveToRelative(-0.1f, -0.167f, -0.1f, -0.25f)
            curveToRelative(0f, -0.2f, 0.15f, -0.4f, 0.45f, -0.6f)
            reflectiveCurveToRelative(0.933f, -0.508f, 1.9f, -0.925f)
            curveToRelative(1.467f, -0.633f, 2.442f, -1.208f, 2.925f, -1.725f)
            reflectiveCurveToRelative(0.725f, -1.1f, 0.725f, -1.75f)
            curveToRelative(0f, -0.917f, -0.367f, -1.646f, -1.1f, -2.188f)
            reflectiveCurveToRelative(-1.7f, -0.813f, -2.9f, -0.813f)
            curveToRelative(-0.75f, 0f, -1.421f, 0.133f, -2.013f, 0.4f)
            curveToRelative(-0.592f, 0.267f, -1.046f, 0.592f, -1.362f, 0.975f)
            curveToRelative(-0.183f, 0.217f, -0.258f, 0.458f, -0.225f, 0.725f)
            reflectiveCurveToRelative(0.158f, 0.483f, 0.375f, 0.65f)
            curveToRelative(0.217f, 0.183f, 0.458f, 0.258f, 0.725f, 0.225f)
            reflectiveCurveToRelative(0.492f, -0.142f, 0.675f, -0.325f)
            curveToRelative(0.233f, -0.233f, 0.492f, -0.4f, 0.775f, -0.5f)
            reflectiveCurveToRelative(0.633f, -0.15f, 1.05f, -0.15f)
            curveToRelative(0.683f, 0f, 1.188f, 0.1f, 1.513f, 0.3f)
            reflectiveCurveToRelative(0.488f, 0.433f, 0.488f, 0.7f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(21.85f, 5.638f)
            curveToRelative(-0.1f, -0.242f, -0.25f, -0.454f, -0.45f, -0.638f)
            lineToRelative(-1.4f, -1.4f)
            curveToRelative(-0.183f, -0.2f, -0.396f, -0.35f, -0.638f, -0.45f)
            curveToRelative(-0.242f, -0.1f, -0.496f, -0.15f, -0.763f, -0.15f)
            curveToRelative(-0.25f, 0f, -0.5f, 0.05f, -0.75f, 0.15f)
            curveToRelative(-0.25f, 0.1f, -0.475f, 0.25f, -0.675f, 0.45f)
            lineToRelative(-12.6f, 12.575f)
            curveToRelative(-0.183f, 0.183f, -0.325f, 0.396f, -0.425f, 0.638f)
            curveToRelative(-0.1f, 0.242f, -0.15f, 0.496f, -0.15f, 0.763f)
            verticalLineToRelative(2.425f)
            curveToRelative(0f, 0.283f, 0.096f, 0.521f, 0.287f, 0.712f)
            curveToRelative(0.192f, 0.192f, 0.429f, 0.288f, 0.713f, 0.288f)
            horizontalLineToRelative(2.425f)
            curveToRelative(0.267f, 0f, 0.521f, -0.05f, 0.763f, -0.15f)
            curveToRelative(0.242f, -0.1f, 0.454f, -0.242f, 0.638f, -0.425f)
            lineToRelative(12.575f, -12.6f)
            curveToRelative(0.2f, -0.2f, 0.35f, -0.425f, 0.45f, -0.675f)
            curveToRelative(0.1f, -0.25f, 0.15f, -0.5f, 0.15f, -0.75f)
            curveToRelative(0f, -0.267f, -0.05f, -0.521f, -0.15f, -0.762f)
            close()
            moveTo(7.4f, 19f)
            horizontalLineToRelative(-1.4f)
            verticalLineToRelative(-1.4f)
            lineTo(15.8f, 7.775f)
            lineToRelative(0.725f, 0.7f)
            lineToRelative(0.7f, 0.725f)
            lineToRelative(-9.825f, 9.8f)
            close()
        }
    }.build()
}