/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2025 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Rounded.DesignServices: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Rounded.DesignServices",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(352f, 438f)
            lineTo(438f, 351f)
            lineTo(382f, 294f)
            lineTo(338f, 338f)
            lineTo(282f, 282f)
            lineTo(325f, 238f)
            lineTo(280f, 193f)
            lineTo(193f, 280f)
            lineTo(352f, 438f)
            close()
            moveTo(680f, 767f)
            lineTo(767f, 680f)
            lineTo(722f, 635f)
            lineTo(678f, 678f)
            lineTo(622f, 622f)
            lineTo(665f, 578f)
            lineTo(608f, 522f)
            lineTo(522f, 608f)
            lineTo(680f, 767f)
            close()
            moveTo(649f, 257f)
            lineTo(705f, 313f)
            lineTo(761f, 257f)
            lineTo(704f, 200f)
            lineTo(649f, 257f)
            close()
            moveTo(290f, 840f)
            lineTo(120f, 840f)
            lineTo(120f, 670f)
            lineTo(295f, 495f)
            lineTo(80f, 280f)
            lineTo(280f, 80f)
            lineTo(496f, 296f)
            lineTo(647f, 144f)
            quadTo(659f, 132f, 674f, 126f)
            quadTo(689f, 120f, 705f, 120f)
            quadTo(721f, 120f, 736f, 126f)
            quadTo(751f, 132f, 763f, 144f)
            lineTo(816f, 198f)
            quadTo(828f, 210f, 834f, 225f)
            quadTo(840f, 240f, 840f, 256f)
            quadTo(840f, 272f, 834f, 286.5f)
            quadTo(828f, 301f, 816f, 313f)
            lineTo(665f, 465f)
            lineTo(880f, 680f)
            lineTo(680f, 880f)
            lineTo(465f, 665f)
            lineTo(290f, 840f)
            close()
        }
    }.build()
}

val Icons.TwoTone.DesignServices: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "TwoTone.DesignServices",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(17.6f, 5f)
            lineToRelative(1.425f, 1.425f)
            lineToRelative(-1.425f, -1.425f)
            close()
        }
        path(fill = SolidColor(Color.Black)) {
            moveTo(16.625f, 11.625f)
            lineToRelative(3.775f, -3.8f)
            curveToRelative(0.2f, -0.2f, 0.35f, -0.421f, 0.45f, -0.663f)
            curveToRelative(0.1f, -0.242f, 0.15f, -0.496f, 0.15f, -0.762f)
            reflectiveCurveToRelative(-0.05f, -0.525f, -0.15f, -0.775f)
            curveToRelative(-0.1f, -0.25f, -0.25f, -0.475f, -0.45f, -0.675f)
            lineToRelative(-1.325f, -1.35f)
            curveToRelative(-0.2f, -0.2f, -0.425f, -0.35f, -0.675f, -0.45f)
            curveToRelative(-0.25f, -0.1f, -0.508f, -0.15f, -0.775f, -0.15f)
            reflectiveCurveToRelative(-0.525f, 0.05f, -0.775f, 0.15f)
            curveToRelative(-0.25f, 0.1f, -0.475f, 0.25f, -0.675f, 0.45f)
            lineToRelative(-3.775f, 3.8f)
            lineTo(7f, 2f)
            lineTo(2f, 7f)
            lineToRelative(5.375f, 5.375f)
            lineToRelative(-4.375f, 4.375f)
            verticalLineToRelative(4.25f)
            horizontalLineToRelative(4.25f)
            lineToRelative(4.375f, -4.375f)
            lineToRelative(5.375f, 5.375f)
            lineToRelative(5f, -5f)
            lineToRelative(-5.375f, -5.375f)
            close()
            moveTo(4.825f, 7f)
            lineToRelative(2.175f, -2.175f)
            lineToRelative(1.125f, 1.125f)
            lineToRelative(-1.075f, 1.1f)
            lineToRelative(1.4f, 1.4f)
            lineToRelative(1.1f, -1.1f)
            lineToRelative(1.4f, 1.425f)
            lineToRelative(-2.15f, 2.175f)
            lineToRelative(-3.975f, -3.95f)
            close()
            moveTo(6.4f, 19f)
            horizontalLineToRelative(-1.4f)
            verticalLineToRelative(-1.4f)
            lineTo(14.775f, 7.8f)
            lineToRelative(1.425f, 1.425f)
            lineToRelative(-9.8f, 9.775f)
            close()
            moveTo(13.05f, 15.2f)
            lineToRelative(2.15f, -2.15f)
            lineToRelative(1.425f, 1.4f)
            lineToRelative(-1.075f, 1.1f)
            lineToRelative(1.4f, 1.4f)
            lineToRelative(1.1f, -1.075f)
            lineToRelative(1.125f, 1.125f)
            lineToRelative(-2.175f, 2.175f)
            lineToRelative(-3.95f, -3.975f)
            close()
        }
        path(fill = SolidColor(Color.Black)) {
            moveTo(15.5f, 8.525f)
            lineToRelative(-0.725f, -0.725f)
            lineToRelative(1.425f, 1.425f)
            lineToRelative(-0.7f, -0.7f)
            close()
        }
        path(
            fill = SolidColor(Color.Black),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(8.8f, 10.95f)
            lineToRelative(2.15f, -2.175f)
            lineToRelative(-1.4f, -1.425f)
            lineToRelative(-1.1f, 1.1f)
            lineToRelative(-1.4f, -1.4f)
            lineToRelative(1.075f, -1.1f)
            lineToRelative(-1.125f, -1.125f)
            lineToRelative(-2.175f, 2.175f)
            lineToRelative(3.975f, 3.95f)
            close()
        }
        path(
            fill = SolidColor(Color.Black),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(17f, 19.175f)
            lineToRelative(2.175f, -2.175f)
            lineToRelative(-1.125f, -1.125f)
            lineToRelative(-1.1f, 1.075f)
            lineToRelative(-1.4f, -1.4f)
            lineToRelative(1.075f, -1.1f)
            lineToRelative(-1.425f, -1.4f)
            lineToRelative(-2.15f, 2.15f)
            lineToRelative(3.95f, 3.975f)
            close()
        }
        path(
            fill = SolidColor(Color.Black),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(5f, 19f)
            lineToRelative(1.4f, 0f)
            lineToRelative(9.8f, -9.775f)
            lineToRelative(-1.425f, -1.425f)
            lineToRelative(-9.775f, 9.8f)
            lineToRelative(0f, 1.4f)
            close()
        }
    }.build()
}

val Icons.Outlined.DesignServices: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Outlined.DesignServices",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color.Black)) {
            moveTo(352f, 438f)
            lineTo(438f, 351f)
            lineTo(382f, 294f)
            lineTo(338f, 338f)
            lineTo(282f, 282f)
            lineTo(325f, 238f)
            lineTo(280f, 193f)
            lineTo(193f, 280f)
            lineTo(352f, 438f)
            close()
            moveTo(680f, 767f)
            lineTo(767f, 680f)
            lineTo(722f, 635f)
            lineTo(678f, 678f)
            lineTo(622f, 622f)
            lineTo(665f, 578f)
            lineTo(608f, 522f)
            lineTo(522f, 608f)
            lineTo(680f, 767f)
            close()
            moveTo(704f, 200f)
            lineTo(761f, 257f)
            lineTo(761f, 257f)
            lineTo(704f, 200f)
            close()
            moveTo(290f, 840f)
            lineTo(120f, 840f)
            lineTo(120f, 670f)
            lineTo(295f, 495f)
            lineTo(80f, 280f)
            lineTo(280f, 80f)
            lineTo(496f, 296f)
            lineTo(647f, 144f)
            quadTo(659f, 132f, 674f, 126f)
            quadTo(689f, 120f, 705f, 120f)
            quadTo(721f, 120f, 736f, 126f)
            quadTo(751f, 132f, 763f, 144f)
            lineTo(816f, 198f)
            quadTo(828f, 210f, 834f, 225f)
            quadTo(840f, 240f, 840f, 256f)
            quadTo(840f, 272f, 834f, 286.5f)
            quadTo(828f, 301f, 816f, 313f)
            lineTo(665f, 465f)
            lineTo(880f, 680f)
            lineTo(680f, 880f)
            lineTo(465f, 665f)
            lineTo(290f, 840f)
            close()
            moveTo(200f, 760f)
            lineTo(256f, 760f)
            lineTo(648f, 369f)
            lineTo(591f, 312f)
            lineTo(200f, 704f)
            lineTo(200f, 760f)
            close()
            moveTo(620f, 341f)
            lineTo(591f, 312f)
            lineTo(591f, 312f)
            lineTo(648f, 369f)
            lineTo(648f, 369f)
            lineTo(620f, 341f)
            close()
        }
    }.build()
}