/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2024 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Rounded.Crashlytics: ImageVector by lazy {
    Builder(
        name = "Crashlytics", defaultWidth = 24.0.dp, defaultHeight =
            24.0.dp, viewportWidth = 276.0f, viewportHeight = 276.0f
    ).apply {
        path(
            fill = SolidColor(Color(0xFF9B1B1D)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(115.637f, 54.539f)
            curveTo(115.637f, 54.539f, 115.636f, 29.056f, 115.706f, 18.677f)
            curveTo(115.783f, 7.471f, 122.854f, 0.407f, 133.949f, 0.374f)
            curveTo(144.848f, 0.341f, 155.747f, 0.342f, 166.646f, 0.374f)
            curveTo(177.628f, 0.405f, 184.719f, 7.384f, 184.745f, 18.306f)
            curveTo(184.795f, 39.585f, 184.763f, 60.864f, 184.752f, 82.143f)
            curveTo(184.751f, 83.264f, 184.626f, 84.384f, 184.531f, 85.969f)
            curveTo(164.491f, 74.365f, 144.042f, 72.644f, 123.252f, 82.272f)
            curveTo(107.71f, 89.469f, 96.94f, 101.464f, 91.214f, 117.64f)
            curveTo(79.796f, 149.899f, 97.261f, 185.336f, 129.91f, 196.39f)
            curveTo(163.792f, 207.86f, 202.118f, 189.008f, 211.618f, 150.299f)
            curveTo(212.59f, 151.109f, 244.73f, 182.672f, 259.843f, 197.651f)
            curveTo(268.055f, 205.79f, 268.042f, 215.538f, 259.865f, 223.673f)
            curveTo(252.415f, 231.086f, 244.941f, 238.476f, 237.449f, 245.846f)
            curveTo(229.122f, 254.036f, 219.251f, 254.069f, 210.983f, 245.944f)
            curveTo(203.487f, 238.578f, 184.663f, 220.176f, 184.663f, 220.176f)
            curveTo(184.663f, 220.176f, 184.815f, 246.647f, 184.743f, 257.416f)
            curveTo(184.673f, 267.888f, 177.571f, 274.994f, 167.134f, 275.051f)
            curveTo(155.976f, 275.113f, 144.817f, 275.104f, 133.659f, 275.054f)
            curveTo(123.009f, 275.008f, 115.847f, 267.956f, 115.719f, 257.243f)
            curveTo(115.596f, 246.865f, 115.69f, 220.393f, 115.69f, 220.393f)
            curveTo(115.69f, 220.393f, 97.538f, 238.619f, 90.13f, 245.89f)
            curveTo(81.808f, 254.058f, 71.98f, 254.059f, 63.664f, 245.904f)
            curveTo(56.253f, 238.636f, 48.868f, 231.342f, 41.498f, 224.032f)
            curveTo(32.917f, 215.52f, 32.948f, 205.998f, 41.368f, 197.458f)
            curveTo(49.551f, 189.158f, 66.505f, 171.787f, 66.505f, 171.787f)
            curveTo(66.505f, 171.787f, 39.662f, 171.832f, 28.374f, 171.774f)
            curveTo(16.755f, 171.715f, 10.067f, 164.983f, 10.029f, 153.365f)
            curveTo(9.994f, 142.855f, 9.986f, 132.345f, 10.032f, 121.835f)
            curveTo(10.081f, 110.499f, 16.825f, 103.738f, 28.222f, 103.662f)
            curveTo(39.25f, 103.589f, 66.644f, 103.644f, 66.644f, 103.644f)
            curveTo(66.644f, 103.644f, 48.143f, 85.149f, 40.516f, 77.547f)
            curveTo(32.688f, 69.744f, 32.622f, 59.87f, 40.378f, 52.11f)
            curveTo(48.175f, 44.31f, 56.007f, 36.545f, 63.91f, 28.852f)
            curveTo(71.35f, 21.611f, 81.62f, 21.541f, 88.948f, 28.901f)
            curveTo(97.447f, 37.436f, 115.637f, 54.539f, 115.637f, 54.539f)
        }
        path(
            fill = SolidColor(Color(0xFF9B1B1D)), stroke = null, strokeLineWidth = 0.0f,
            strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
            pathFillType = NonZero
        ) {
            moveTo(175.772f, 137.581f)
            curveTo(175.784f, 151.544f, 164.634f, 162.635f, 150.54f, 162.68f)
            curveTo(136.224f, 162.725f, 125.011f, 151.617f, 125.067f, 137.448f)
            curveTo(125.122f, 123.581f, 136.491f, 112.401f, 150.48f, 112.458f)
            curveTo(164.512f, 112.515f, 175.759f, 123.688f, 175.772f, 137.581f)
        }
    }
        .build()
}