/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2025 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Outlined.Collage: ImageVector by lazy {
    ImageVector.Builder(
        name = "Outlined.Collage",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 960f,
        viewportHeight = 960f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(120f, 520f)
            lineTo(120f, 200f)
            quadTo(120f, 167f, 143.5f, 143.5f)
            quadTo(167f, 120f, 200f, 120f)
            lineTo(440f, 120f)
            lineTo(440f, 520f)
            lineTo(120f, 520f)
            close()
            moveTo(360f, 440f)
            lineTo(360f, 440f)
            lineTo(360f, 440f)
            lineTo(360f, 440f)
            lineTo(360f, 440f)
            quadTo(360f, 440f, 360f, 440f)
            quadTo(360f, 440f, 360f, 440f)
            close()
            moveTo(520f, 120f)
            lineTo(760f, 120f)
            quadTo(793f, 120f, 816.5f, 143.5f)
            quadTo(840f, 167f, 840f, 200f)
            lineTo(840f, 360f)
            lineTo(520f, 360f)
            lineTo(520f, 120f)
            close()
            moveTo(520f, 840f)
            lineTo(520f, 440f)
            lineTo(840f, 440f)
            lineTo(840f, 760f)
            quadTo(840f, 793f, 816.5f, 816.5f)
            quadTo(793f, 840f, 760f, 840f)
            lineTo(520f, 840f)
            close()
            moveTo(120f, 600f)
            lineTo(440f, 600f)
            lineTo(440f, 840f)
            lineTo(200f, 840f)
            quadTo(167f, 840f, 143.5f, 816.5f)
            quadTo(120f, 793f, 120f, 760f)
            lineTo(120f, 600f)
            close()
            moveTo(360f, 680f)
            lineTo(360f, 680f)
            lineTo(360f, 680f)
            lineTo(360f, 680f)
            lineTo(360f, 680f)
            quadTo(360f, 680f, 360f, 680f)
            quadTo(360f, 680f, 360f, 680f)
            close()
            moveTo(600f, 280f)
            lineTo(600f, 280f)
            lineTo(600f, 280f)
            lineTo(600f, 280f)
            lineTo(600f, 280f)
            quadTo(600f, 280f, 600f, 280f)
            quadTo(600f, 280f, 600f, 280f)
            close()
            moveTo(600f, 520f)
            quadTo(600f, 520f, 600f, 520f)
            quadTo(600f, 520f, 600f, 520f)
            lineTo(600f, 520f)
            lineTo(600f, 520f)
            lineTo(600f, 520f)
            close()
            moveTo(200f, 440f)
            lineTo(360f, 440f)
            lineTo(360f, 200f)
            lineTo(200f, 200f)
            quadTo(200f, 200f, 200f, 200f)
            quadTo(200f, 200f, 200f, 200f)
            lineTo(200f, 440f)
            close()
            moveTo(600f, 280f)
            lineTo(760f, 280f)
            lineTo(760f, 200f)
            quadTo(760f, 200f, 760f, 200f)
            quadTo(760f, 200f, 760f, 200f)
            lineTo(600f, 200f)
            lineTo(600f, 280f)
            close()
            moveTo(600f, 520f)
            lineTo(600f, 760f)
            lineTo(760f, 760f)
            quadTo(760f, 760f, 760f, 760f)
            quadTo(760f, 760f, 760f, 760f)
            lineTo(760f, 520f)
            lineTo(600f, 520f)
            close()
            moveTo(200f, 680f)
            lineTo(200f, 760f)
            quadTo(200f, 760f, 200f, 760f)
            quadTo(200f, 760f, 200f, 760f)
            lineTo(360f, 760f)
            lineTo(360f, 680f)
            lineTo(200f, 680f)
            close()
        }
    }.build()
}

val Icons.TwoTone.Collage: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "TwoTone.Collage",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(9f, 11f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(9f, 17f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(15f, 7f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(15f, 13f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            close()
        }
        path(
            fill = SolidColor(Color(0xFF000000)),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(5f, 11f)
            lineToRelative(4f, 0f)
            lineToRelative(0f, -6f)
            lineToRelative(-4f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 6f)
            close()
        }
        path(
            fill = SolidColor(Color(0xFF000000)),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(15f, 7f)
            lineToRelative(4f, 0f)
            lineToRelative(0f, -2f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(-4f, 0f)
            lineToRelative(0f, 2f)
            close()
        }
        path(
            fill = SolidColor(Color(0xFF000000)),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(15f, 13f)
            lineToRelative(0f, 6f)
            lineToRelative(4f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, -6f)
            lineToRelative(-4f, 0f)
            close()
        }
        path(
            fill = SolidColor(Color(0xFF000000)),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(5f, 17f)
            lineToRelative(0f, 2f)
            lineToRelative(0f, 0f)
            lineToRelative(0f, 0f)
            lineToRelative(4f, 0f)
            lineToRelative(0f, -2f)
            lineToRelative(-4f, 0f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(5f, 3f)
            curveToRelative(-0.55f, 0f, -1.021f, 0.196f, -1.412f, 0.587f)
            reflectiveCurveToRelative(-0.588f, 0.863f, -0.588f, 1.413f)
            verticalLineToRelative(8f)
            horizontalLineToRelative(8f)
            verticalLineTo(3f)
            horizontalLineToRelative(-6f)
            close()
            moveTo(9f, 11f)
            horizontalLineToRelative(-4f)
            verticalLineToRelative(-6f)
            horizontalLineToRelative(4f)
            verticalLineToRelative(6f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(20.412f, 3.587f)
            curveToRelative(-0.392f, -0.392f, -0.862f, -0.587f, -1.412f, -0.587f)
            horizontalLineToRelative(-6f)
            verticalLineToRelative(6f)
            horizontalLineToRelative(8f)
            verticalLineToRelative(-4f)
            curveToRelative(0f, -0.55f, -0.196f, -1.021f, -0.588f, -1.413f)
            close()
            moveTo(19f, 7f)
            horizontalLineToRelative(-4f)
            verticalLineToRelative(-2f)
            horizontalLineToRelative(4f)
            verticalLineToRelative(2f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(13f, 11f)
            verticalLineToRelative(10f)
            horizontalLineToRelative(6f)
            curveToRelative(0.55f, 0f, 1.021f, -0.196f, 1.412f, -0.588f)
            reflectiveCurveToRelative(0.588f, -0.862f, 0.588f, -1.412f)
            verticalLineToRelative(-8f)
            horizontalLineToRelative(-8f)
            close()
            moveTo(19f, 19f)
            horizontalLineToRelative(-4f)
            verticalLineToRelative(-6f)
            horizontalLineToRelative(4f)
            verticalLineToRelative(6f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(3f, 15f)
            verticalLineToRelative(4f)
            curveToRelative(0f, 0.55f, 0.196f, 1.021f, 0.588f, 1.412f)
            reflectiveCurveToRelative(0.862f, 0.588f, 1.412f, 0.588f)
            horizontalLineToRelative(6f)
            verticalLineToRelative(-6f)
            horizontalLineTo(3f)
            close()
            moveTo(9f, 19f)
            horizontalLineToRelative(-4f)
            verticalLineToRelative(-2f)
            horizontalLineToRelative(4f)
            verticalLineToRelative(2f)
            close()
        }
    }.build()
}