/*
 * ImageToolbox is an image editor for android
 * Copyright (c) 2024 T8RIN (Malik Mukhametzyanov)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * You should have received a copy of the Apache License
 * along with this program.  If not, see <http://www.apache.org/licenses/LICENSE-2.0>.
 */

package com.t8rin.imagetoolbox.core.resources.icons

import androidx.compose.material.icons.Icons
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Icons.Rounded.Base64: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Rounded.Base64",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(22f, 10.889f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(-2.222f)
            curveToRelative(0f, -1.227f, -0.995f, -2.222f, -2.222f, -2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(-2.222f)
            curveToRelative(-1.227f, 0f, -2.222f, 0.995f, -2.222f, 2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(2.222f)
            curveToRelative(0f, 1.227f, 0.995f, 2.222f, 2.222f, 2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(2.222f)
            curveToRelative(1.227f, 0f, 2.222f, -0.995f, 2.222f, -2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(2.222f)
            close()
            moveTo(11.523f, 10.57f)
            horizontalLineToRelative(-2.86f)
            verticalLineToRelative(0.715f)
            horizontalLineToRelative(1.906f)
            curveToRelative(0.526f, 0f, 0.953f, 0.427f, 0.953f, 0.953f)
            verticalLineToRelative(1.668f)
            curveToRelative(0f, 0.526f, -0.427f, 0.953f, -0.953f, 0.953f)
            horizontalLineToRelative(-2.383f)
            curveToRelative(-0.526f, 0f, -0.953f, -0.427f, -0.953f, -0.953f)
            verticalLineToRelative(-3.813f)
            curveToRelative(0f, -0.526f, 0.427f, -0.953f, 0.953f, -0.953f)
            horizontalLineToRelative(3.336f)
            verticalLineToRelative(1.43f)
            close()
            moveTo(16.766f, 14.86f)
            horizontalLineToRelative(-1.43f)
            verticalLineToRelative(-2.383f)
            horizontalLineToRelative(-2.86f)
            verticalLineToRelative(-3.336f)
            horizontalLineToRelative(1.43f)
            verticalLineToRelative(1.906f)
            horizontalLineToRelative(1.43f)
            verticalLineToRelative(-1.906f)
            horizontalLineToRelative(1.43f)
            verticalLineToRelative(5.719f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(8.664f, 12.715f)
            horizontalLineToRelative(1.43f)
            verticalLineToRelative(0.715f)
            horizontalLineToRelative(-1.43f)
            close()
        }
    }.build()
}

val Icons.Outlined.Base64: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "Outlined.Base64",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(22f, 10.889f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(-2.222f)
            curveToRelative(0f, -1.227f, -0.995f, -2.222f, -2.222f, -2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(-2.222f)
            curveToRelative(-1.227f, 0f, -2.222f, 0.995f, -2.222f, 2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(2.222f)
            curveToRelative(0f, 1.227f, 0.995f, 2.222f, 2.222f, 2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(2.222f)
            curveToRelative(1.227f, 0f, 2.222f, -0.995f, 2.222f, -2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(2.222f)
            close()
            moveTo(17.852f, 17.235f)
            curveToRelative(0f, 0.341f, -0.276f, 0.618f, -0.618f, 0.618f)
            horizontalLineTo(6.765f)
            curveToRelative(-0.341f, 0f, -0.618f, -0.276f, -0.618f, -0.618f)
            verticalLineTo(6.765f)
            curveToRelative(0f, -0.341f, 0.276f, -0.618f, 0.618f, -0.618f)
            horizontalLineToRelative(10.469f)
            curveToRelative(0.341f, 0f, 0.618f, 0.276f, 0.618f, 0.618f)
            verticalLineToRelative(10.469f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(12.477f, 9.14f)
            lineToRelative(1.43f, 0f)
            lineToRelative(0f, 1.906f)
            lineToRelative(1.43f, 0f)
            lineToRelative(0f, -1.906f)
            lineToRelative(1.43f, 0f)
            lineToRelative(0f, 5.719f)
            lineToRelative(-1.43f, 0f)
            lineToRelative(0f, -2.383f)
            lineToRelative(-2.86f, 0f)
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(11.523f, 10.57f)
            verticalLineToRelative(-1.43f)
            horizontalLineToRelative(-3.336f)
            curveToRelative(-0.526f, 0f, -0.953f, 0.427f, -0.953f, 0.953f)
            verticalLineToRelative(3.813f)
            curveToRelative(0f, 0.526f, 0.427f, 0.953f, 0.953f, 0.953f)
            horizontalLineToRelative(2.383f)
            curveToRelative(0.526f, 0f, 0.953f, -0.427f, 0.953f, -0.953f)
            verticalLineToRelative(-1.668f)
            curveToRelative(0f, -0.526f, -0.427f, -0.953f, -0.953f, -0.953f)
            horizontalLineToRelative(-1.906f)
            verticalLineToRelative(-0.715f)
            horizontalLineToRelative(2.86f)
            close()
            moveTo(10.094f, 12.715f)
            verticalLineToRelative(0.715f)
            horizontalLineToRelative(-1.43f)
            verticalLineToRelative(-0.715f)
            horizontalLineToRelative(1.43f)
            close()
        }
    }.build()
}

val Icons.TwoTone.Base64: ImageVector by lazy(LazyThreadSafetyMode.NONE) {
    ImageVector.Builder(
        name = "TwoTone.Base64",
        defaultWidth = 24.dp,
        defaultHeight = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f
    ).apply {
        path(
            fill = SolidColor(Color(0xFF000000)),
            fillAlpha = 0.3f,
            strokeAlpha = 0.3f
        ) {
            moveTo(6.765f, 6.148f)
            lineTo(17.235f, 6.148f)
            arcTo(0.618f, 0.618f, 0f, isMoreThanHalf = false, isPositiveArc = true, 17.852f, 6.765f)
            lineTo(17.852f, 17.235f)
            arcTo(
                0.618f,
                0.618f,
                0f,
                isMoreThanHalf = false,
                isPositiveArc = true,
                17.235f,
                17.852f
            )
            lineTo(6.765f, 17.852f)
            arcTo(0.618f, 0.618f, 0f, isMoreThanHalf = false, isPositiveArc = true, 6.148f, 17.235f)
            lineTo(6.148f, 6.765f)
            arcTo(0.618f, 0.618f, 0f, isMoreThanHalf = false, isPositiveArc = true, 6.765f, 6.148f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(12.477f, 9.14f)
            lineToRelative(1.43f, 0f)
            lineToRelative(0f, 1.906f)
            lineToRelative(1.43f, 0f)
            lineToRelative(0f, -1.906f)
            lineToRelative(1.43f, 0f)
            lineToRelative(0f, 5.719f)
            lineToRelative(-1.43f, 0f)
            lineToRelative(0f, -2.383f)
            lineToRelative(-2.86f, 0f)
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(11.523f, 10.57f)
            verticalLineToRelative(-1.43f)
            horizontalLineToRelative(-3.336f)
            curveToRelative(-0.526f, 0f, -0.953f, 0.427f, -0.953f, 0.953f)
            verticalLineToRelative(3.813f)
            curveToRelative(0f, 0.526f, 0.427f, 0.953f, 0.953f, 0.953f)
            horizontalLineToRelative(2.383f)
            curveToRelative(0.526f, 0f, 0.953f, -0.427f, 0.953f, -0.953f)
            verticalLineToRelative(-1.668f)
            curveToRelative(0f, -0.526f, -0.427f, -0.953f, -0.953f, -0.953f)
            horizontalLineToRelative(-1.906f)
            verticalLineToRelative(-0.715f)
            horizontalLineToRelative(2.86f)
            close()
            moveTo(10.094f, 12.715f)
            verticalLineToRelative(0.715f)
            horizontalLineToRelative(-1.43f)
            verticalLineToRelative(-0.715f)
            horizontalLineToRelative(1.43f)
            close()
        }
        path(fill = SolidColor(Color(0xFF000000))) {
            moveTo(22f, 10.889f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(-2.222f)
            curveToRelative(0f, -1.227f, -0.995f, -2.222f, -2.222f, -2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(-2.222f)
            curveToRelative(-1.227f, 0f, -2.222f, 0.995f, -2.222f, 2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(2.222f)
            curveToRelative(0f, 1.227f, 0.995f, 2.222f, 2.222f, 2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(2.222f)
            curveToRelative(1.227f, 0f, 2.222f, -0.995f, 2.222f, -2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(-2.222f)
            verticalLineToRelative(-2.222f)
            horizontalLineToRelative(2.222f)
            close()
            moveTo(17.852f, 17.235f)
            curveToRelative(0f, 0.341f, -0.276f, 0.618f, -0.618f, 0.618f)
            horizontalLineTo(6.765f)
            curveToRelative(-0.341f, 0f, -0.618f, -0.276f, -0.618f, -0.618f)
            verticalLineTo(6.765f)
            curveToRelative(0f, -0.341f, 0.276f, -0.618f, 0.618f, -0.618f)
            horizontalLineToRelative(10.469f)
            curveToRelative(0.341f, 0f, 0.618f, 0.276f, 0.618f, 0.618f)
            verticalLineToRelative(10.469f)
            close()
        }
    }.build()
}