package ru.stersh.youamp.core.ui

import androidx.compose.foundation.lazy.LazyListState
import androidx.compose.foundation.lazy.grid.LazyGridState
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.derivedStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.snapshotFlow

@Composable
fun LazyGridState.OnBottomReached(loadMore: () -> Unit) {
    val shouldLoadMore =
        remember {
            derivedStateOf {
                val lastVisibleItem =
                    layoutInfo.visibleItemsInfo.lastOrNull()
                        ?: return@derivedStateOf true

                lastVisibleItem.index == layoutInfo.totalItemsCount - 1
            }
        }

    LaunchedEffect(shouldLoadMore) {
        snapshotFlow { shouldLoadMore.value }
            .collect { loadMore ->
                if (loadMore) {
                    loadMore()
                }
            }
    }
}

@Composable
fun LazyListState.OnBottomReached(loadMore: () -> Unit) {
    val shouldLoadMore =
        remember {
            derivedStateOf {
                val lastVisibleItem =
                    layoutInfo.visibleItemsInfo.lastOrNull()
                        ?: return@derivedStateOf true

                lastVisibleItem.index == layoutInfo.totalItemsCount - 1
            }
        }

    LaunchedEffect(shouldLoadMore) {
        snapshotFlow { shouldLoadMore.value }
            .collect { loadMore ->
                if (loadMore) {
                    loadMore()
                }
            }
    }
}
