plugins {
    alias(libs.plugins.kotlin.multiplatform)
    alias(libs.plugins.android.kotlinMultiplatformLibrary)
    alias(libs.plugins.ksp)
}

kotlin {
    androidLibrary {
        namespace = "ru.stresh.youamp.db"
        compileSdk =
            libs.versions.android.compileSdk
                .get()
                .toInt()
        minSdk =
            libs.versions.android.minSdk
                .get()
                .toInt()
    }

    listOf(
        iosX64(),
        iosArm64(),
        iosSimulatorArm64(),
    ).forEach {
        it.binaries.framework {
            baseName = "dbKit"
        }
    }

    jvm("desktop")

    sourceSets {
        commonMain {
            dependencies {
                api(libs.room.core)
                implementation(libs.androidx.sqlite.bundled)
                implementation(libs.koin.core)
            }
        }

        commonTest {
            dependencies {
                implementation(libs.kotlin.test)
            }
        }
    }
}

dependencies {
    add(
        "kspAndroid",
        libs.room.compiler,
    )
    add(
        "kspIosSimulatorArm64",
        libs.room.compiler,
    )
    add(
        "kspIosX64",
        libs.room.compiler,
    )
    add(
        "kspIosArm64",
        libs.room.compiler,
    )
    add(
        "kspDesktop",
        libs.room.compiler,
    )
}
