import 'package:flutter/material.dart';

class Rules extends StatelessWidget {
  const Rules({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          title: const Text('Шляпа'),
        ),
        body: Padding(
          padding: const EdgeInsets.all(12),
          child: ListView(children: const [
            Card(
                child: ListTile(
                    title: Text('Цель игры\n',
                        style: TextStyle(fontWeight: FontWeight.bold)),
                    subtitle: Text(
                        'За ограниченное время объяснить партнёру как можно больше слов.',
                        style: TextStyle(color: Colors.black)))),
            Card(
                child: ListTile(
                    title: Text('Общий ход игры\n',
                        style: TextStyle(fontWeight: FontWeight.bold)),
                    subtitle: Text(
                        'Игроки садятся вокруг стола (обычно — 6-10 человек). В шляпе находится некоторое количество слов; игроки этих слов не знают. В каждый момент времени играют два человека — объясняющий и отгадывающий, остальные игроки ждут своей очереди и слушают. Объясняющий игрок при начале хода, читает написанное на экране слово (про себя) и объясняет это слово отгадывающему игроку, не используя слова, однокоренные загаданному. Отгадывающий игрок предлагает версии до тех пор, пока не назовёт загаданное слово. После этого объясняющий нажимает "Угадано" и объясняет следующее слово. Отгаданные слова в шляпу не возвращаются. По истечении времени ход заканчивается. Если слово не отгадано, то слово возвращается в шляпу, остальным игрокам слово не показывается. После этого ход переходит к следующему по часовой стрелке игроку.',
                        style: TextStyle(color: Colors.black)))),
            Card(
                child: Column(children: [
              ListTile(
                  title: Text('Разновидности игры\n',
                      style: TextStyle(fontWeight: FontWeight.bold)),
                  subtitle: Text(
                      'Игра может происходить в двух форматах: парном и личном.',
                      style: TextStyle(color: Colors.black))),
              ListTile(
                  title: Text('А. Парная игра\n',
                      style: TextStyle(fontWeight: FontWeight.bold)),
                  subtitle: Text(
                      'При парной игре, как чаще всего и играют в компаниях, все игроки разбиваются на пары (поэтому число играющих обязательно должно быть чётным). Игроки каждой пары садятся друг напротив друга, чтобы не было путаницы со сменой игроков. Каждый игрок объясняет слова только своему партнёру. Каждая пара получает столько очков, сколько слов она отгадала.',
                      style: TextStyle(color: Colors.black))),
              ListTile(
                  title: Text('B. Личная игра\n',
                      style: TextStyle(fontWeight: FontWeight.bold)),
                  subtitle: Text(
                      'При игре в личном зачёте каждый игрок объясняет слова разным игрокам. За каждое загаданное и за каждое отгаданное слово игрок получает по очку. Оптимальная схема для личной игры — когда каждый загадывает слова каждому по одному разу. Добавлять игроков в игру для удобства стоит в порядке рассадки.',
                      style: TextStyle(color: Colors.black)))
            ])),
            Card(
                child: Column(children: [
              ListTile(
                title: Text('Частности\n',
                    style: TextStyle(fontWeight: FontWeight.bold)),
                subtitle: Text(
                    'A. Загадываемые слова — существительные нарицательные в единственном числе (если оно есть; «ножницы» и т.п. загадывать можно). Слово считается отгаданным, если отгадывающий произнёс его в любой форме (например, «Мама мыла…» — «Раму», если загадано «Рама»). Слово считается отгаданным, если отгадывающий произнёс слово, звучащее так же, как написанное на бумажке, так называемый омофон (например, «Такой с колчаном» — «Лук», если загадано «Луг»). Можно также совмещать эти правила (например, «Я вступаю в…» — «Брак», если загадано «Брага»).\n\nB. Объясняющему запрещено произносить слова, однокоренные загаданному слову (в случаях сомнения по поводу однокоренности слов можно воспользоваться викисловарем https://ru.wiktionary.org/ (а именно, разбором слова по составу и разделом «родственные слова»)). Слова, имеющие ту же приставку или суффикс, что и загаданное, произносить можно, не сообщая при этом, что у загаданного слова такая же приставка или суффикс. Объясняющему запрещено произносить аббревиатуры, одна из букв которых обозначает загаданное слово (например, нельзя говорить «МГУ» для «Университет»).\n\nC. Объясняющему запрещено произносить слова, созвучные загаданному слову (а также слова, имеющие общие морфемы с загаданным), сообщая явно или намекая при этом (например, выделяя интонацией), что слова созвучны (или имеют общие морфемы, например, «большезга»). Объясняющему запрещено произносить слова, не существующие в русском языке, если такие слова вместе с загаданным и, возможно, дополнительными буквами образуют существующее слово. Например, нельзя сказать «птеро…» (для «дактиля») — так как вместе они образуют «птеродактиль», а также «бомбо…» (для «убежища») — так как вместе они образуют «бомбоубежище».\n\nD. Объясняющий не может никаким образом апеллировать к буквам и слогам загаданного слова («первая буква – такая же, как и у …», «убери последние четыре буквы», «слово из трёх слогов» и т.п.). В частности, нельзя загадывать слова, прямо называя их анаграммы (например, «анаграмма от слова рост» нельзя, а «анаграмма к слову, обозначающему высоту» можно). Также запрещено апеллировать к начертанию буквы («круглая приставка», «в середине как крест»). Однако разрешено апеллировать к частям слова, не уточняя их размер («измени начало слова», «середина – как у слова, которое …»), а также к морфемам («измени окончание», «возьми приставку, как у моей фамилии»)\n\nE. Также запрещено при объяснении передавать любую информацию мимикой или жестами.\n\nF. При объяснении слова нельзя пользоваться переводами в случае, если одного из слов (сказанного объясняющим или его перевода) нет в русском языке с тем же значением. Это включает случаи и без явной апелляции к переводу на заданный язык. Например: нельзя говорить «хенд по-русски», «солнце по-английски» (загаданы рука и сан), «она длинная» (загадан шезлонг).Однако, если иностранное слово заимствованием перешло в русский язык, называть его можно: «рефрижератор по-простому», «установка по-английски». Если загадано иностранное слово, допускается говорить, из какого языка оно заимствовано, и произносить перевод: «любослов по-гречески». Также это правило действует в отношении объясняемых приставок и корней иностранного происхождения.\n\nG. Если слово загадывается не через смысл, а по созвучию или по частям, то к объяснению любого из вспомогательных слов также относятся ограничения B-F.\n\nH. Если объясняющий называет однокоренное с загаданным слово или иным образом нарушает правила B-F, он нажимает "Ошибка" (слово удаляется из шляпы) и передаёт ход следующему игроку. Если факт нарушения фиксируется после окончания хода, то слова, загаданные с нарушением или после него, не засчитываются.\n\nI. Если отгадывающий называет слово, однокоренное загаданному, слово ещё не считается отгаданным. При этом объясняющий может сообщить о том, что загадано однокоренное слово, и попросить уточнить слово.\n\nJ. Объясняющий, отчаявшийся объяснить вытянутое слово, может вернуть слово в шляпу, нажав кнопку "Сдаться" и досрочно закончить объяснение. Заменить слово на другое не разрешается.\n\nK. Время, отведённое на загадывание слов каждой парой игроков, — 20 секунд. По истечении этого времени объясняющий перестаёт объяснять, а у отгадывающего есть ещё 3 секунды и одно слово на то, чтобы дать ответ, после чего ответы больше не принимаются. Если загадывающий не смог остановиться по истечении времени, право трёх секунд отгадывающему не даётся.\n\nL. Игроки, не загадывающие и не отгадывающие слово в данный момент, не должны ни мешать, ни помогать играющей паре . Не допускается никаким образом обсуждать ещё не отгаданные слова.\n\n',
                    style: TextStyle(color: Colors.black)),
              ),
            ]))
          ]),
        ));
  }
}
