# flutter_highlight

[![pub](https://img.shields.io/pub/v/flutter_highlight)](https://pub.dev/packages/flutter_highlight)

Syntax highlighter for Flutter. https://git-touch.github.io/highlight/

## Usage

```dart
import 'package:flutter/material.dart';
import 'package:flutter_highlight/flutter_highlight.dart';
import 'package:flutter_highlight/themes/github.dart';

class MyWidget extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    var code = '''main() {
  print("Hello, World!");
}
''';

    return HighlightView(
      // The original code to be highlighted
      code,

      // Specify language
      // It is recommended to give it a value for performance
      language: 'dart',

      // Specify highlight theme
      // All available themes are listed in `themes` folder
      theme: githubTheme,

      // Specify padding
      padding: EdgeInsets.all(12),

      // Specify text style
      textStyle: TextStyle(
        fontFamily: 'My awesome monospace font',
        fontSize: 16,
      ),
    );
  }
}
```

### Background processing

Processing large amounts of text can be slow. To perform text processing in the background, add a
`HighlightBackgroundEnvironment` above any `HighlightView`s in your widget tree.

A background isolate will be automatically started in `HighlightBackgroundEnvironment.initState`, and stopped in
`HighlightBackgroundEnvironment.dispose`.

## References

- [All available languages](https://github.com/pd4d10/highlight/tree/master/highlight/lib/languages)
- [All available themes](https://github.com/pd4d10/highlight/blob/master/flutter_highlight/lib/themes)

## License

MIT


## Credits

Original author
- [pd4d10](https://github.com/pd4d10)

For improvements (background processing)
- [hacker1024](https://github.com/hacker1024)