import 'package:injectable/injectable.dart';

import '../../core/component/http/http.dart';
import '../exception/exception.dart';

abstract interface class ProfileService {
  Future<Map<String, dynamic>?> fetchMe();

  Future<Map<String, dynamic>> fetchUpdates();
}

@Singleton(as: ProfileService)
class ProfileServiceImpl implements ProfileService {
  const ProfileServiceImpl({
    @Named('siteClient') required HttpClient siteClient,
    @Named('mobileClient') required HttpClient mobileClient,
  }) : _siteClient = siteClient,
       _mobileClient = mobileClient;

  final HttpClient _siteClient;
  final HttpClient _mobileClient;

  @override
  Future<Map<String, dynamic>?> fetchMe() async {
    try {
      final response = await _mobileClient.get('/me');

      return response.data;
    } catch (e, trace) {
      Error.throwWithStackTrace(const FetchException(), trace);
    }
  }

  @override
  Future<Map<String, dynamic>> fetchUpdates() async {
    try {
      final response = await _siteClient.get('/v2/me/updates');

      return response.data;
    } catch (e, trace) {
      Error.throwWithStackTrace(const FetchException(), trace);
    }
  }
}
