// SPDX-License-Identifier: GPL-3.0-only

import 'package:flutter/material.dart';

import 'constants.dart';

/// Title text with standard font/spacing etc for use in tables **other than** local playlists.
class StandardTableTitle extends StatelessWidget {
  const StandardTableTitle(
    this.name, {
    super.key,
  });

  final String name;

  @override
  Widget build(BuildContext context) {
    return SizedBox(
      height: BS.playlistHeaderTopRowHeight,
      child: Padding(
        padding: EdgeInsets.only(
          left: BS.paddingMedium,
        ),
        child: Align(
            alignment: Alignment.centerLeft,
            child: IgnorePointer(
              child: Text(
                name,
                overflow: TextOverflow.ellipsis,
                style: const TextStyle(
                  fontSize: BS.fontSizeHeading,
                ),
              ),
            )),
      ),
    );
  }
}
