// SPDX-License-Identifier: GPL-3.0-only

import 'package:flutter/material.dart';

class BlockFadeDecoratedContainer extends StatelessWidget {
  const BlockFadeDecoratedContainer({super.key, required this.child, this.color = Colors.red});

  final Widget child;
  final Color color;

  @override
  Widget build(BuildContext context) {
    return Stack(
      children: [
        Positioned.fill(
          child: IgnorePointer(
            child: Container(
              decoration: BoxDecoration(
                gradient: LinearGradient(
                  begin: Alignment.topCenter,
                  end: Alignment.bottomCenter,
                  colors: <Color>[
                    color.withValues(alpha: 0),
                    color.withValues(alpha: 0),
                    color.withValues(alpha: 0.25),
                    color.withValues(alpha: 0.25),
                    color.withValues(alpha: 0.5),
                    color.withValues(alpha: 0.5),
                    color.withValues(alpha: 1),
                    color.withValues(alpha: 1),
                  ],
                  stops: <double>[0, 0.2, 0.2, 0.4, 0.4, 0.6, 0.6, 1],
                ),
              ),
              //child: child,
            ),
          ),
        ),
        child,
      ],
    );
  }
}
