import com.android.build.gradle.internal.api.ApkVariantOutputImpl

plugins {
    id("com.android.application")
    id("kotlin-android")
    id("dev.flutter.flutter-gradle-plugin")
}

import java.util.Properties
import java.io.FileInputStream

// Load keystore properties
val keystoreProperties = Properties().apply {
    val keystoreFile = File(rootProject.projectDir, "key.properties")
    if (keystoreFile.exists()) {
        load(FileInputStream(keystoreFile))
    } else {
        println("key.properties not found at ${keystoreFile.absolutePath}")
    }
}

android {
    namespace = "rocks.mm_dev.BendyStraw"
    compileSdk = flutter.compileSdkVersion
    ndkVersion = flutter.ndkVersion

    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_17
        targetCompatibility = JavaVersion.VERSION_17
    }

    kotlinOptions {
        jvmTarget = "17"
    }

    defaultConfig {
        applicationId = "rocks.mm_dev.BendyStraw"
        minSdk = flutter.minSdkVersion
        targetSdk = flutter.targetSdkVersion
        versionCode = flutter.versionCode
        versionName = flutter.versionName
    }


    buildTypes {
        release {
            // Must minify/shrink otherwise F-Droid detects stub/unused Google classes in the
            // built apks.
            isMinifyEnabled = true
            isShrinkResources = true
            // Signal to gradle that standard Android shrinking/obfuscation should be used. The
            // `proguard-android-optimize.txt` file itself seems to be old/redundant but referencing
            // it like this triggers behaviour we want.
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }
}

flutter {
    source = "../.."
}

// For `--split-per-abi` builds, suffix `versionCode` with a single digit based on the ABI.
val abiCodes = mapOf("x86_64" to 1, "armeabi-v7a" to 2, "arm64-v8a" to 3)
android.applicationVariants.configureEach {
    val variant = this
    variant.outputs.forEach { output ->
        val abiVersionCode = abiCodes[output.filters.find { it.filterType == "ABI" }?.identifier]
        if (abiVersionCode != null) {
            (output as ApkVariantOutputImpl).versionCodeOverride = variant.versionCode * 10 + abiVersionCode
        }
    }
}
