// SPDX-License-Identifier: GPL-3.0-only

import 'dart:convert';

import 'package:crypto/crypto.dart';
import 'package:flutter/material.dart';

import 'constants.dart';

/// General helper/utility methods used in various places.

String getMd5Hash(Object? input) {
  String string = input.toString();
  return md5.convert(utf8.encode(string)).toString().substring(0, BS.hashIdLength);
}

String trimLeadingAndTrailingSlashes(String text) {
  while (text.endsWith('/')) {
    text = text.substring(0, text.length - 1);
  }
  while (text.startsWith('/')) {
    //AppState.debug("leading slash");
    text = text.substring(1);
  }
  return text;
}

Size measuredTextSize(context, text, textStyle) {
  return (TextPainter(
    text: TextSpan(
      text: text,
      style: textStyle,
    ),
    maxLines: 1,
    // ignore: deprecated_member_use
    textScaleFactor: MediaQuery.textScaleFactorOf(context),
    textDirection: TextDirection.ltr,
  )..layout())
      .size;
}

double paintedTextWidth(String text, TextStyle style) {
  TextPainter textPainter = TextPainter(
    text: TextSpan(
      text: text,
      style: style,
    ),
    textDirection: TextDirection.ltr,
    textAlign: TextAlign.center,
  );
  textPainter.layout();
  return textPainter.width;
}

List<Widget> spacedWidgets(
        {required Iterable<Widget> children, double horizontalGap = 0, double verticalGap = 0}) =>
    children
        .expand((item) sync* {
          yield SizedBox(width: horizontalGap, height: verticalGap);
          yield item;
        })
        .skip(1)
        .toList();

/// Given a list of [TextSpan] widgets, return a list of the same widgets with extra [TextSpan]s
/// inserted inbetween all of the original children, to act as spacers.
List<TextSpan> spacedTextSpan({required Iterable<TextSpan> children, String spacer = ' '}) =>
    children
        .expand((item) sync* {
          yield TextSpan(text: spacer);
          yield item;
        })
        .skip(1)
        .toList();
