// SPDX-License-Identifier: GPL-3.0-only

import 'package:flutter/material.dart';

import 'constants.dart';

/// A table cell specialised for showing the duration of a stream.
class TableCellDuration extends StatelessWidget {
  final dynamic value;
  final Map<String, dynamic> cellLayout;

  const TableCellDuration({
    super.key,
    required this.value,
    this.cellLayout = BS.tableCellLayoutStandard,
  });

  @override
  Widget build(BuildContext context) {
    return Align(
        alignment: Alignment.centerRight,
        child: Padding(
          padding: cellLayout['padding'],
          child: Text('${(Duration(seconds: value))}'.split('.')[0].padLeft(8, '0'),
              style: cellLayout['textStyle']),
        ));
  }
}
