// SPDX-License-Identifier: GPL-3.0-only

import 'package:flutter/material.dart';

import 'constants.dart';
import 'screen.dart';

class SmallIconButton extends StatelessWidget {
  const SmallIconButton({
    super.key,
    required this.iconData,
    this.hoverText,
    this.label,
    this.onPressed,
  });

  final String? hoverText;
  final String? label;
  final VoidCallback? onPressed;
  final IconData iconData;

  @override
  Widget build(BuildContext context) {
    final ButtonStyle buttonStyle = Screen.isCompact(context)
        ? BS.buttonStyleCompact
        : BS.buttonStyleStandard;
    final ColorScheme colorScheme = Theme.of(context).colorScheme;

    /// Matches colour of tappable header set in [TableWidget].
    late Color backgroundColor = Color.alphaBlend(
      colorScheme.primary.withValues(alpha: 0.07),
      colorScheme.surface,
    );
    final Color foregroundColor = colorScheme.primary;
    final Color foregroundColorDisabled = Color.alphaBlend(
      colorScheme.primary.withValues(alpha: BS.disableControlOpacity),
      colorScheme.surface,
    );
    final Color labelColor = Color.alphaBlend(
      colorScheme.primary.withValues(alpha: BS.tappableMildOpacity),
      colorScheme.surface,
    );

    return SizedBox(
      width: Screen.isCompact(context)
          ? BS.smallIconButtonWidthCompact
          : BS.smallIconButtonWidthStandard,
      child: Material(
        type: MaterialType.transparency,
        child: Tooltip(
          message: hoverText ?? '',
          child: Wrap(
            direction: Axis.vertical,
            crossAxisAlignment: WrapCrossAlignment.center,
            children: [
              ElevatedButton(
                style: buttonStyle.copyWith(
                  shape: WidgetStatePropertyAll(
                    RoundedRectangleBorder(
                      borderRadius: BorderRadius.circular(BS.cornerRadius),
                      //side: BorderSide(color: foregroundColorDisabled),
                    ),
                  ),
                  elevation: WidgetStatePropertyAll(0),
                  foregroundColor: WidgetStateProperty.resolveWith((states) {
                    return states.contains(WidgetState.disabled)
                        ? foregroundColorDisabled
                        : foregroundColor;
                  }),
                  backgroundColor: WidgetStatePropertyAll(backgroundColor),
                ),
                onPressed: onPressed,
                child: Icon(
                  iconData,
                  size: Screen.isCompact(context)
                      ? BS.buttonIconSizeCompact
                      : BS.buttonIconSizeStandard,
                ),
              ),
              if (label != null)
                TapRegion(
                  onTapInside: (onPressed == null)
                      ? null
                      : (PointerEvent event) {
                          onPressed!();
                        },
                  child: Text(
                    label!,
                    style: TextStyle(
                      color: (onPressed == null) ? foregroundColorDisabled : labelColor,
                      fontSize: BS.fontSizeExtraSmall,
                      fontWeight: FontWeight.bold,
                      letterSpacing: 0,
                    ),
                  ),
                ),
            ],
          ),
        ),
      ),
    );
  }
}
