// SPDX-License-Identifier: GPL-3.0-only

import 'package:BendyStraw/app_state.dart';
import 'package:flutter/material.dart';

import 'checkbox_labelled.dart';
import 'constants.dart';
import 'screen.dart';
import 'tooltip_icon_button.dart';

class SearchButtons extends StatelessWidget {
  const SearchButtons({
    super.key,
    required this.playlistName,
    this.searchFunction,
  });

  final Function? searchFunction;
  final String playlistName;

  @override
  Widget build(BuildContext context) {
    String searchTerms = AppState.get('${playlistName}-terms') ?? '';
    bool searchIncludeTitles = AppState.get('${playlistName}-includeTitles') ?? false;
    bool searchIncludeChannels = AppState.get('${playlistName}-includeChannels') ?? false;

    ColorScheme colorScheme = Theme.of(context).colorScheme;

    return Wrap(
      //mainAxisSize: MainAxisSize.min,
      crossAxisAlignment: WrapCrossAlignment.start,
      spacing: Screen.isCompact(context) ? BS.paddingMedium : BS.paddingExtraSmall,
      runSpacing: BS.paddingSmall,
      children: [
        Row(
          mainAxisSize: MainAxisSize.min,
          spacing: Screen.isCompact(context) ? BS.paddingMedium : BS.paddingExtraSmall,
          children: [
            CheckboxLabelled(
              labelText: 'Channels',
              value: searchIncludeChannels,
              onChanged: _searchToggleIncludeChannels,
            ),
            CheckboxLabelled(
              labelText: 'Titles',
              value: searchIncludeTitles,
              onChanged: _searchToggleIncludeTitles,
            ),
          ],
        ),
        Row(
          mainAxisSize: MainAxisSize.min,
          children: [
            Padding(
              padding: const EdgeInsets.only(top: BS.paddingSmall),
              child: TooltipIconButton(
                  text: 'Search',
                  iconData: Icons.search,
                  layout: TooltipIconButtonLayout.iconOnLeft,
                  backgroundColor: Color.alphaBlend(
                      colorScheme.primary.withValues(alpha: 0.07), colorScheme.surface),
                  onPressedCallback:
                      (searchTerms.isNotEmpty && (searchIncludeTitles || searchIncludeChannels))
                          ? () {
                              if (searchFunction != null) {
                                searchFunction!(searchTerms);
                              }
                            }
                          : null),
            ),
          ],
        ),
      ],
    );
  }

  void _searchToggleIncludeChannels(bool? newValue) {
    AppState.update('${playlistName}-includeChannels', (newValue ?? false), forceRebuild: true);
  }

  void _searchToggleIncludeTitles(bool? newValue) {
    AppState.update('${playlistName}-includeTitles', (newValue ?? false), forceRebuild: true);
  }
}
