// SPDX-License-Identifier: GPL-3.0-only

import 'package:flutter/material.dart';

import 'constants.dart';

class FloatingIconButton extends StatelessWidget {
  const FloatingIconButton({
    super.key,
    required this.iconData,
    required this.backgroundColor,
    required this.foregroundColor,
    this.onPressed,
    this.hoverText,
    this.label,
    this.borderRadius = const BorderRadius.only(
      topLeft: Radius.circular(BS.cornerButtonRadius),
      topRight: Radius.circular(BS.cornerButtonRadius),
    ),
  });

  final String? hoverText;
  final String? label;
  final IconData? iconData;
  final Color backgroundColor;
  final Color foregroundColor;
  final BorderRadius borderRadius;
  final VoidCallback? onPressed;

  @override
  Widget build(BuildContext context) {
    Color finalForegroundColor = Color.alphaBlend(
      foregroundColor.withValues(alpha: onPressed == null ? BS.disableControlOpacity : 1),
      backgroundColor,
    );

    Color labelColor = Color.alphaBlend(
      foregroundColor.withValues(
        alpha: onPressed == null ? BS.disableControlOpacity : BS.tappableMildOpacity,
      ),
      backgroundColor,
    );

    return Material(
      type: MaterialType.transparency,
      child: Tooltip(
        message: hoverText ?? '',
        child: Stack(
          children: [
            SizedBox(
              width: 70,
              height: 70,
              child: FittedBox(
                child: FloatingActionButton(
                  /// Required to allow more than one [FloatingIconButton] per screen.
                  heroTag: null,
                  shape: RoundedRectangleBorder(borderRadius: borderRadius),
                  backgroundColor: backgroundColor,
                  foregroundColor: finalForegroundColor,
                  elevation: BS.highButtonElevation,
                  disabledElevation: 3,
                  onPressed: onPressed,
                  child: Padding(
                    padding: const EdgeInsets.only(bottom: BS.paddingSmall),
                    child: Icon(iconData, color: finalForegroundColor),
                  ),
                ),
              ),
            ),
            if (label != null)
              Positioned.directional(
                textDirection: TextDirection.ltr,
                start: 0,
                end: 0,
                bottom: BS.paddingSmall,
                child: Text(
                  label!,
                  textAlign: TextAlign.center,
                  overflow: TextOverflow.ellipsis,
                  style: TextStyle(
                    color: labelColor,
                    fontSize: BS.fontSizeExtraSmall,
                    fontWeight: FontWeight.bold,
                    letterSpacing: 0,
                  ),
                ),
              ),
          ],
        ),
      ),
    );
  }
}
