// SPDX-License-Identifier: GPL-3.0-only

import 'package:flutter/material.dart';

import 'constants.dart';
import 'location.dart';

/// A [RadioListTile] button describing a [Location] (database or specific table).
class DestinationListRadioButton extends StatelessWidget {
  const DestinationListRadioButton({
    super.key,
    required this.title,
    required this.location,
  });

  final String title;
  final Location location;

  @override
  Widget build(BuildContext context) {
    return RadioListTile<Location>(
      tileColor: Colors.transparent,
      dense: true,
      contentPadding: EdgeInsets.only(
        left: BS.paddingSmall,
        right: BS.paddingSmall,
      ),
      visualDensity: VisualDensity.compact,
      title: Text(
        title,
        style: TextStyle(
          color: Theme.of(context).colorScheme.primary,
          height: 1.2,
        ),
      ),
      value: location,
    );
  }
}
